#!/usr/bin/python

"""Constant definitions
"""

import os.path

# $Id: constants.py 7164 2011-09-23 16:33:46Z gerrit $

arts_xml_data = os.getenv("ARTS_XMLDATA_PATH")
if arts_xml_data is not None:
    cheval_dir = os.path.join(arts_xml_data, "atmosphere", "chevallier_91L")
    #cheval_all = os.path.join(cheval_dir, "chevallierl91_all_%s.xml.gz")
    fascod_dir = os.path.join(arts_xml_data, "atmosphere", "fascod")
    garand_dir = os.path.join(arts_xml_data, "atmosphere", "garand")
else:
    cheval_dir = fascod_dir = None

sensor_includes = {
    "amsub_reference": "amsu/amsub.arts",
    "amsub_fast": "amsu/amsub_fast.arts",
    "hirs_reference": "hirs/hirs_reference.arts",
    "hirs_fast": "hirs/hirs_fast.arts",
    "avhrr_reference": "avhrr/avhrr_reference.arts",
    "avhrr_fast": "avhrr/avhrr_fast.arts",
}

sensor_los_ranges = dict(
    amsub = [0, 44],
    hirs = [0, 27],
    avhrr = [0, 1023])

# What species MUST be present for a particular sensor.
# Also defined the order. This is because the control-files predefine
# abs_species.
# TODO: automatically generate this?
sensor_species = {
    "amsub_reference": ["H2O", "O3", "O2", "N2"],
    "hirs_reference": ["H2O", "O3", "CO2", "N2O", "CO", "CH4", "O2", "N2"],
}
# NB: remember that the following two create references to the same
# object, so if one is changed, so is the other; that is, in this case,
# the desired effect
sensor_species["amsub_fast"] = sensor_species["amsub_reference"]
sensor_species["hirs_fast"] = sensor_species["hirs_reference"]
sensor_species["avhrr_reference"] = sensor_species["hirs_reference"]
sensor_species["avhrr_fast"] = sensor_species["hirs_reference"]

well_mixed_species = {
    "N2": 0.7808,
    "O2": 0.2095,
}

dataset_species = dict(
    cheval = "H2O O3".split(),
    garand = "H2O O3 CO2 N2O CO CH4".split(),
    nicam = ["H2O"]
    )

shapes = dict(
    yang_2005 = "AGG BUL DRO HOL PLA SOL".split(),
    hong = "aggregate column droxtal hollow plate rosette".split()
    )

channels = dict(
    hirs = [None, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19],
    avhrr = [None, None, None, 0, 1, 2],
    )

satellites = "NOAA15 NOAA16 NOAA17 NOAA18 NOAA19 METOPA".split()

#amsu_species_order = ["H2O", "O3", "O2", "N2"]
#hirs_species_order = ["H2O", "O3", "CO2", "N2O", "CO", "CH4", "O2", "N2"]

# more-or-less copied from arts/src/optproperties.h

PARTICLE_TYPE_GENERAL = 10
PARTICLE_TYPE_MACROS_ISO = 20
PARTICLE_TYPE_HORIZ_AL = 30
PARTICLE_TYPE_SPHERICAL = 40

all_relevant_cheval = "ccol q rcol t".split()

nicam = dict(p="ms_pres.grd_01",
             clw="ms_qc.grd_01",
             ciw="ms_qi.grd_01",
             rain="ms_qr.grd_01",
             snow="ms_qs.grd_01",
             q="ms_qv.grd_01",
             t="ms_tem.grd_01")

R_d = 287.0 # J K^-1 kg^-1; Wallace and Hobbs Eq. 3.11
R_v = 461.51 # J K^-1 kg^-1; Wallace and Hobbs Eq. 3.13

h = 6.62617e-34  # J s Planck
k = 1.380662e-23 # J/K Boltzmann
c = 2.99792458e8  # m/s speed of light

