from PyARTS import *
from scipy import *

import os

#First generate the cloud stuff

lat1=-2.0
lat2=2.0
lon1=-2.0
lon2=2.0
ztopkm=14.0
zbottomkm=13.0
cb_size={'np':25,'nlat':25,'nlon':25} #no need for 41 lat and lon
zfile='../data/tropical.z.xml'
IWC=0.01
tfile='../data/tropical.t.xml'

npt=10

a_cloud=clouds.boxcloud(ztopkm,zbottomkm,lat1,lat2,
                        lon1,lon2,cb_size,zfile,
                        tfile,IWC)
random_plate=clouds.Crystal(ptype=20,NP=-1,aspect_ratio=2.000001,npoints=npt)
a_cloud.addHydrometeor(random_plate)
a_cloud.scat_file_gen(f_grid=[500e9,503e9],num_proc=2)
a_cloud.pnd_field_gen('pnd_field.xml')
particle_masses=a_cloud.particle_masses()
artsXML.save(particle_masses,'particle_masses.xml')

pnd_vec=[]
#lets check the iwc
for i in range(npt):
    pnd_vec.append(a_cloud.pnd_fields[i].data[12,12,12])
print "IWC = %f" % dot(pnd_vec,particle_masses)


#save your cloud object for later use
general.quickpickle(a_cloud,'cloud.pickle')

#and make yourself a better pressure grid
old_grid=artsXML.load('../data/p_grid.xml')
new_grid=arts_math.gridmerge(old_grid,a_cloud.p_grid[1:-2])
artsXML.save(new_grid,'new_p_grid.xml')

#and also better lat/lon grids
old_grid=artsXML.load('../data/lat_grid.xml')
new_grid=arts_math.gridmerge(old_grid,a_cloud.lat_grid[1:-2])
artsXML.save(new_grid,'new_lat_grid.xml')
old_grid=artsXML.load('../data/lon_grid.xml')
new_grid=arts_math.gridmerge(old_grid,a_cloud.lon_grid[1:-2])
artsXML.save(new_grid,'new_lon_grid.xml')

#And now do the arts simulation
arts_params={
    "atm_basename":"../data/tropical",#changes to 3D later
    "cloud_box":a_cloud.cloudbox,
    'freq':501.18e9,
    "abs_species":["ClO","O3","H2O,H2O-MPM89","N2-SelfContStandardType"],
    "lat_grid":"new_lat_grid.xml",
    "lon_grid":"new_lon_grid.xml",
    'max_iter':1000,
    'particle_masses':'particle_masses.xml',
    "p_grid":"new_p_grid.xml",
    "pnd_field_raw":a_cloud.pnd_file,
#    "rte_pos":{'r_or_z':95000.1+arts_geometry.EARTH_RADIUS,'lat':9.1,'lon':0},
#    "rte_los":{'za':99.14,'aa':180},
    "sensor_pos": [95000.1 + arts_geometry.EARTH_RADIUS, 0, 0], 
    "sensor_los": [179, 189],
    "scat_data_file_list":a_cloud.scat_files,
    "stokes_dim": 1,
    }

# GH 2011-05-18: disabling this test, I cannot get it to work
#
#print "Pencil beam:"
#iwp,tau,iwp_error,tau_error=arts.IWP_cloud_opt_pathCalc(arts_params)
#print 'IWP = %f' % iwp
#print 'cloud optical path = %f' % tau
#
#
#print "Gaussian antenna:"
#arts_params['antenna']={'za_fwhm':0.061,'aa_fwhm':0.121}
#iwp,tau,iwp_error,tau_error=arts.IWP_cloud_opt_pathCalc(arts_params)
#print 'IWP = %f' % iwp
#print 'cloud optical path = %f' % tau
#
#print 'ball-park estimate IWP'
##print IWC*2*(arts_geometry.EARTH_RADIUS+14e3)*sin(2*arts_geometry.DEG2RAD)
#print IWC*(ztopkm-zbottomkm)*1000
