from PyARTS import training_data_generator,artsXML
from numpy import array
import os
import types

if type(os.getenv('ARTS_INCLUDE_PATH'))==types.NoneType:
    raise "This example requires the environment variable ARTS_INCLUDE_PATH to be set"



print "Initialising TrainingDataGenerator - this also extracts non zero IWC points from the atmospheric data set and loads and preprocesses the microphysical data set"
tdg=training_data_generator.TrainingDataGenerator(
    atm_clear_file='../data/chevallierl91_clear_ccol_extract.xml.gz',
    atm_cloud_file='../data/chevallierl91_cloud_ccol_extract.xml.gz',
    identifier='chev',
    PSD_file='../data/phony_PSDs.dat')

#print "plotting the size distribution parameters for each non-zero iwc profile level"
#tdg.plot_psds()

print "finding and testing the basis particle sizes"
tdg.find_basis_particle_sizes(n_sizes=5)

#print "plot the fractional error in total particle volume for each non-zero iwc profile level as calculated by the basis particle sizes"
#tdg.plot_frac_error()

print "setting the habit fraction at each non-zero profile level"
tdg.habit_frac_gen()

print "creating and saving ARTS-ready PND fields"
tdg.pnd_field_calc()

print "creating ARTS-ready single scattering files"
tdg.scat_data_calc(num_proc=1,f_grid=array((87.599,90.401,148.599,
                                            151.401,175.309,191.311))*1e9)

# GH commented out 2011-05-18, this needs updating
#
#print "running ARTS to get radiances"
#tdg.run(ybatch_n=10)
#
#print "Radiances:"
#print tdg.radiances
#artsXML.save(tdg.radiances,'radiances.xml')
#
#print "Plotting radiances"
#import matplotlib
#matplotlib.use('Agg')#use this so that the script doesnt require an open display
#from pylab import *
#data=reshape(tdg.radiances,(45,5,10))
#figure(figsize=(15,6))
#for i in range(10):
#    subplot(2,5,1+i)
#    line_handles=[]
#    for j in range(5):
#        line_handles.append(plot(data[:,j,i]))
#    title('profile %d' % i)
#    if i in [0,5]:
#        ylabel('$T_{b}$')
#    if i>4:
#        xlabel('scan angle')
#    setp(gca(),'ylim',[230,285],'position',
#         (array(gca().get_position())-array((0.07,0,0,0)))*\
#             array((1.0,1.0,1.0,0.8)))
#figlegend(line_handles,
#          ('ch. 1','ch. 2','ch. 3', 'ch. 4', 'ch. 5'),
#          'center right')    
#figtext(0.5,0.9,'AMSU-B radiances for Chevallier Atmospheric Profiles\n training_data_gen.py',horizontalalignment='center',fontsize=16)
#
#savefig('chev_5_radiances.png')
