C   The code was originally  developed by Michael Mishchenko at the NASA      
C   Goddard Institute for Space Studies, New York. This research
C   was funded by the NASA Radiation Science Program.
                                                                       
C   The code can be used without limitations in any not-for-       
C   profit scientific research.  The only request is that in any      
C   publication using the code the source of the code be acknowledged  
C   and relevant references be made. 

C   This version code has been modified by Cory Davis (University 
C   of Edinburgh) for inclusion in the the PyARTS atmospheric radiative 
C   transfer package                                  

!This file is an attempt at an extended precision version of
!tmatrix.subs.f
C********************************************************************
C I think the double ampl,vigampl,sarea,surfch,sareac,gauss are identical to the quad version so it is not
C included here.  amplq.par.f is the same as ampld.par.f                                            
C*****************************************************************
! CPD 20/1/03: Added the input variable 'quiet' to the Tmatrix
! subroutine.  quiet = 1 disables any standard output, unless something
! unusual happens that you probably need to know about.



        SUBROUTINE Tmatrixq(AXI,NP,DLAM,DEPS,DMRR,DMRI,DDELT,NMAX,CSCA,
     &    CEXT,QUIET,ERRMSG)

 
      IMPLICIT REAL*8 (A-H,O-Z)
      INCLUDE 'tmatrix.par.f'
      REAL*16 LAM,MRR,MRI,X(NPNG2),W(NPNG2),S(NPNG2),SS(NPNG2),
     *        AN(NPN1),R(NPNG2),DR(NPNG2),PPI,PIR,PII,P,EPS,A,
     *        DDR(NPNG2),DRR(NPNG2),DRI(NPNG2),ANN(NPN1,NPN1),AIq
      REAL*8 TR1(NPN2,NPN2),TI1(NPN2,NPN2),DLAM,DEPS,DMRR,DMRI
      REAL*8 XALPHA(300),XBETA(300),WALPHA(300),WBETA(300)
      REAL*4
     &     RT11(NPN6,NPN4,NPN4),RT12(NPN6,NPN4,NPN4),
     &     RT21(NPN6,NPN4,NPN4),RT22(NPN6,NPN4,NPN4),
     &     IT11(NPN6,NPN4,NPN4),IT12(NPN6,NPN4,NPN4),
     &     IT21(NPN6,NPN4,NPN4),IT22(NPN6,NPN4,NPN4)
      COMPLEX*16 S11,S12,S21,S22
 	
      INTEGER QUIET
      CHARACTER ERRMSG*100

Cf2py intent(out) NMAX,CSCA,CEXT,ERRMSG	
      COMMON /CT/ TR1,TI1
      COMMON /TMAT/ RT11,RT12,RT21,RT22,IT11,IT12,IT21,IT22
      COMMON /CHOICE/ ICHOICE

      LAM=DLAM
      EPS=DEPS
      MRR=DMRR
      MRI=DMRI
 
c	Make AXI radius of equal volume sphere.
      RAT=1 D0 

C      DDELT=0.001D0 
      NDGS=2

      P=QACOS(-1Q0) !Changed QARCOS to QACOS
      PIN=P
C      ICHOICE=1 only for use with NAG libraries
      ICHOICE=1
      NCHECK=0
      IF (NP.EQ.-1.OR.NP.EQ.-2) NCHECK=1
      IF (NP.GT.0.AND.(-1)**NP.EQ.1) NCHECK=1
      if (quiet /= 1) print 5454,ICHOICE,NCHECK
 5454 FORMAT ('ICHOICE=',I1,'  NCHECK=',I1)
      DLAM=LAM
      DEPS=EPS
      IF (DABS(RAT-1D0).GT.1D-8.AND.NP.EQ.-1) CALL SAREA (DEPS,RAT)
      IF (DABS(RAT-1D0).GT.1D-8.AND.NP.GE.0) CALL SURFCH(NP,DEPS,RAT)
      IF (DABS(RAT-1D0).GT.1D-8.AND.NP.EQ.-2) CALL SAREAC (DEPS,RAT)
      IF (NP.EQ.-3) CALL dropq (RAT)
C     PRINT 8000, RAT
c 8000 FORMAT ('RAT=',F8.6)
      if (quiet /= 1) then
		IF(NP.EQ.-1.AND.EPS.GE.1D0) PRINT 7000,EPS
      	IF(NP.EQ.-1.AND.EPS.LT.1D0) PRINT 7001,EPS
      	IF(NP.GE.0) PRINT 7100,NP,EPS
      	IF(NP.EQ.-2.AND.EPS.GE.1D0) PRINT 7150,EPS
      	IF(NP.EQ.-2.AND.EPS.LT.1D0) PRINT 7151,EPS
      	IF(NP.EQ.-3) PRINT 7160
      	PRINT 7400, LAM,MRR,MRI
      	PRINT 7200,DDELT
	end if
 7000 FORMAT('OBLATE SPHEROIDS, A/B=',F11.7)
 7001 FORMAT('PROLATE SPHEROIDS, A/B=',F11.7)
 7100 FORMAT('CHEBYSHEV PARTICLES, T',
     &       I1,'(',F5.2,')')
 7150 FORMAT('OBLATE CYLINDERS, D/L=',F11.7)
 7151 FORMAT('PROLATE CYLINDERS, D/L=',F11.7)
 7160 FORMAT('GENERALIZED CHEBYSHEV PARTICLES')
 7200 FORMAT ('ACCURACY OF COMPUTATIONS DDELT = ',D8.2)
 7400 FORMAT('LAM=',F11.6,3X,'MRR=',D10.4,3X,'MRI=',D10.4)
      DDELT=0.1D0*DDELT
      IF ((DABS(RAT-1D0).LE.1D-6).and.(quiet/=1)) PRINT 8003, AXI
!      IF ((DABS(RAT-1D0).GT.1D-6).and.(quiet/=1)) PRINT 8004, AXI
 8003 FORMAT('EQUAL-VOLUME-SPHERE RADIUS=',F8.4)
 8004 FORMAT('EQUAL-SURFACE-AREA-SPHERE RADIUS=',F8.4)
      A=RAT*AXI
      XEV=2D0*PIN*A/DLAM
      IXXX=XEV+4.05D0*XEV**0.333333D0
      INM1=MAX0(4,IXXX)
      IF (INM1.GE.NPN1) PRINT 7333, NPN1
      IF (INM1.GE.NPN1) STOP
 7333 FORMAT('CONVERGENCE IS NOT OBTAINED FOR NPN1=',I3,  
     &       '.  EXECUTION TERMINATED')
      QEXT1=0D0
      QSCA1=0D0
      DO 50 NMA=INM1,NPN1
         NMAX=NMA
         MMAX=1
         NGAUSS=NMAX*NDGS
         IF (NGAUSS.GT.NPNG1) PRINT 7340, NGAUSS
         IF (NGAUSS.GT.NPNG1) STOP
 7340    FORMAT('NGAUSS =',I3,' I.E. IS GREATER THAN NPNG1.',
     &          '  EXECUTION TERMINATED')
 7334    FORMAT(' NMAX =', I3,'  DC2=',D8.2,'   DC1=',D8.2)
         CALL constq(NGAUSS,NMAX,MMAX,P,X,W,AN,ANN,S,SS,NP,EPS)
         CALL varyq(LAM,MRR,MRI,A,EPS,NP,NGAUSS,X,P,PPI,PIR,PII,R,
     &              DR,DDR,DRR,DRI,NMAX)
         CALL tmatr0q (NGAUSS,X,W,AN,ANN,S,SS,PPI,PIR,PII,R,DR,
     &                 DDR,DRR,DRI,NMAX,NCHECK)
         QEXT=0D0
         QSCA=0D0
         DO 4 N=1,NMAX
            N1=N+NMAX
            TR1NN=TR1(N,N)
            TI1NN=TI1(N,N)
            TR1NN1=TR1(N1,N1)
            TI1NN1=TI1(N1,N1)
            DN1=DFLOAT(2*N+1)
            QSCA=QSCA+DN1*(TR1NN*TR1NN+TI1NN*TI1NN
     &                    +TR1NN1*TR1NN1+TI1NN1*TI1NN1)
            QEXT=QEXT+(TR1NN+TR1NN1)*DN1
    4    CONTINUE
         DSCA=DABS((QSCA1-QSCA)/QSCA)
         DEXT=DABS((QEXT1-QEXT)/QEXT)
         QEXT1=QEXT
         QSCA1=QSCA
C        PRINT 7334, NMAX,DSCA,DEXT
         IF(DSCA.LE.DDELT.AND.DEXT.LE.DDELT) GO TO 55
         IF (NMA.EQ.NPN1) PRINT 7333, NPN1
         IF (NMA.EQ.NPN1) STOP      
   50 CONTINUE
   55 NNNGGG=NGAUSS+1
      MMAX=NMAX
      IF (NGAUSS.EQ.NPNG1) PRINT 7336
      IF (NGAUSS.EQ.NPNG1) GO TO 155 
      DO 150 NGAUS=NNNGGG,NPNG1
         NGAUSS=NGAUS
         NGGG=2*NGAUSS
 7336    FORMAT('WARNING: NGAUSS=NPNG1')
 7337    FORMAT(' NG=',I3,'  DC2=',D8.2,'   DC1=',D8.2)
         CALL constq(NGAUSS,NMAX,MMAX,P,X,W,AN,ANN,S,SS,NP,EPS)
         CALL varyq(LAM,MRR,MRI,A,EPS,NP,NGAUSS,X,P,PPI,PIR,PII,R,
     &              DR,DDR,DRR,DRI,NMAX)
         CALL tmatr0q (NGAUSS,X,W,AN,ANN,S,SS,PPI,PIR,PII,R,DR,
     &                 DDR,DRR,DRI,NMAX,NCHECK)
         QEXT=0D0
         QSCA=0D0
         DO 104 N=1,NMAX
            N1=N+NMAX
            TR1NN=TR1(N,N)
            TI1NN=TI1(N,N)
            TR1NN1=TR1(N1,N1)
            TI1NN1=TI1(N1,N1)
            DN1=DFLOAT(2*N+1)
            QSCA=QSCA+DN1*(TR1NN*TR1NN+TI1NN*TI1NN
     &                    +TR1NN1*TR1NN1+TI1NN1*TI1NN1)
            QEXT=QEXT+(TR1NN+TR1NN1)*DN1
  104    CONTINUE
         DSCA=DABS((QSCA1-QSCA)/QSCA)
         DEXT=DABS((QEXT1-QEXT)/QEXT)
c        PRINT 7337, NGGG,DSCA,DEXT
         QEXT1=QEXT
         QSCA1=QSCA
         IF(DSCA.LE.DDELT.AND.DEXT.LE.DDELT) GO TO 155
         IF (NGAUS.EQ.NPNG1) PRINT 7336
  150 CONTINUE
  155 CONTINUE
      QSCA=0D0
      QEXT=0D0
      NNM=NMAX*2
      DO 204 N=1,NNM
         QEXT=QEXT+TR1(N,N)
  204 CONTINUE
      DO 213 N2=1,NMAX
         NN2=N2+NMAX
         DO 213 N1=1,NMAX
            NN1=N1+NMAX
            ZZ1=TR1(N1,N2)
            RT11(1,N1,N2)=ZZ1
            ZZ2=TI1(N1,N2)
            IT11(1,N1,N2)=ZZ2
            ZZ3=TR1(N1,NN2)
            RT12(1,N1,N2)=ZZ3
            ZZ4=TI1(N1,NN2)
            IT12(1,N1,N2)=ZZ4
            ZZ5=TR1(NN1,N2)
            RT21(1,N1,N2)=ZZ5
            ZZ6=TI1(NN1,N2)
            IT21(1,N1,N2)=ZZ6
            ZZ7=TR1(NN1,NN2)
            RT22(1,N1,N2)=ZZ7
            ZZ8=TI1(NN1,NN2)
            IT22(1,N1,N2)=ZZ8
            QSCA=QSCA+ZZ1*ZZ1+ZZ2*ZZ2+ZZ3*ZZ3+ZZ4*ZZ4
     &           +ZZ5*ZZ5+ZZ6*ZZ6+ZZ7*ZZ7+ZZ8*ZZ8
  213 CONTINUE
c     PRINT 7800,0,DABS(QEXT),QSCA,NMAX
      DO 220 M=1,NMAX
         CALL tmatrq(M,NGAUSS,X,W,AN,ANN,S,SS,PPI,PIR,PII,R,DR,
     &               DDR,DRR,DRI,NMAX,NCHECK)
         NM=NMAX-M+1
         M1=M+1
         QSC=0D0
         DO 214 N2=1,NM
            NN2=N2+M-1
            N22=N2+NM
            DO 214 N1=1,NM
               NN1=N1+M-1
               N11=N1+NM
               ZZ1=TR1(N1,N2)
               RT11(M1,NN1,NN2)=ZZ1
               ZZ2=TI1(N1,N2)
               IT11(M1,NN1,NN2)=ZZ2
               ZZ3=TR1(N1,N22)
               RT12(M1,NN1,NN2)=ZZ3
               ZZ4=TI1(N1,N22)
               IT12(M1,NN1,NN2)=ZZ4
               ZZ5=TR1(N11,N2)
               RT21(M1,NN1,NN2)=ZZ5
               ZZ6=TI1(N11,N2)
               IT21(M1,NN1,NN2)=ZZ6
               ZZ7=TR1(N11,N22)
               RT22(M1,NN1,NN2)=ZZ7
               ZZ8=TI1(N11,N22)
               IT22(M1,NN1,NN2)=ZZ8
               QSC=QSC+(ZZ1*ZZ1+ZZ2*ZZ2+ZZ3*ZZ3+ZZ4*ZZ4
     &                 +ZZ5*ZZ5+ZZ6*ZZ6+ZZ7*ZZ7+ZZ8*ZZ8)*2D0
  214    CONTINUE
         NNM=2*NM
         QXT=0D0
         DO 215 N=1,NNM
            QXT=QXT+TR1(N,N)*2D0
  215    CONTINUE
         QSCA=QSCA+QSC
         QEXT=QEXT+QXT
c        PRINT 7800,M,DABS(QXT),QSC,NMAX
 7800    FORMAT(' m=',I3,'  qxt=',D12.6,'  qsc=',D12.6,
     &          '  nmax=',I3)
  220 CONTINUE
      WALB=-QSCA/QEXT
      IF (WALB.GT.1D0+DDELT) PRINT 9111
 9111 FORMAT ('WARNING: W IS GREATER THAN 1')
!Calculate Scattering cross-section and extinction cross-section
!for randomly oriented particles
	CSCA=QSCA*LAM**2/2/P
	CEXT=-QEXT*LAM**2/2/P

 	return
	end
 

C**********************************************************************
C                                                                     *
C   INPUT PARAMETERS:                                                 *
C                                                                     *
C   NG = 2*NGAUSS - number of gaussian quadrature points on the       *
C                   interval  (-1,1). NGAUSS.LE.NPNG1                 *
C   NMAX,MMAX - maximum dimensions of the arrays.  NMAX.LE.NPN1       *
C               MMAX.LE.NPN1                                          *
C   P - pi                                                            *
C                                                                     *
C   OUTPUT PARAMETERS:                                                *
C                                                                     *
C   X,W - points and weights of the quadrature formula                *
C   AN(N) = n*(n+1)                                                   *
C   ANN(N1,N2) = (1/2)*sqrt((2*n1+1)*(2*n2+1)/(n1*(n1+1)*n2*(n2+1)))  *
C   S(I)=1/sin(arccos(x(i)))                                          *
C   SS(I)=S(I)**2                                                     *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE constq (NGAUSS,NMAX,MMAX,P,X,W,AN,ANN,S,SS,NP,EPS)
      IMPLICIT REAL*16 (A-H,O-Z)
      INCLUDE 'tmatrix.par.f'
      REAL*16 X(NPNG2),W(NPNG2),X1(NPNG1),W1(NPNG1),
     *        X2(NPNG1),W2(NPNG1),
     *        S(NPNG2),SS(NPNG2),
     *        AN(NPN1),ANN(NPN1,NPN1),DD(NPN1)
 
      DO 10 N=1,NMAX
           NN=N*(N+1)
           AN(N)=QFLOAT(NN)
           D=QSQRT(QFLOAT(2*N+1)/QFLOAT(NN))
           DD(N)=D
           DO 10 N1=1,N
                DDD=D*DD(N1)*0.5Q0
                ANN(N,N1)=DDD
                ANN(N1,N)=DDD
   10 CONTINUE
      NG=2*NGAUSS
      IF (NP.EQ.-2) GO  TO 11
      CALL QGAUSS(NG,0,0,X,W)
      GO TO 19
   11 NG1=DFLOAT(NGAUSS)/2D0
      NG2=NGAUSS-NG1
      XX=-QCOS(QATAN(EPS))
      CALL QGAUSS(NG1,0,0,X1,W1)
      CALL QGAUSS(NG2,0,0,X2,W2)
      DO 12 I=1,NG1
         W(I)=0.5Q0*(XX+1Q0)*W1(I)
         X(I)=0.5Q0*(XX+1Q0)*X1(I)+0.5Q0*(XX-1Q0)
   12 CONTINUE
      DO 14 I=1,NG2
         W(I+NG1)=-0.5Q0*XX*W2(I)
         X(I+NG1)=-0.5Q0*XX*X2(I)+0.5Q0*XX
   14 CONTINUE
      DO 16 I=1,NGAUSS
         W(NG-I+1)=W(I)
         X(NG-I+1)=-X(I)
   16 CONTINUE
   19 DO 20 I=1,NGAUSS
           Y=X(I)
           Y=1Q0/(1Q0-Y*Y)
           SS(I)=Y
           SS(NG-I+1)=Y
           Y=QSQRT(Y)
           S(I)=Y
           S(NG-I+1)=Y
   20 CONTINUE
      RETURN
      END
 
C***************************************************************
 
      SUBROUTINE QGAUSS ( N,IND1,IND2,Z,W )
      IMPLICIT REAL*16 (A-H,P-Z)
      REAL*16 Z(N),W(N)
      DATA A,B,C /1Q0,2Q0,3Q0/
      IND=MOD(N,2)
      K=N/2+IND
      F=QFLOAT(N)
      DO 100 I=1,K
          M=N+1-I
          IF(I.EQ.1) X=A-B/((F+A)*F)
          IF(I.EQ.2) X=(Z(N)-A)*4Q0+Z(N)
          IF(I.EQ.3) X=(Z(N-1)-Z(N))*1.6Q0+Z(N-1)
          IF(I.GT.3) X=(Z(M+1)-Z(M+2))*C+Z(M+3)
          IF(I.EQ.K.AND.IND.EQ.1) X=0Q0
          NITER=0
          CHECK=1Q-32
   10     PB=1Q0
          NITER=NITER+1
          IF (NITER.LE.100) GO TO 15
c         PRINT 5000, CHECK
          CHECK=CHECK*10Q0
   15     PC=X
          DJ=A
          DO 20 J=2,N
              DJ=DJ+A
              PA=PB
              PB=PC
   20         PC=X*PB+(X*PB-PA)*(DJ-A)/DJ
          PA=A/((PB-X*PC)*F)
          PB=PA*PC*(A-X*X)
          X=X-PB
          IF(QABS(PB).GT.CHECK*QABS(X)) GO TO 10
          Z(M)=X
          W(M)=PA*PA*(A-X*X)
          IF(IND1.EQ.0) W(M)=B*W(M)
          IF(I.EQ.K.AND.IND.EQ.1) GO TO 100
          Z(I)=-Z(M)
          W(I)=W(M)
  100 CONTINUE
 5000 format ('QGAUSS DOES NOT CONVERGE, CHECK=',F10.3)!Q10.3 didn't
 									!compile
      IF(IND2.NE.1) GO TO 110
      PRINT 1100,N
 1100 FORMAT(' ***  POINTS AND WEIGHTS OF GAUSSIAN QUADRATURE FORMULA',
     * ' OF ',I4,'-TH ORDER')
      DO 105 I=1,K
          ZZ=-Z(I)
  105     PRINT 1200,I,ZZ,I,W(I)
 1200 FORMAT(' ',4X,'X(',I4,') = ',F17.14,5X,'W(',I4,') = ',F17.14)
      GO TO 115
  110 CONTINUE
C     PRINT 1300,N
 1300 FORMAT(' GAUSSIAN QUADRATURE FORMULA OF ',I4,'-TH ORDER IS USED')
  115 CONTINUE
      IF(IND1.EQ.0) GO TO 140
      DO 120 I=1,N
  120     Z(I)=(A+Z(I))/B
  140 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   INPUT PARAMETERS:                                                 *
C                                                                     *
C   LAM - wavelength of light                                         *
C   MRR and MRI - real and imaginary parts of the refractive index    *
C   A,EPS,NP - specify shape of the particle                          *
C              (see subroutines rsp1q, rsp2q, and rsp3q)                 *
C   NG = NGAUSS*2 - number of gaussian quadrature points on the       *
C                   interval  (-1,1)                                  *
C   X - gaussian division points                                      *
C   P - pi                                                            *
C                                                                     *
C   OUTPUT INFORMATION:                                               *
C                                                                     *
C   PPI = PI**2 , where PI = (2*P)/LAM (wavenumber)                   *
C   PIR = PPI*MRR                                                     *
C   PII = PPI*MRI                                                     *
C   R and DR - see subroutines rsp1q, rsp2q, and rsp3q                   *
C   DDR=1/(PI*SQRT(R))                                                *
C   DRR+I*DRI=DDR/(MRR+I*MRI)                                         *
C   NMAX - dimension of T(m)-matrices                                 *
C   arrays  J,Y,JR,JI,DJ,DY,DJR,DJI are transferred through           *
C         COMMON /Cbessq/ - see subroutine bessq                        *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE varyq (LAM,MRR,MRI,A,EPS,NP,NGAUSS,X,P,PPI,PIR,PII,
     *                 R,DR,DDR,DRR,DRI,NMAX)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NPNG2),R(NPNG2),DR(NPNG2),MRR,MRI,LAM,
     *        Z(NPNG2),ZR(NPNG2),ZI(NPNG2),
     *        J(NPNG2,NPN1),Y(NPNG2,NPN1),JR(NPNG2,NPN1),
     *        JI(NPNG2,NPN1),DJ(NPNG2,NPN1),
     *        DJR(NPNG2,NPN1),DJI(NPNG2,NPN1),DDR(NPNG2),
     *        DRR(NPNG2),DRI(NPNG2),
     *        DY(NPNG2,NPN1)
      COMMON /Cbessq/ J,Y,JR,JI,DJ,DY,DJR,DJI
      NG=NGAUSS*2
      IF (NP.EQ.-1) CALL rsp1q(X,NG,NGAUSS,A,EPS,NP,R,DR)
      IF (NP.GE.0) CALL rsp2q(X,NG,A,EPS,NP,R,DR)
      IF (NP.EQ.-2) CALL rsp3q(X,NG,NGAUSS,A,EPS,R,DR)
      IF (NP.EQ.-3) CALL rsp4q(X,NG,A,R,DR)
      PI=P*2Q0/LAM
      PPI=PI*PI
      PIR=PPI*MRR
      PII=PPI*MRI
      V=1Q0/(MRR*MRR+MRI*MRI)
      PRR=MRR*V
      PRI=-MRI*V
      TA=0Q0
      DO 10 I=1,NG
           VV=QSQRT(R(I))
           V=VV*PI
           TA=MAX(TA,V)
           VV=1Q0/V
           DDR(I)=VV
           DRR(I)=PRR*VV
           DRI(I)=PRI*VV
           V1=V*MRR
           V2=V*MRI
           Z(I)=V
           ZR(I)=V1
           ZI(I)=V2
   10 CONTINUE
      IF (NMAX.GT.NPN1) PRINT 9000,NMAX,NPN1
      IF (NMAX.GT.NPN1) STOP
 9000 FORMAT(' NMAX = ',I2,', i.e., greater than ',I3)
      TB=TA*QSQRT(MRR*MRR+MRI*MRI)
      TB=QMAX1(TB,QFLOAT(NMAX))
      NNMAX1=8.0Q0*QSQRT(QMAX1(TA,QFLOAT(NMAX)))+3Q0
      NNMAX2=(TB+4Q0*(TB**0.33333Q0)+8.0Q0*QSQRT(TB))
      NNMAX2=NNMAX2-NMAX+5
      CALL bessq(Z,ZR,ZI,NG,NMAX,NNMAX1,NNMAX2)
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of the functions R(I)=r(y)**2 and                     *
C   DR(I)=((d/dy)r(y))/r(y) and horizontal semi-axis A                *
C   for a spheroid specified by the parameters REV (equal-volume-     *
C   sphere radius) and EPS=A/B (ratio of the semi-axes).              *
C   Y(I)=arccos(X(I))                                                 *
C   1.LE.I.LE.NGAUSS                                                  *
C   X - arguments                                                     *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE rsp1q (X,NG,NGAUSS,REV,EPS,NP,R,DR)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NG),R(NG),DR(NG)
      A=REV*EPS**(1Q0/3Q0)
      AA=A*A
      EE=EPS*EPS
      EE1=EE-1Q0
      DO 50 I=1,NGAUSS
          C=X(I)
          CC=C*C
          SS=1Q0-CC
          S=QSQRT(SS)
          RR=1Q0/(SS+EE*CC)
          R(I)=AA*RR
          R(NG-I+1)=R(I)
          DR(I)=RR*C*S*EE1
          DR(NG-I+1)=-DR(I)
   50 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of the functions R(I)=r(y)**2 and                     *
C   DR(I)=((d/dy)r(y))/r(y) and parameter R0 for a Chebyshev          *
C   particle specified by the parameters REV (equal-volume-sphere     *
C   radius), EPS, and N.                                              *
C   Y(I)=arccos(X(I))                                                 *
C   1.LE.I.LE.NGAUSS                                                  *
C   X - arguments                                                     *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE rsp2q (X,NG,REV,EPS,N,R,DR)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NG),R(NG),DR(NG)
      DNP=QFLOAT(N)
      DN=DNP*DNP
      DN4=DN*4Q0
      EP=EPS*EPS
      A=1Q0+1.5Q0*EP*(DN4-2Q0)/(DN4-1Q0)
      I=(DNP+0.1Q0)*0.5Q0
      I=2*I
      IF (I.EQ.N) A=A-3Q0*EPS*(1Q0+0.25Q0*EP)/
     *              (DN-1Q0)-0.25Q0*EP*EPS/(9Q0*DN-1Q0)
      R0=REV*A**(-1Q0/3Q0)
      DO 50 I=1,NG
         XI=QACOS(X(I))*DNP	!Changed QARCOS to QACOS
         RI=R0*(1Q0+EPS*QCOS(XI))
         R(I)=RI*RI
         DR(I)=-R0*EPS*DNP*QSIN(XI)/RI
   50 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of the functions R(I)=r(y)**2 and                     *
C   DR(I)=((d/dy)r(y))/r(y)                                           *
C   for a cylinder specified by the parameters REV (equal-volume-     *
C   sphere radius) and EPS=A/H (ratio of radius to semi-length)       *
C   Y(I)=arccos(X(I))                                                 *
C   1.LE.I.LE.NGAUSS                                                  *
C   X - arguments                                                     *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE rsp3q (X,NG,NGAUSS,REV,EPS,R,DR)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NG),R(NG),DR(NG)
      H=REV*( (2Q0/(3Q0*EPS*EPS))**(1Q0/3Q0) )
      A=H*EPS
      DO 50 I=1,NGAUSS
         CO=-X(I)
         SI=QSQRT(1Q0-CO*CO)
         IF (SI/CO.GT.A/H) GO TO 20
         RAD=H/CO
         RTHET=H*SI/(CO*CO)
         GO TO 30
   20    RAD=A/SI
         RTHET=-A*CO/(SI*SI)
   30    R(I)=RAD*RAD
         R(NG-I+1)=R(I)
         DR(I)=-RTHET/RAD
         DR(NG-I+1)=-DR(I)
   50 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of the functions R(I)=r(y)**2 and                     *
C   DR(I)=((d/dy)r(y))/r(y) for a distorted                           *
C   droplet specified by the parameters r_ev (equal-volume-sphere     *
C   radius) and c_n (Chebyshev expansion coefficients)                *
C   Y(I)=arccos(X(I))                                                 *
C   1.LE.I.LE.NGAUSS                                                  *
C   X - arguments                                                     *
C                                                                     *
C**********************************************************************

      SUBROUTINE rsp4q (X,NG,REV,R,DR)
      PARAMETER (NC=10)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NG),R(NG),DR(NG),C(0:NC)
      COMMON /Cdropq/ C,R0V
      R0=REV*R0V
      DO I=1,NG
         XI=QACOS(X(I))
         RI=1Q0+C(0)
         DRI=0Q0
         DO N=1,NC
            XIN=XI*N
            RI=RI+C(N)*QCOS(XIN)
            DRI=DRI-C(N)*N*QSIN(XIN)
         ENDDO
         RI=RI*R0
         DRI=DRI*R0
         R(I)=RI*RI
         DR(I)=DRI/RI
C        WRITE (6,*) I,R(I),DR(I)
      ENDDO
      RETURN
      END

C**********************************************************************
C                                                                     *
C   Calculation of spherical Bessel functions of the first kind       *
C   J(I,N) = j_n(x) and second kind Y(I,N) = y_n(x)                   *
C   of real-valued argument X(I) and first kind JR(I,N)+I*JI(I,N) =   *
C   = j_n(z) of complex argument Z(I)=XR(I)+I*XI(I), as well as       *
C   the functions                                                     *
C                                                                     *
C   DJ(I,N) = (1/x)(d/dx)(x*j_n(x)) ,                                 *
C   DY(I,N) = (1/x)(d/dx)(x*y_n(x)) ,                                 *
C   DJR(I,N) = Re ((1/z)(d/dz)(z*j_n(x)) ,                            *
C   DJI(I,N) = Im ((1/z)(d/dz)(z*j_n(x)) .                            *
C                                                                     *
C   1.LE.N.LE.NMAX                                                    *
C   NMAX.LE.NPN1                                                      *
C   X,XR,XI - arguments                                               *
C   1.LE.I.LE.NG                                                      *
C   Arrays  J,Y,JR,JI,DJ,DY,DJR,DJI are in                            *
C         COMMON /Cbessq/                                              *
C   Parameters NNMAX1 and NMAX2 determine computational accuracy      *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE bessq (X,XR,XI,NG,NMAX,NNMAX1,NNMAX2)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NG),XR(NG),XI(NG),
     *        J(NPNG2,NPN1),Y(NPNG2,NPN1),JR(NPNG2,NPN1),
     *        JI(NPNG2,NPN1),DJ(NPNG2,NPN1),DY(NPNG2,NPN1),
     *        DJR(NPNG2,NPN1),DJI(NPNG2,NPN1),
     *        AJ(NPN1),AY(NPN1),AJR(NPN1),AJI(NPN1),
     *        ADJ(NPN1),ADY(NPN1),ADJR(NPN1),
     *        ADJI(NPN1)
      COMMON /Cbessq/ J,Y,JR,JI,DJ,DY,DJR,DJI
 
      DO 10 I=1,NG
           XX=X(I)
           CALL rjbq(XX,AJ,ADJ,NMAX,NNMAX1)
           CALL rybq(XX,AY,ADY,NMAX)
           YR=XR(I)
           YI=XI(I)
           CALL cjbq(YR,YI,AJR,AJI,ADJR,ADJI,NMAX,NNMAX2)
           DO 10 N=1,NMAX
                J(I,N)=AJ(N)
                Y(I,N)=AY(N)
                JR(I,N)=AJR(N)
                JI(I,N)=AJI(N)
                DJ(I,N)=ADJ(N)
                DY(I,N)=ADY(N)
                DJR(I,N)=ADJR(N)
                DJI(I,N)=ADJI(N)
   10 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of spherical Bessel functions of the first kind j     *
C   of real-valued argument x of orders from 1 to NMAX by using       *
C   backward recursion. Parametr NNMAX determines numerical accuracy. *
C   U - function (1/x)(d/dx)(x*j(x))                                  *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE rjbq(X,Y,U,NMAX,NNMAX)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 Y(NMAX),U(NMAX),Z(900)
      L=NMAX+NNMAX
      XX=1Q0/X
      Z(L)=1Q0/(QFLOAT(2*L+1)*XX)
      L1=L-1
      DO 5 I=1,L1
         I1=L-I
         Z(I1)=1Q0/(QFLOAT(2*I1+1)*XX-Z(I1+1))
    5 CONTINUE
      Z0=1Q0/(XX-Z(1))
      Y0=Z0*QCOS(X)*XX
      Y1=Y0*Z(1)
      U(1)=Y0-Y1*XX
      Y(1)=Y1
      DO 10 I=2,NMAX
         YI1=Y(I-1)
         YI=YI1*Z(I)
         U(I)=YI1-QFLOAT(I)*YI*XX
         Y(I)=YI
   10 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of spherical Bessel functions of the second kind y    *
C   of real-valued argument x of orders from 1 to NMAX by using upward*
C   recursion. V - function (1/x)(d/dx)(x*y(x))                       *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE rybq(X,Y,V,NMAX)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 Y(NMAX),V(NMAX)
      C=QCOS(X)
      S=QSIN(X)
      X1=1Q0/X
      X2=X1*X1
      X3=X2*X1
      Y1=-C*X2-S*X1
      Y(1)=Y1
      Y(2)=(-3Q0*X3+X1)*C-3Q0*X2*S
      NMAX1=NMAX-1
      DO 5 I=2,NMAX1
    5     Y(I+1)=QFLOAT(2*I+1)*X1*Y(I)-Y(I-1)
      V(1)=-X1*(C+Y1)
      DO 10 I=2,NMAX
  10       V(I)=Y(I-1)-QFLOAT(I)*X1*Y(I)
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of spherical Bessel functions of the first kind       *
C   j=JR+I*JI of complex argument x=XR+I*XI of orders from 1 to NMAX  *
C   by using backward recursion. Parametr NNMAX determines numerical  *
C   accuracy. U=UR+I*UI - function (1/x)(d/dx)(x*j(x))                *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE cjbq (XR,XI,YR,YI,UR,UI,NMAX,NNMAX)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 YR(NMAX),YI(NMAX),UR(NMAX),UI(NMAX)
      REAL*16 CYR(NPN1),CYI(NPN1),CZR(1200),CZI(1200),
     *        CUR(NPN1),CUI(NPN1)
      L=NMAX+NNMAX
      XRXI=1Q0/(XR*XR+XI*XI)
      CXXR=XR*XRXI
      CXXI=-XI*XRXI 
      QF=1Q0/QFLOAT(2*L+1)
      CZR(L)=XR*QF
      CZI(L)=XI*QF
      L1=L-1
      DO 5 I=1,L1
         I1=L-I
         QF=QFLOAT(2*I1+1)
         AR=QF*CXXR-CZR(I1+1)
         AI=QF*CXXI-CZI(I1+1)
         ARI=1Q0/(AR*AR+AI*AI)
         CZR(I1)=AR*ARI
         CZI(I1)=-AI*ARI
    5 CONTINUE
      AR=CXXR-CZR(1)
      AI=CXXI-CZI(1)
      ARI=1Q0/(AR*AR+AI*AI)
      CZ0R=AR*ARI
      CZ0I=-AI*ARI
      CR=QCOS(XR)*QCOSH(XI)
      CI=-QSIN(XR)*QSINH(XI)
      AR=CZ0R*CR-CZ0I*CI
      AI=CZ0I*CR+CZ0R*CI
      CY0R=AR*CXXR-AI*CXXI
      CY0I=AI*CXXR+AR*CXXI
      CY1R=CY0R*CZR(1)-CY0I*CZI(1)
      CY1I=CY0I*CZR(1)+CY0R*CZI(1)
      AR=CY1R*CXXR-CY1I*CXXI
      AI=CY1I*CXXR+CY1R*CXXI
      CU1R=CY0R-AR
      CU1I=CY0I-AI
      CYR(1)=CY1R
      CYI(1)=CY1I
      CUR(1)=CU1R
      CUI(1)=CU1I
      YR(1)=CY1R
      YI(1)=CY1I
      UR(1)=CU1R
      UI(1)=CU1I
      DO 10 I=2,NMAX
         QI=QFLOAT(I)
         CYI1R=CYR(I-1)
         CYI1I=CYI(I-1)
         CYIR=CYI1R*CZR(I)-CYI1I*CZI(I)
         CYII=CYI1I*CZR(I)+CYI1R*CZI(I)
         AR=CYIR*CXXR-CYII*CXXI
         AI=CYII*CXXR+CYIR*CXXI
         CUIR=CYI1R-QI*AR
         CUII=CYI1I-QI*AI
         CYR(I)=CYIR
         CYI(I)=CYII
         CUR(I)=CUIR
         CUI(I)=CUII
         YR(I)=CYIR
         YI(I)=CYII
         UR(I)=CUIR
         UI(I)=CUII
   10 CONTINUE
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   calculation of the T(0) matrix for an axially symmetric particle  *
C                                                                     *
C   Output information:                                               *
C                                                                     *
C   Arrays  TR1 and TI1 (real and imaginary parts of the              *
C   T(0) matrix) are in COMMON /CT/                                   *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE tmatr0q (NGAUSS,X,W,AN,ANN,S,SS,PPI,PIR,PII,R,DR,DDR,
     *                  DRR,DRI,NMAX,NCHECK)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NPNG2),W(NPNG2),AN(NPN1),S(NPNG2),SS(NPNG2),
     *        R(NPNG2),DR(NPNG2),SIG(NPN2),
     *        J(NPNG2,NPN1),Y(NPNG2,NPN1),
     *        JR(NPNG2,NPN1),JI(NPNG2,NPN1),DJ(NPNG2,NPN1),
     *        DY(NPNG2,NPN1),DJR(NPNG2,NPN1),
     *        DJI(NPNG2,NPN1),DDR(NPNG2),DRR(NPNG2),
     *        D1(NPNG2,NPN1),D2(NPNG2,NPN1),
     *        DRI(NPNG2),DS(NPNG2),DSS(NPNG2),RR(NPNG2),
     *        DV1(NPN1),DV2(NPN1)
 
      REAL*16 R11(NPN1,NPN1),R12(NPN1,NPN1),
     *        R21(NPN1,NPN1),R22(NPN1,NPN1),
     *        I11(NPN1,NPN1),I12(NPN1,NPN1),
     *        I21(NPN1,NPN1),I22(NPN1,NPN1),
     *        RG11(NPN1,NPN1),RG12(NPN1,NPN1),
     *        RG21(NPN1,NPN1),RG22(NPN1,NPN1),
     *        IG11(NPN1,NPN1),IG12(NPN1,NPN1),
     *        IG21(NPN1,NPN1),IG22(NPN1,NPN1),
     *        ANN(NPN1,NPN1),
     *        QR(NPN2,NPN2),QI(NPN2,NPN2),
     *        RGQR(NPN2,NPN2),RGQI(NPN2,NPN2),
     *        TQR(NPN2,NPN2),TQI(NPN2,NPN2),
     *        TRGQR(NPN2,NPN2),TRGQI(NPN2,NPN2)
      REAL*8 TR1(NPN2,NPN2),TI1(NPN2,NPN2)
      COMMON /TMAT99/ 
     &            R11,R12,R21,R22,I11,I12,I21,I22,RG11,RG12,RG21,RG22,
     &            IG11,IG12,IG21,IG22
      COMMON /Cbessq/ J,Y,JR,JI,DJ,DY,DJR,DJI
      COMMON /CT/ TR1,TI1
      COMMON /Cttq/ QR,QI,RGQR,RGQI
      MM1=1
      NNMAX=NMAX+NMAX
      NG=2*NGAUSS
      NGSS=NG
      FACTOR=1Q0
      IF (NCHECK.EQ.1) THEN
            NGSS=NGAUSS
            FACTOR=2Q0
         ELSE
            CONTINUE
      ENDIF
      SI=1Q0
      DO 5 N=1,NNMAX
           SI=-SI
           SIG(N)=SI
    5 CONTINUE
   20 DO 25 I=1,NGAUSS
         I1=NGAUSS+I
         I2=NGAUSS-I+1
         CALL vigq (X(I1),NMAX,0,DV1,DV2)
         DO 25 N=1,NMAX
            SI=SIG(N)
            DD1=DV1(N)
            DD2=DV2(N)
            D1(I1,N)=DD1
            D2(I1,N)=DD2
            D1(I2,N)=DD1*SI
            D2(I2,N)=-DD2*SI
   25 CONTINUE
   30 DO 40 I=1,NGSS
           RR(I)=W(I)*R(I)
   40 CONTINUE
 
      DO 300  N1=MM1,NMAX
           AN1=AN(N1)
           DO 300 N2=MM1,NMAX
                AN2=AN(N2)
                AR12=0Q0
                AR21=0Q0
                AI12=0Q0
                AI21=0Q0
                GR12=0Q0
                GR21=0Q0
                GI12=0Q0
                GI21=0Q0
                IF (NCHECK.EQ.1.AND.SIG(N1+N2).LT.0Q0) GO TO 205
                DO 200 I=1,NGSS
                    D1N1=D1(I,N1)
                    D2N1=D2(I,N1)
                    D1N2=D1(I,N2)
                    D2N2=D2(I,N2)
                    A12=D1N1*D2N2
                    A21=D2N1*D1N2
                    A22=D2N1*D2N2
                    AA1=A12+A21
 
                    QJ1=J(I,N1)
                    QY1=Y(I,N1)
                    QJR2=JR(I,N2)
                    QJI2=JI(I,N2)
                    QDJR2=DJR(I,N2)
                    QDJI2=DJI(I,N2)
                    QDJ1=DJ(I,N1)
                    QDY1=DY(I,N1)
 
                    C1R=QJR2*QJ1
                    C1I=QJI2*QJ1
                    B1R=C1R-QJI2*QY1
                    B1I=C1I+QJR2*QY1
 
                    C2R=QJR2*QDJ1
                    C2I=QJI2*QDJ1
                    B2R=C2R-QJI2*QDY1
                    B2I=C2I+QJR2*QDY1
 
                    DDRI=DDR(I)
                    C3R=DDRI*C1R
                    C3I=DDRI*C1I
                    B3R=DDRI*B1R
                    B3I=DDRI*B1I
 
                    C4R=QDJR2*QJ1
                    C4I=QDJI2*QJ1
                    B4R=C4R-QDJI2*QY1
                    B4I=C4I+QDJR2*QY1
 
                    DRRI=DRR(I)
                    DRII=DRI(I)
                    C5R=C1R*DRRI-C1I*DRII
                    C5I=C1I*DRRI+C1R*DRII
                    B5R=B1R*DRRI-B1I*DRII
                    B5I=B1I*DRRI+B1R*DRII
 
                    URI=DR(I)
                    RRI=RR(I)
 
                    F1=RRI*A22
                    F2=RRI*URI*AN1*A12
                    AR12=AR12+F1*B2R+F2*B3R
                    AI12=AI12+F1*B2I+F2*B3I
                    GR12=GR12+F1*C2R+F2*C3R
                    GI12=GI12+F1*C2I+F2*C3I
 
                    F2=RRI*URI*AN2*A21
                    AR21=AR21+F1*B4R+F2*B5R
                    AI21=AI21+F1*B4I+F2*B5I
                    GR21=GR21+F1*C4R+F2*C5R
                    GI21=GI21+F1*C4I+F2*C5I
  200           CONTINUE
 
  205           AN12=ANN(N1,N2)*FACTOR 
                R12(N1,N2)=AR12*AN12
                R21(N1,N2)=AR21*AN12
                I12(N1,N2)=AI12*AN12
                I21(N1,N2)=AI21*AN12
                RG12(N1,N2)=GR12*AN12
                RG21(N1,N2)=GR21*AN12
                IG12(N1,N2)=GI12*AN12
                IG21(N1,N2)=GI21*AN12
  300 CONTINUE
 
      TPIR=PIR
      TPII=PII
      TPPI=PPI
 
      NM=NMAX
      DO 310 N1=MM1,NMAX
           K1=N1-MM1+1
           KK1=K1+NM
           DO 310 N2=MM1,NMAX
                K2=N2-MM1+1
                KK2=K2+NM
 
                TAR12= I12(N1,N2)
                TAI12=-R12(N1,N2)
                TGR12= IG12(N1,N2)
                TGI12=-RG12(N1,N2)
 
                TAR21=-I21(N1,N2)
                TAI21= R21(N1,N2)
                TGR21=-IG21(N1,N2)
                TGI21= RG21(N1,N2)
 
                TQR(K1,K2)=TPIR*TAR21-TPII*TAI21+TPPI*TAR12
                TQI(K1,K2)=TPIR*TAI21+TPII*TAR21+TPPI*TAI12
                TRGQR(K1,K2)=TPIR*TGR21-TPII*TGI21+TPPI*TGR12
                TRGQI(K1,K2)=TPIR*TGI21+TPII*TGR21+TPPI*TGI12
 
                TQR(K1,KK2)=0Q0
                TQI(K1,KK2)=0Q0
                TRGQR(K1,KK2)=0Q0
                TRGQI(K1,KK2)=0Q0
 
                TQR(KK1,K2)=0Q0
                TQI(KK1,K2)=0Q0
                TRGQR(KK1,K2)=0Q0
                TRGQI(KK1,K2)=0Q0
 
                TQR(KK1,KK2)=TPIR*TAR12-TPII*TAI12+TPPI*TAR21
                TQI(KK1,KK2)=TPIR*TAI12+TPII*TAR12+TPPI*TAI21
                TRGQR(KK1,KK2)=TPIR*TGR12-TPII*TGI12+TPPI*TGR21
                TRGQI(KK1,KK2)=TPIR*TGI12+TPII*TGR12+TPPI*TGI21
  310 CONTINUE
 
      NNMAX=2*NM
      DO 320 N1=1,NNMAX
           DO 320 N2=1,NNMAX
                QR(N1,N2)=TQR(N1,N2)
                QI(N1,N2)=TQI(N1,N2)
                RGQR(N1,N2)=TRGQR(N1,N2)
                RGQI(N1,N2)=TRGQI(N1,N2)
  320 CONTINUE
      CALL ttq(NMAX,NCHECK)
      RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of the T(M) matrix, M.GE.1, for an axially symmetric  *
C   particle                                                          *
C                                                                     *
C   Input parameters:                                                 *
C                                                                     *
C   M.GE.1                                                            *
C   NG = NGAUSS*2 - number of gaussian division points on the         *
C        interval  (-1,1)                                             *
C   W - quadrature weights                                            *
C   AN,ANN - see subroutine   constq                                   *
C   S,SS - see subroutine   constq                                     *
C   ARRAYS  DV1,DV2,DV3,DV4 are in COMMON /DV/ -                      *
C         see subroutine   DVIG                                       *
C   PPI,PIR,PII - see subroutine   varyq                               *
C   R J DR - see subroutines rsp1q and rsp2q                            *
C   DDR,DRR,DRI - see subroutine   varyq                               *
C   NMAX - dimension of the T(M) matrix                               *
C   Arrays  J,Y,JR,JI,DJ,DY,DJR,DJI are in                            *
C        COMMON /Cbessq/ - see subroutine   bessq                       *
C                                                                     *
C   Output parameters:                                                *
C                                                                     *
C   Arrays  TR1,TI1 (real and imaginary parts of the T(M) matrix)     *
C   are in COMMON /CT/                                                *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE tmatrq (M,NGAUSS,X,W,AN,ANN,S,SS,PPI,PIR,PII,R,DR,DDR,
     *                  DRR,DRI,NMAX,NCHECK)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 X(NPNG2),W(NPNG2),AN(NPN1),S(NPNG2),SS(NPNG2),
     *        R(NPNG2),DR(NPNG2),SIG(NPN2),
     *        J(NPNG2,NPN1),Y(NPNG2,NPN1),
     *        JR(NPNG2,NPN1),JI(NPNG2,NPN1),DJ(NPNG2,NPN1),
     *        DY(NPNG2,NPN1),DJR(NPNG2,NPN1),
     *        DJI(NPNG2,NPN1),DDR(NPNG2),DRR(NPNG2),
     *        D1(NPNG2,NPN1),D2(NPNG2,NPN1),
     *        DRI(NPNG2),DS(NPNG2),DSS(NPNG2),RR(NPNG2),
     *        DV1(NPN1),DV2(NPN1)
      REAL*16 R11(NPN1,NPN1),R12(NPN1,NPN1),
     *        R21(NPN1,NPN1),R22(NPN1,NPN1),
     *        I11(NPN1,NPN1),I12(NPN1,NPN1),
     *        I21(NPN1,NPN1),I22(NPN1,NPN1),
     *        RG11(NPN1,NPN1),RG12(NPN1,NPN1),
     *        RG21(NPN1,NPN1),RG22(NPN1,NPN1),
     *        IG11(NPN1,NPN1),IG12(NPN1,NPN1),
     *        IG21(NPN1,NPN1),IG22(NPN1,NPN1),
     *        ANN(NPN1,NPN1),
     *        QR(NPN2,NPN2),QI(NPN2,NPN2),
     *        RGQR(NPN2,NPN2),RGQI(NPN2,NPN2),
     *        TQR(NPN2,NPN2),TQI(NPN2,NPN2),
     *        TRGQR(NPN2,NPN2),TRGQI(NPN2,NPN2)
      REAL*8 TR1(NPN2,NPN2),TI1(NPN2,NPN2)
      COMMON /TMAT99/ 
     &            R11,R12,R21,R22,I11,I12,I21,I22,RG11,RG12,RG21,RG22,
     &            IG11,IG12,IG21,IG22
      COMMON /Cbessq/ J,Y,JR,JI,DJ,DY,DJR,DJI
      COMMON /CT/ TR1,TI1
      COMMON /Cttq/ QR,QI,RGQR,RGQI
      MM1=M
      QM=QFLOAT(M)
      QMM=QM*QM
      NG=2*NGAUSS
      NGSS=NG
      FACTOR=1Q0
      IF (NCHECK.EQ.1) THEN
            NGSS=NGAUSS
            FACTOR=2Q0
         ELSE
            CONTINUE
      ENDIF
      SI=1Q0
      NM=NMAX+NMAX
      DO 5 N=1,NM
           SI=-SI
           SIG(N)=SI
    5 CONTINUE
   20 DO 25 I=1,NGAUSS
         I1=NGAUSS+I
         I2=NGAUSS-I+1
         CALL vigq (X(I1),NMAX,M,DV1,DV2)
         DO 25 N=1,NMAX
            SI=SIG(N+M)
            DD1=DV1(N)
            DD2=DV2(N)
            D1(I1,N)=DD1
            D2(I1,N)=DD2
            D1(I2,N)=DD1*SI
            D2(I2,N)=-DD2*SI
   25 CONTINUE
   30 DO 40 I=1,NGSS
           WR=W(I)*R(I)
           DS(I)=S(I)*QM*WR
           DSS(I)=SS(I)*QMM
           RR(I)=WR
   40 CONTINUE
 
      DO 300  N1=MM1,NMAX
           AN1=AN(N1)
           DO 300 N2=MM1,NMAX
                AN2=AN(N2)
                AR11=0Q0
                AR12=0Q0
                AR21=0Q0
                AR22=0Q0
                AI11=0Q0
                AI12=0Q0
                AI21=0Q0
                AI22=0Q0
                GR11=0Q0
                GR12=0Q0
                GR21=0Q0
                GR22=0Q0
                GI11=0Q0
                GI12=0Q0
                GI21=0Q0
                GI22=0Q0
                SI=SIG(N1+N2)
 
                DO 200 I=1,NGSS
                    D1N1=D1(I,N1)
                    D2N1=D2(I,N1)
                    D1N2=D1(I,N2)
                    D2N2=D2(I,N2)
                    A11=D1N1*D1N2
                    A12=D1N1*D2N2
                    A21=D2N1*D1N2
                    A22=D2N1*D2N2
                    AA1=A12+A21
                    AA2=A11*DSS(I)+A22
                    QJ1=J(I,N1)
                    QY1=Y(I,N1)
                    QJR2=JR(I,N2)
                    QJI2=JI(I,N2)
                    QDJR2=DJR(I,N2)
                    QDJI2=DJI(I,N2)
                    QDJ1=DJ(I,N1)
                    QDY1=DY(I,N1)
 
                    C1R=QJR2*QJ1
                    C1I=QJI2*QJ1
                    B1R=C1R-QJI2*QY1
                    B1I=C1I+QJR2*QY1
 
                    C2R=QJR2*QDJ1
                    C2I=QJI2*QDJ1
                    B2R=C2R-QJI2*QDY1
                    B2I=C2I+QJR2*QDY1
 
                    DDRI=DDR(I)
                    C3R=DDRI*C1R
                    C3I=DDRI*C1I
                    B3R=DDRI*B1R
                    B3I=DDRI*B1I
 
                    C4R=QDJR2*QJ1
                    C4I=QDJI2*QJ1
                    B4R=C4R-QDJI2*QY1
                    B4I=C4I+QDJR2*QY1
 
                    DRRI=DRR(I)
                    DRII=DRI(I)
                    C5R=C1R*DRRI-C1I*DRII
                    C5I=C1I*DRRI+C1R*DRII
                    B5R=B1R*DRRI-B1I*DRII
                    B5I=B1I*DRRI+B1R*DRII
 
                    C6R=QDJR2*QDJ1
                    C6I=QDJI2*QDJ1
                    B6R=C6R-QDJI2*QDY1
                    B6I=C6I+QDJR2*QDY1
 
                    C7R=C4R*DDRI
                    C7I=C4I*DDRI
                    B7R=B4R*DDRI
                    B7I=B4I*DDRI
 
                    C8R=C2R*DRRI-C2I*DRII
                    C8I=C2I*DRRI+C2R*DRII
                    B8R=B2R*DRRI-B2I*DRII
                    B8I=B2I*DRRI+B2R*DRII
 
                    URI=DR(I)
                    DSI=DS(I)
                    DSSI=DSS(I)
                    RRI=RR(I)
 
                    IF (NCHECK.EQ.1.AND.SI.GT.0Q0) GO TO 150
 
                    E1=DSI*AA1
                    AR11=AR11+E1*B1R
                    AI11=AI11+E1*B1I
                    GR11=GR11+E1*C1R
                    GI11=GI11+E1*C1I
                    IF (NCHECK.EQ.1) GO TO 160
 
  150               F1=RRI*AA2
                    F2=RRI*URI*AN1*A12
                    AR12=AR12+F1*B2R+F2*B3R
                    AI12=AI12+F1*B2I+F2*B3I
                    GR12=GR12+F1*C2R+F2*C3R
                    GI12=GI12+F1*C2I+F2*C3I
 
                    F2=RRI*URI*AN2*A21
                    AR21=AR21+F1*B4R+F2*B5R
                    AI21=AI21+F1*B4I+F2*B5I
                    GR21=GR21+F1*C4R+F2*C5R
                    GI21=GI21+F1*C4I+F2*C5I
                    IF (NCHECK.EQ.1) GO TO 200
 
  160               E2=DSI*URI*A11
                    E3=E2*AN2
                    E2=E2*AN1
                    AR22=AR22+E1*B6R+E2*B7R+E3*B8R
                    AI22=AI22+E1*B6I+E2*B7I+E3*B8I
                    GR22=GR22+E1*C6R+E2*C7R+E3*C8R
                    GI22=GI22+E1*C6I+E2*C7I+E3*C8I
  200           CONTINUE
                AN12=ANN(N1,N2)*FACTOR
                R11(N1,N2)=AR11*AN12
                R12(N1,N2)=AR12*AN12
                R21(N1,N2)=AR21*AN12
                R22(N1,N2)=AR22*AN12
                I11(N1,N2)=AI11*AN12
                I12(N1,N2)=AI12*AN12
                I21(N1,N2)=AI21*AN12
                I22(N1,N2)=AI22*AN12
                RG11(N1,N2)=GR11*AN12
                RG12(N1,N2)=GR12*AN12
                RG21(N1,N2)=GR21*AN12
                RG22(N1,N2)=GR22*AN12
                IG11(N1,N2)=GI11*AN12
                IG12(N1,N2)=GI12*AN12
                IG21(N1,N2)=GI21*AN12
                IG22(N1,N2)=GI22*AN12
 
  300 CONTINUE
      TPIR=PIR
      TPII=PII
      TPPI=PPI
      NM=NMAX-MM1+1
      DO 310 N1=MM1,NMAX
           K1=N1-MM1+1
           KK1=K1+NM
           DO 310 N2=MM1,NMAX
                K2=N2-MM1+1
                KK2=K2+NM
 
                TAR11=-R11(N1,N2)
                TAI11=-I11(N1,N2)
                TGR11=-RG11(N1,N2)
                TGI11=-IG11(N1,N2)
 
                TAR12= I12(N1,N2)
                TAI12=-R12(N1,N2)
                TGR12= IG12(N1,N2)
                TGI12=-RG12(N1,N2)
 
                TAR21=-I21(N1,N2)
                TAI21= R21(N1,N2)
                TGR21=-IG21(N1,N2)
                TGI21= RG21(N1,N2)
 
                TAR22=-R22(N1,N2)
                TAI22=-I22(N1,N2)
                TGR22=-RG22(N1,N2)
                TGI22=-IG22(N1,N2)
 
                TQR(K1,K2)=TPIR*TAR21-TPII*TAI21+TPPI*TAR12
                TQI(K1,K2)=TPIR*TAI21+TPII*TAR21+TPPI*TAI12
                TRGQR(K1,K2)=TPIR*TGR21-TPII*TGI21+TPPI*TGR12
                TRGQI(K1,K2)=TPIR*TGI21+TPII*TGR21+TPPI*TGI12
 
                TQR(K1,KK2)=TPIR*TAR11-TPII*TAI11+TPPI*TAR22
                TQI(K1,KK2)=TPIR*TAI11+TPII*TAR11+TPPI*TAI22
                TRGQR(K1,KK2)=TPIR*TGR11-TPII*TGI11+TPPI*TGR22
                TRGQI(K1,KK2)=TPIR*TGI11+TPII*TGR11+TPPI*TGI22
 
                TQR(KK1,K2)=TPIR*TAR22-TPII*TAI22+TPPI*TAR11
                TQI(KK1,K2)=TPIR*TAI22+TPII*TAR22+TPPI*TAI11
                TRGQR(KK1,K2)=TPIR*TGR22-TPII*TGI22+TPPI*TGR11
                TRGQI(KK1,K2)=TPIR*TGI22+TPII*TGR22+TPPI*TGI11
 
                TQR(KK1,KK2)=TPIR*TAR12-TPII*TAI12+TPPI*TAR21
                TQI(KK1,KK2)=TPIR*TAI12+TPII*TAR12+TPPI*TAI21
                TRGQR(KK1,KK2)=TPIR*TGR12-TPII*TGI12+TPPI*TGR21
                TRGQI(KK1,KK2)=TPIR*TGI12+TPII*TGR12+TPPI*TGI21
  310 CONTINUE
 
      NNMAX=2*NM
      DO 320 N1=1,NNMAX
           DO 320 N2=1,NNMAX
                QR(N1,N2)=TQR(N1,N2)
                QI(N1,N2)=TQI(N1,N2)
                RGQR(N1,N2)=TRGQR(N1,N2)
                RGQI(N1,N2)=TRGQI(N1,N2)
  320 CONTINUE
      CALL ttq(NM,NCHECK)
      RETURN
      END
 
C*****************************************************************
c
c     Calculation of the functiONS
c     DV1(n)=dvig(0,m,n,arccos x)
c     and
c     DV2(n)=[d/d(arccos x)] dvig(0,m,n,arccos x)
c     1.LE.N.LE.NMAX
c     0.LE.x.LE.1
 
      SUBROUTINE vigq (X,NMAX,M,DV1,DV2)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 DV1(NPN1), DV2(NPN1)
      A=1Q0
      QS=QSQRT(1Q0-X*X)
      QS1=1Q0/QS
      DO 1 N=1,NMAX
         DV1(N)=0Q0
         DV2(N)=0Q0
    1 CONTINUE
      IF (M.NE.0) GO TO 20
      D1=1Q0
      D2=X  
      DO 5 N=1,NMAX  
         QN=QFLOAT(N)
         QN1=QFLOAT(N+1)
         QN2=QFLOAT(2*N+1)
         D3=(QN2*X*D2-QN*D1)/QN1 
         DER=QS1*(QN1*QN/QN2)*(-D1+D3)
         DV1(N)=D2
         DV2(N)=DER
         D1=D2
         D2=D3
    5 CONTINUE
      RETURN
   20 QMM=QFLOAT(M*M)
      DO 25 I=1,M
         I2=I*2
         A=A*QSQRT(QFLOAT(I2-1)/QFLOAT(I2))*QS
   25 CONTINUE
      D1=0Q0
      D2=A 
      DO 30 N=M,NMAX
         QN=QFLOAT(N)
         QN2=QFLOAT(2*N+1)
         QN1=QFLOAT(N+1)
         QNM=QSQRT(QN*QN-QMM)
         QNM1=QSQRT(QN1*QN1-QMM)
         D3=(QN2*X*D2-QNM*D1)/QNM1
         DER=QS1*(-QN1*QNM*D1+QN*QNM1*D3)/QN2
         DV1(N)=D2
         DV2(N)=DER
         D1=D2
         D2=D3
   30 CONTINUE
      RETURN
      END 
 
C**********************************************************************
C                                                                     *
C   Calculation of the matrix    T = - RG(Q) * (Q**(-1))              *
C                                                                     *
C   Input infortmation is in COMMON /Cttq/                             *
C   Output information is in COMMON /CT/                              *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE ttq(NMAX,NCHECK)
      INCLUDE 'tmatrix.par.f'
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*16 F(NPN2,NPN2),B(NPN2),WORK(NPN2),
     *       QR(NPN2,NPN2),QI(NPN2,NPN2),
     *       RGQR(NPN2,NPN2),RGQI(NPN2,NPN2),
     *       A(NPN2,NPN2),C(NPN2,NPN2),D(NPN2,NPN2),E(NPN2,NPN2)
      REAL*8 TR1(NPN2,NPN2),TI1(NPN2,NPN2)
      COMPLEX*32 ZQ(NPN2,NPN2),ZW(NPN2)
      COMPLEX*32 ZQR(NPN2,NPN2),ZAFAC(NPN2,NPN2),ZT(NPN2,NPN2),
     &           ZTHETA(NPN2,NPN2)
      INTEGER IPIV(NPN2),IPVT(NPN2)
      COMMON /CHOICE/ ICHOICE
      COMMON /CT/ TR1,TI1
      COMMON /Cttq/ QR,QI,RGQR,RGQI
      NDIM=NPN2
      NNMAX=2*NMAX
      IF (ICHOICE.EQ.2) GO TO 5
 
C	Inversion from NAG-LIB or Waterman's method
 
	DO I=1,NNMAX
	   DO J=1,NNMAX
	      ZQ(I,J)=QCMPLX(QR(I,J),QI(I,J))
	      ZAFAC(I,J)=ZQ(I,J)
	   ENDDO
	ENDDO
	INFO=0
        CALL ZGETRFq(NNMAX,NNMAX,ZQ,NPN2,IPIV,INFO)
        IF (INFO.NE.0) WRITE (6,1100) INFO
        CALL ZGETRIq(NNMAX,ZQ,NPN2,IPIV,ZW,NPN2,INFO)
        IF (INFO.NE.0) WRITE (6,1100) INFO
 1100   FORMAT ('WARNING:  info=', I2)
	DO I=1,NNMAX
	   DO J=1,NNMAX
	      TR=0D0
	      TI=0D0
	      DO K=1,NNMAX
                 ARR=RGQR(I,K)
                 ARI=RGQI(I,K)
                 AR=ZQ(K,J)
                 AIq=QIMAG(ZQ(K,J))
		     AI=AIq
                 TR=TR-ARR*AR+ARI*AI
                 TI=TI-ARR*AI-ARI*AR
              ENDDO
	      TR1(I,J)=TR
	      TI1(I,J)=TI
	   ENDDO
	ENDDO
	GOTO 70

C  Gaussian elimination
 
    5 DO 10 N1=1,NNMAX
         DO 10 N2=1,NNMAX
            F(N1,N2)=QI(N1,N2)
   10 CONTINUE
      IF (NCHECK.EQ.1) THEN
          CALL inv1q(NMAX,F,A)
        ELSE
          CALL invertq(NDIM,NNMAX,F,A,COND,IPVT,WORK,B)
      ENDIF
      CALL prodq(QR,A,C,NDIM,NNMAX)
      CALL prodq(C,QR,D,NDIM,NNMAX)
      DO 20 N1=1,NNMAX
           DO 20 N2=1,NNMAX
                C(N1,N2)=D(N1,N2)+QI(N1,N2)
   20 CONTINUE
      IF (NCHECK.EQ.1) THEN
          CALL inv1q(NMAX,C,QI)
        ELSE
          CALL invertq(NDIM,NNMAX,C,QI,COND,IPVT,WORK,B)
      ENDIF
      CALL prodq(A,QR,D,NDIM,NNMAX)
      CALL prodq(D,QI,QR,NDIM,NNMAX)
 
      CALL prodq(RGQR,QR,A,NDIM,NNMAX)
      CALL prodq(RGQI,QI,C,NDIM,NNMAX)
      CALL prodq(RGQR,QI,D,NDIM,NNMAX)
      CALL prodq(RGQI,QR,E,NDIM,NNMAX)
      DO 30 N1=1,NNMAX
           DO 30 N2=1,NNMAX
                TR1(N1,N2)=-A(N1,N2)-C(N1,N2)
                TI1(N1,N2)= D(N1,N2)-E(N1,N2)
   30 CONTINUE
   70 RETURN
      END
 
C**********************************************************************
C                                                                     *
C   Calculation of the matrix C = A * B .                             *
C   All matrices are (N-by-N)                                         *
C   Declared  line dimension of the arrays A,B, and C in the calling  *
C   program is NDIM                                                   *
C                                                                     *
C**********************************************************************
 
      SUBROUTINE prodq(A,B,C,NDIM,N)
      REAL*16 A(NDIM,N),B(NDIM,N),C(NDIM,N),cij
      DO 10 I=1,N
           DO 10 J=1,N
                CIJ=0Q0
                DO 5 K=1,N
                     CIJ=CIJ+A(I,K)*B(K,J)
    5           CONTINUE
                C(I,J)=CIJ
   10 CONTINUE
      RETURN
      END
 
C**********************************************************************
 
      SUBROUTINE inv1q (NMAX,F,A)
      IMPLICIT REAL*16 (A-H,O-Z)
      INCLUDE 'tmatrix.par.f'
      REAL*16 A(NPN2,NPN2),F(NPN2,NPN2),B(NPN1),
     *        WORK(NPN1),Q1(NPN1,NPN1),Q2(NPN1,NPN1),
     &        P1(NPN1,NPN1),P2(NPN1,NPN1)
      INTEGER IPVT(NPN1),IND1(NPN1),IND2(NPN1)
      NDIM=NPN1
      NN1=(QFLOAT(NMAX)-0.1Q0)*0.5Q0+1Q0
      NN2=NMAX-NN1
      DO 5 I=1,NMAX
         IND1(I)=2*I-1
         IF(I.GT.NN1) IND1(I)=NMAX+2*(I-NN1)
         IND2(I)=2*I
         IF(I.GT.NN2) IND2(I)=NMAX+2*(I-NN2)-1
    5 CONTINUE
      NNMAX=2*NMAX
      DO 15 I=1,NMAX
         I1=IND1(I)
         I2=IND2(I)
         DO 15 J=1,NMAX
            J1=IND1(J)
            J2=IND2(J)
            Q1(J,I)=F(J1,I1)
            Q2(J,I)=F(J2,I2)
   15 CONTINUE
      CALL invertq(NDIM,NMAX,Q1,P1,COND,IPVT,WORK,B)
      CALL invertq(NDIM,NMAX,Q2,P2,COND,IPVT,WORK,B)
      DO 30 I=1,NNMAX
         DO 30 J=1,NNMAX
            A(J,I)=0Q0
   30 CONTINUE
      DO 40 I=1,NMAX
         I1=IND1(I)
         I2=IND2(I)
         DO 40 J=1,NMAX
            J1=IND1(J)
            J2=IND2(J)
            A(J1,I1)=P1(J,I)
            A(J2,I2)=P2(J,I)
   40 CONTINUE
      RETURN
      END
 
C*********************************************************************
C                                                                    *
C   Inversion of a square matrix                                     *
C                                                                    *
C   Input parameters:                                                *
C                                                                    *
C   A - square (N-by-N) matrix                                       *
C   NDIM - declared line dimension of the matrix A in the calling    *
C          program                                                   *
C                                                                    *
C   Output information:                                              *
C                                                                    *
C   X - square (N-by-N) matrix - result of inverting matrix A        *
C   COND - estimate of ill-conditioning of the matrix A              *
C                                                                    *
C   Temporary arrays:  IPVT,WORK,B                                   *
C                                                                    *
C*********************************************************************
 
      SUBROUTINE invertq (NDIM,N,A,X,COND,IPVT,WORK,B)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 A(NDIM,N),X(NDIM,N),WORK(N),B(N)
      INTEGER IPVT(N)
      CALL decompq (NDIM,N,A,COND,IPVT,WORK)
      IF (COND+1Q0.EQ.COND) PRINT 5,COND
C     IF (COND+1Q0.EQ.COND) STOP
    5 FORMAT(' THE MATRIX IS SINGULAR FOR THE GIVEN NUMERICAL ACCURACY '
     *      ,'COND = ',D12.6)
      DO 30 I=1,N
           DO 10 J=1,N
                B(J)=0Q0
                IF (J.EQ.I) B(J)=1Q0
  10       CONTINUE
           CALL solveq (NDIM,N,A,B,IPVT)
           DO 30 J=1,N
                X(J,I)=B(J)
   30 CONTINUE
      RETURN
      END
 
C********************************************************************
 
      SUBROUTINE decompq (NDIM,N,A,COND,IPVT,WORK)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 A(NDIM,N),COND,WORK(N)
      INTEGER IPVT(N)
      IPVT(N)=1
      IF(N.EQ.1) GO TO 80
      NM1=N-1
      ANORM=0Q0
      DO 10 J=1,N
          T=0Q0
          DO 5 I=1,N
              T=T+QABS(A(I,J))
    5     CONTINUE
          IF (T.GT.ANORM) ANORM=T
   10 CONTINUE
      DO 35 K=1,NM1
          KP1=K+1
          M=K
          DO 15 I=KP1,N
              IF (QABS(A(I,K)).GT.QABS(A(M,K))) M=I
   15     CONTINUE
          IPVT(K)=M
          IF (M.NE.K) IPVT(N)=-IPVT(N)
          T=A(M,K)
          A(M,K)=A(K,K)
          A(K,K)=T
          IF (T.EQ.0Q0) GO TO 35
          DO 20 I=KP1,N
              A(I,K)=-A(I,K)/T
   20     CONTINUE
          DO 30 J=KP1,N
              T=A(M,J)
              A(M,J)=A(K,J)
              A(K,J)=T
              IF (T.EQ.0Q0) GO TO 30
              DO 25 I=KP1,N
                  A(I,J)=A(I,J)+A(I,K)*T
   25         CONTINUE
   30     CONTINUE
   35 CONTINUE
      DO 50 K=1,N
          T=0Q0
          IF (K.EQ.1) GO TO 45
          KM1=K-1
          DO 40 I=1,KM1
              T=T+A(I,K)*WORK(I)
   40     CONTINUE
   45     EK=1Q0
          IF (T.LT.0Q0) EK=-1Q0
          IF (A(K,K).EQ.0Q0) GO TO 90
          WORK(K)=-(EK+T)/A(K,K)
   50 CONTINUE
      DO 60 KB=1,NM1
          K=N-KB
          T=0Q0
          KP1=K+1
          DO 55 I=KP1,N
              T=T+A(I,K)*WORK(K)
   55     CONTINUE
          WORK(K)=T
          M=IPVT(K)
          IF (M.EQ.K) GO TO 60
          T=WORK(M)
          WORK(M)=WORK(K)
          WORK(K)=T
   60 CONTINUE
      YNORM=0Q0
      DO 65 I=1,N
          YNORM=YNORM+QABS(WORK(I))
   65 CONTINUE
      CALL solveq (NDIM,N,A,WORK,IPVT)
      ZNORM=0Q0
      DO 70 I=1,N
          ZNORM=ZNORM+QABS(WORK(I))
   70 CONTINUE
      COND=ANORM*ZNORM/YNORM
      IF (COND.LT.1Q0) COND=1Q0
      RETURN
   80 COND=1Q0
      IF (A(1,1).NE.0Q0) RETURN
   90 COND=1Q52
      RETURN
      END
 
C**********************************************************************
 
      SUBROUTINE solveq (NDIM,N,A,B,IPVT)
      IMPLICIT REAL*16 (A-H,O-Z)
      REAL*16 A(NDIM,N),B(N)
      INTEGER IPVT(N)
      IF (N.EQ.1) GO TO 50
      NM1=N-1
      DO 20 K=1,NM1
          KP1=K+1
          M=IPVT(K)
          T=B(M)
          B(M)=B(K)
          B(K)=T
          DO 10 I=KP1,N
              B(I)=B(I)+A(I,K)*T
   10     CONTINUE
   20 CONTINUE
      DO 40 KB=1,NM1
          KM1=N-KB
          K=KM1+1
          B(K)=B(K)/A(K,K)
          T=-B(K)
          DO 30 I=1,KM1
              B(I)=B(I)+A(I,K)*T
   30     CONTINUE
   40 CONTINUE
   50 B(1)=B(1)/A(1,1)
      RETURN
      END

C********************************************************************

      SUBROUTINE dropq (RAT)
      PARAMETER (NC=10, NG=60)
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 X(NG),W(NG)
      REAL*16 C(0:NC),R0V
      COMMON /Cdropq/ C,R0V
      C(0)=-0.0481 Q0
      C(1)= 0.0359 Q0
      C(2)=-0.1263 Q0
      C(3)= 0.0244 Q0
      C(4)= 0.0091 Q0
      C(5)=-0.0099 Q0
      C(6)= 0.0015 Q0
      C(7)= 0.0025 Q0
      C(8)=-0.0016 Q0
      C(9)=-0.0002 Q0
      C(10)= 0.0010 Q0
      CALL GAUSS (NG,0,0,X,W)
      S=0D0
      V=0D0
      DO I=1,NG
         XI=DACOS(X(I))
         WI=W(I)
         RI=1D0+C(0)
         DRI=0D0
         DO N=1,NC
            XIN=XI*N
            RI=RI+C(N)*DCOS(XIN)
            DRI=DRI-C(N)*N*DSIN(XIN)
         ENDDO
         SI=DSIN(XI)
         CI=X(I)
         RISI=RI*SI
         S=S+WI*RI*DSQRT(RI*RI+DRI*DRI)
         V=V+WI*RI*RISI*(RISI-DRI*CI)
      ENDDO
      RS=DSQRT(S*0.5D0)
      RV=(V*3D0*0.25D0)**(1D0/3D0)
      IF (DABS(RAT-1D0).GT.1D-8) RAT=RV/RS
      R0V=1D0/RV
      WRITE (6,1000) R0V
      DO N=0,NC
         WRITE (6,1001) N,C(N)
      ENDDO
 1000 FORMAT ('r_0/r_ev=',F7.4)
 1001 FORMAT ('c_',I2,'=',F7.4)
      RETURN
      END
