import unittest
import os
from PyARTS import artsXML
from scipy import *

class NewHandlerTest(unittest.TestCase):
    a=arange(24)
    a.shape=[2,3,4]
    outfile="testfile.xml"
    def testLoadedIsSameAsSaved(self):
      """If you save a tensor, you should be able to load it again (unchanged!)"""
      artsXML.save(self.a,self.outfile)
      b=artsXML.load(self.outfile)
      c=b-self.a
      c.shape=[24]
      assert(alltrue(c==0)),"Loaded array is different from saved array!!"
      
    def tearDown(self):
      os.remove(self.outfile)

class AutoTest(unittest.TestCase):
    """testing python-ARTS type mapping by saving and loading XML files"""
    outfile="test.xml"
    data=[[1,2,3],[[1,2,3],[1,2,3],[1,2,3],[1,2,3]],['hello','dog'],'dog']
    def test1(self):
       """Indexes, Strings and Arrays thereof"""
       for x in self.data:
          artsXML.save(x,self.outfile)
          y=artsXML.load(self.outfile)
          #assert(x==y),"Loaded data (%s) is different from saved data (%s)!!" %(x,y)
       
    def tearDown(self):
      os.remove(self.outfile)
      

if __name__=='__main__':
    unittest.main()


