%------------------------------------------------------------------------
% NAME:     qp_Sx
%
%           Creates matrices releated to Sx.
%
%           If the function is called without output argument a number
%           of matrices are stored to files:
%
%           The Sx matrix is always saved.
%
%           If a constrained least squares retrieval method is selected,
%           the inverse of the diagonal elements of Sx is stored as Dxinv.
%
%           If OEM is selected, the inverse of Sx is stored as Sxinv.
%
% FORMAT:   Sx = qp_Sx( Q )
%
% OUT:      -
% IN:       Q          Setting structure.
%------------------------------------------------------------------------

% HISTORY: 2001.03.25  Created by Patrick Eriksson.
%          2001.10.13  The core of the function moved to qp_Sxb (PE)


function Sx = qp_Sx( Q )


out(1,1);
out(1,'Setting up Sx.');


Sx = qp_Sxb( Q, 3 );

%=== Save
%
%= Sx is always stored. 
%= For CLS, the inverse of the diagonal elements of Sx is stored as Dxinv
%= For OEM, the inverse of Sx is stored as Sxinv
%
if nargout == 0
  %
  save( [Q.OUT,'.sx'],    'Sx' );
  %
  if qpcls_methods( Q.RETRIEVAL_METHOD )
    %
    np = size( Sx, 1 );
    %
    Dxinv = spdiags( 1./spdiags(Sx,0), 0, np, np);
    save( [Q.OUT,'.dxinv'], 'Dxinv' );
    %
    if strcmp( lower( Q.RETRIEVAL_METHOD ), 'oem' )
      %
      Sxinv = Sx \ eye(size(Sx));
      save( [Q.OUT,'.sxinv'], 'Sxinv' );
      %
    end
  end
end


out(1,-1);

