%------------------------------------------------------------------------
% NAME:     qp_arts
%
%           Calls ARTS using the report level specified in Q.
%
% FORMAT:   qp_arts( Q, cfile )
%
% OUT:      -
% IN:       Q       The setting structure.
%           cfile   Name/path of the control file.
%------------------------------------------------------------------------

% HISTORY: 2001.02.19  Created by Patrick Eriksson.


function qp_arts( Q, cfile )

s_call = [Q.ARTS,' -r',int2str(Q.ARTS_LEVEL),int2str(Q.ARTS_LEVEL),' ', cfile];


%= Unix
%
if isunix
  s = unix( s_call );

%= DOS/Windows
%
elseif strcmp( computer, 'PCWIN' );
  s = dos( s_call );

%= Other computer types
%
% No error handling here
%
else
  eval( ['!', s_call ] );
  s = 1;
end


if s 

  fprintf('\n\n');
  if Q.ARTS_ERROR_IGNORE
    warning('An ARTS error has ocurred (see above).');
  else
    error('An ARTS error has ocurred (see above).');
  end

end


