%------------------------------------------------------------------------
% NAME:     qp_contabs_freqs
% 
%           Help function to handle the frequency limits and points for 
%           retyrieval of continuum absorption.
% 
% FORMAT:   [ flimits, fp, f_mono ] = qp_eground_lims( Q )
%
% OUT:      flimits   End points for fit range.
%           fp        Frequencies for fits.
%           f_mono    The monochromatic frequencies.
% IN:       Q         The Q struct.
%------------------------------------------------------------------------

% HISTORY: 2002.01.17  Created by Patrick Eriksson.


function [flimits,fp,f_mono] = qp_contabs_freqs(Q)


%error('Continuum absorption is not yet totally implemented.');


%= Check length of 
%
if Q.CONTABS_LIMITS == 2
  error('The length of Q.CONTABS_LIMITS must be 2.');
end


%= Set limits
%
flimits = Q.CONTABS_LIMITS;
%
if any( flimits == -1 )

  f_mono = read_datafile( fullfile(Q.CALCGRIDS_DIR,Q.F_MONO), 'VECTOR');

  if flimits(1) == -1
    flimits(1) = f_mono(1);
  end

  if flimits(2) == -1
    flimits(2) = last( f_mono );
  end

else

  if nargout > 2
    f_mono = read_datafile( fullfile( Q.CALCGRIDS_DIR, Q.F_MONO ), 'VECTOR');
  end
    
end


%= Frequency grid
%
if Q.CONTABS_ORDER == 0
  fp = sum(flimits) / 2;
else
  fp = linspace( flimits(1), flimits(2), Q.CONTABS_ORDER+1 );
end

