%------------------------------------------------------------------------
% NAME:     qp_eground_lims
% 
%           Help function to handle the frequency limits for ground 
%           emission.
% 
% FORMAT:   [ fp, findex, single_e ] = qp_eground_lims( f_mono, flimits )
%
% OUT:      fp        Mean frequency of each range.
%           findex    Index in f_mono for end frequency points.
%           single_e  Flag for a single ground emission value (the same
%                     e for all frequencies)
% IN:       f_mono    Monochromatic frequencies.
%           flimits   Corresponding to the Q-field EGROUND_LIMITS
%------------------------------------------------------------------------

% HISTORY: 2001.03.28  Created by Patrick Eriksson.


function [fp,findex,single_e] = qp_eground_lims(f_mono,flimits)


if isempty( flimits )
  %
  fp       = f_mono;
  findex   = 1:length(f_mono);
  single_e = 0;
  %
  return               % Return
  %
end


np = length( flimits ) - 1;


if np == 0
  error('The length of EGROUND_LIMITS cannot be 1.');
end


findex = zeros( np, 2 );
fp     = zeros( np, 1 );

for i = 1 : np

  if i < np
    ind = find( f_mono>=flimits(i) & f_mono<flimits(i+1) );
  else
    ind = find( f_mono>=flimits(i) & f_mono<=flimits(i+1) );
  end

  if isempty(ind)
    s = sprintf('There is no F_MONO value inside the range %.3f - %.3f GHz',...
                                          flimits(i)/1e9, flimits(i+1)/1e9 ); 
    error(s);
  end

  findex(i,1) = ind(1);
  findex(i,2) = last(ind);

  fp(i) = ( f_mono(findex(i,1)) + f_mono(findex(i,2)) ) / 2;

end


if np==1 & findex(1,1)==1 & findex(1,2)==length(f_mono)
  %
  single_e = 1;
  %
else
  %
  single_e = 0;
  %
end

