%------------------------------------------------------------------------
% NAME:     qp_hdf
%
%   Handling of arts output format. 
%  
%   Two input arguments: The function adds a field to QE that is used in 
%   control file templates for setting output format (Ascii or Binary).
%
%   One input argument: The function returns file extension for output
%   files.
%
% FORMAT:   QE = qp_hdf(Q,QE)
%             or
%           ext = qp_hdf(Q)
%
% OUT:      QE             Structure with template settings.
%           ext            Filename extension (including .). E.g. '.aa'
% IN:       Q              The setting structure.
%           QE             Structure with template settings.
%
% TEMPLATE: -
%------------------------------------------------------------------------

% HISTORY: 2008.08.19  Created by Patrick Eriksson.


function QE = qp_hdf(Q,QE)

  
% Old default was to use HDF! So HDF used if field does not exist.

if nargin == 1
  
  if isfield( Q, 'USE_HDF' )  &  ~Q.USE_HDF
    QE = '.aa';
  else
    QE = '.ab';
  end
  
  
elseif nargin == 2
  
  if isfield( Q, 'USE_HDF' )  &  ~Q.USE_HDF
    QE.FORMAT = 'Ascii';
  else
    QE.FORMAT = 'Binary';
  end
  
end