%------------------------------------------------------------------------
% NAME:     qp_kinfo
% 
%           Obtain information for retrieval identity from kname.
% 
% FORMAT:   [group,name,par1,par2] = qp_kinfo( kname )
%
%------------------------------------------------------------------------
% HISTORY:  Created by Patrick Eriksson.
%        :  2003.11.19  Updated by Sho Tsujimaru.                 

function [group,name,par1,par2] = qp_kinfo( kname )

%=== Set some default values
name = kname;
par1 = [];


%=== Species
%
if strncmp( kname, 'Species:', 8 )
  %
  group = 'Species';
  name  = kname( [10:length(kname)] ); 

%=== Pointing off-set
%
elseif strncmp( kname, 'Pointing:', 9 )
  %
  group = 'Sensor scalar';


%=== Frequency off-set
%
elseif strncmp( kname, 'Frequency:', 9 )
  %
  group = 'Sensor scalar';
  

%=== Temperature
%
elseif strncmp( kname, 'Temperature:', 12 )
  %
  group = 'Temperature';
  name  = group;
  par1  = kname(14:length(kname));


%=== Continuum
%
elseif strncmp( kname, 'Continuum:', 10 )
   %
   group = 'Continuum';
   par1  = sscanf( name(12:length(name)), '%f' );


%=== Ground emission
%
elseif strncmp( kname, 'Ground emission', 15 )
   %
   group = 'Ground emission';
   par1  = sscanf( name(18:length(name)), '%f' );


%=== Polynomial baseline fit
%
elseif strncmp( kname, 'Baseline polynomial:', 20 )
   %
   group = 'Baseline';
   par1  = sscanf( name(21:length(name)), '%f' );


%=== Piecewise polynomial baseline fit
%
elseif strncmp( kname, 'Baseline piecewise polynomial:', 30 )
   %
   group = 'Baseline';
   par1  = sscanf( name(32), '%f' );
   par2  = sscanf( name(34:length(name)), '%f' );


%=== Reference load temperatures
%
elseif strcmp( kname, 'Reference load temperature(s)' )
   %
   group = 'Calibration';

%=== Proportional calibration error
%
elseif strcmp( kname, 'Proportional calibration error' )
   %
   group = 'Calibration';


% Newly appended part. 

%=== Pressure Shift
%
elseif strncmp( kname, 'Pressure shift:', 15 )
   %
   group = 'Spectroscopy';
   name  = 'Pressure shift';
   par1  =  kname(17:length(kname));

%=== Frequency Calibration
%
elseif strncmp( kname, 'Freq. calibration', 17 )
   %
   group = 'Sensor Vector';
   name  = 'Freq. calibration';


%=== Sinusoidal baseline fit
%
elseif strncmp( kname, 'Baseline sine fit:', 18)
   %
   group = 'Baseline';
   par1 = sscanf( name(20:end), '%f');
elseif strncmp( kname, 'Baseline cosine fit:', 20)
   %
   group = 'Baseline';
   par1 = sscanf( name(22:end), '%f');

elseif strncmp( kname, 'Piecewise Baseline sine fit:', 28)
   %
   group = 'Baseline';
   par1 = sscanf( name(20:end), '%f');
elseif strncmp( kname, 'Piecewise Baseline cosine fit:', 30)
   %
   group = 'Baseline';
   par1 = sscanf( name(22:end), '%f');

else
  error(sprintf('Unknown retrieval identity: %s', kname));
end

