%------------------------------------------------------------------------
% NAME:     qp_rnd_atmxsensor.m
%
%           A function to combine the spectral realizations from
%           qp_rnd_atm_mem_red and qp_rnd_sensor_mem_red. The 
%           realizations are supposed to come here already 
%           transformed by the H matrix.
%
%           Use this function in a sequence
%                     qp_rnd_atm_mem_red          
%                     qp_rnd_sensor_mem_red          
%                     qp_rnd_atmxsensor_mem_red
%           Information about the files produced in qp_rnd_atmxsensor.m 
%          
%           NOTE: this function require previous calculation of H
%                 by running qp_H(Q);
% 
%
% FORMAT:   qp_rnd_atmxsensor_mem_red( Q , [ Qi ) ]
%
% OUT:      -
% IN:       Q              rnd structure.
%
%------------------------------------------------------------------------
%
% HISTORY: 2001.08.04  Started by Carlos Jimenez

function  qp_rnd_atmxsensor_mem_red( Q )

global REPORT_LEVEL
r_l = Q.QP_LEVEL;

%=== start printing
out(1,1);


%=== load spectra


% -- reference spectra
load( [Q.OUT,'.yo'], '-mat' );


do_struc = 0;
if isfield(Q,'LRED_ON') 
   if Q.LRED_ON
     do_struc = 1;
   end
end


if ~do_struc

  eval(['load ',Q.OUT,'.h  -mat']);
  yo = H * yo';
  clear H

else

  eval(['load ',Q.OUT,'.h  ind -mat']);

  for g=1:length(ind)

    is = num2str(g);
    for l=1:ind(g)

      js = num2str(l);
      eval(['load ',Q.OUT,'.h H',is,js,' -mat']);
      eval(['H = H',is,js,';']) 
      Yaux{g,l}  = H * yo';
      eval(['clear H',is,js,';']) 

    end
  end 
  yo = Yaux;
  clear Yaux;

end 


% -- save yosensor
save([Q.OUT,'.yosensor'],'yo')
clear yo

%===  batch spectra

load( [Q.OUT,'.ybatch'], '-mat' );


% -- Transforming spectra

if ~do_struc

    eval(['load ',Q.OUT,'.h  -mat']);
    Y  = H * Y;

else

    for g=1:length(ind)

      is = num2str(g);
      for l=1:ind(g)

        js = num2str(l);
        eval(['load ',Q.OUT,'.h H',is,js,' -mat']);
        eval(['H = H',is,js,';']) 
        Yaux{g,l}  = H * Y;

      end
    end 
   
    Y = Yaux;
    clear Yaux

end 


if ~do_struc

  % -- transforming noise
  if Q.MEASNOISE_DO
    load( [Q.OUT,'.measnoise'], '-mat' );
    Y = Y + TN;
  end
  if Q.CALINOISE_DO
    disp('Sorry, calibration option not implemented')
  end
  if Q.POLYFIT_DO > 0 & Q.POLYFIT_ORDER == 0
    load([Q.OUT,'.polyfit'], '-mat' );
    Y = Y + PO;
  end

  % -- saving
  save([Q.OUT,'.ysensor'],'Y')
  clear Y 

else

  % -- number of species and r_grid
  eval(['load ',Q.OUT,'.h ind -mat']);

  if Q.MEASNOISE_DO
    
    load( [Q.OUT,'.measnoise'], '-mat' );

    for i=1:length(ind)

      is = num2str(i);
      for j=1:ind(i)

        Y{i,j}  = Y{i,j}  + TN{i,j};

      end
    end
 
    clear TN

  end

  if Q.CALINOISE_DO
    disp('Sorry, calibration option not implemented')
  end

  if Q.POLYFIT_DO > 0 & Q.POLYFIT_ORDER == 0
    
    load( [Q.OUT,'.polyfit'], '-mat' );

    for i=1:length(ind)

      for j=1:ind(i)

        Y{i,j}  = Y{i,j}  + PO{i,j};

      end
    end
 
    clear PO

  end


  save([Q.OUT,'.ysensor'],'Y')
  clear Y


end



out(1,-1);

