%------------------------------------------------------------------------
% NAME:     qp_rndcheck
%
%           A function to check meand and std of some species,
%           temperature and noise realizations
%
% FORMAT:   qp_rndcheck( Q, [name )]
%
% OUT:      -
% IN:       Q              Setting structure.
% OPTIONAL: name           it can modify a Q.RND_NAME for
%                          loading, e.g, when saving data
%                          from Npac/Nsmri/q2p_rnd name=
%                          'tra' load the training set. 
%
%------------------------------------------------------------------------
%
% HISTORY: 2001.08.07  Started by Carlos Jimenez
%
%
function  qp_rndcheck( Q , name)
%
%==== Obsolete, to be updated
disp('Obsolete, not use, to be updated')
return
%
%=== start printing
out(1,1);
out(1,['Getting statistics out of sets of spectra-observation variables']);
%
%=== getting tags
if exist('name')
     Q.RND_NAME = [Q.RND_NAME,'_',name];
end
%
p_sp            = find(Q.RND_SPEC_TAGS  =='"');
Q.RND_SPEC_N    = size(p_sp,2)/2;
for i=1:Q.RND_SPEC_N
  is = num2str(i);
  pa = num2str(p_sp(2*(i-1)+1));
  pb = num2str(p_sp(2*(i-1)+2));
  eval(['Q.RND_SPEC_TAGS',is,'=Q.RND_SPEC_TAGS(',pa,':',pb,');'])
end
%
%=== getting vertical coordinate
load( [Q.RND_DIR,Q.RND_NAME,'.z_abs'], '-mat' );
%
%=== species
if Q.RND_SPEC_DO
  load( [Q.RND_DIR,Q.RND_NAME,'.vmrs'], '-mat' );
  for l=1:Q.RND_SPEC_N
     ls = num2str(l);
     eval(['TAG=Q.RND_SPEC_TAGS',ls,';'])
     TAG=TAG(2:length(TAG)-1);
     load( [Q.RND_DIR,Q.RND_NAME,'.',TAG], '-mat' );
     for u=1:size(SP,2)
       SP(:,u)  = SP(:,u) ./ vmrs{l};
     end
     plot_sp(SP,z_abs,TAG);     
  end
end
%
%=== temperature
if Q.RND_TEMP_DO
  load( [Q.RND_DIR,Q.RND_NAME,'.t_field'], '-mat' );    
  load( [Q.RND_DIR,Q.RND_NAME,'.t_abs'], '-mat' );    
  for u=1:size(T,2)
     T(:,u)  = T(:,u) ./ t_abs;
   end
   plot_temp(T,z_abs);        
end
%
%=== noise
if Q.RND_THN_DO
  load( [Q.RND_DIR,Q.RND_NAME,'.noise'],  '-mat' );
  plot_noise(N)
end
%
out(1,-1);
%
keyboard



%  --------------------------------------------------------
function plot_sp(sp,z,tg)
%
m = mean(sp');
s = std(sp');
figure(gcf+1)
figsize(10,10)
subplot(1,2,1);
plot(m,1e-3*z);
xlabel('mean [-]');
ylabel('altitude [-]');
title(['                                  rnd ',tg,' / a priori ',tg]);
subplot(1,2,2);
plot(s,1e-3*z);
xlabel('std [%]');
return
%  --------------------------------------------------------
function plot_temp(sp,z)
%
m = mean(sp');
s = std(sp');
figure(gcf+1)
figsize(10,10)
subplot(1,2,1);
plot(m,1e-3*z);
xlabel('mean [-]');
ylabel('altitude [-]');
title('                          rnd TEMPERATURE / a priori TEMPERATURE');
subplot(1,2,2);
plot(s,1e-3*z);
xlabel('std [%]');
%  --------------------------------------------------------
function plot_noise(n)
%
%    std has to be in Wm-2HZ-1sr-1
%    std=3.5 K(Tb=2500) -> std=3.5*7.681e-17; 
%
m = mean(n');
s = std(n');
figure(gcf+1)
figsize(10,10)
subplot(2,1,1)
plot(m)
ylabel('mean [W m-2 Hz-1 sr-1]');
title('rnd NOISE')
subplot(2,1,2)
plot(s)
xlabel('channels');
ylabel('std [W m-2 Hz-1 sr-1]');
%
figure(gcf+1)
figsize(10,10)
subplot(2,1,1)
plot(m/7.681e-17)
ylabel('mean [K]');
title('rnd NOISE')
subplot(2,1,2)
plot(s/7.681e-17)
xlabel('channels');
ylabel('std [K]');
