%------------------------------------------------------------------------
% NAME:     qp_y
%
%           A function to calculate the spectrum corresponding to a Q 
%           structure. 
%
%           Not all fields of Q must be set. 
%
%           This function can be used to simulate measurements to test
%           the inversion.
%
%           So far is no noise or baseline ripple added to the spectrum.
%
% FORMAT:   [y,PTZ,VMRs] = qp_y( Q )
%
% OUT:      y              Calculated spectrum.
%           PTZ            A matrix with p_abs, t_abs and z_abs as columns.
%           VMRs           A matrix corresponding to the ARTS WSV vmrs. 
% IN:       Q              Setting structure.
% OPTIONAL: -
% TEMPLATE: basic.tmplt
%------------------------------------------------------------------------

% HISTORY: 2001.01.17  Started by by Patrick Eriksson.


function  [y,PTZ,VMRs] = qp_y( Q )



%=== Load H
%
load( [Q.OUT,'.h'], '-mat' )



%=== Create temporary dir
%
tmpdir    = temporary_directory( Q.TMP_AREA );



%=== Get full path of template file and create cfile
%
template = which( 'basic.tmplt' );
%
QE.ABS_SAVE = 0;
QE.ABS_EXIT = 0;
QE          = qp_hdf( Q, QE );
%
[cfile,basename] = qtool( Q, tmpdir, template, QE );



%=== Run ARTS
%
qp_arts( Q, cfile );



%=== Load data
%
y = read_artsvar( basename, 'y' );
y = H * y;
%
p_abs = read_artsvar( basename, 'p_abs' );
t_abs = read_artsvar( basename, 't_abs' );
z_abs = read_artsvar( basename, 'z_abs' );
%
VMRs = read_artsvar( basename, 'vmrs' );
VMRs = VMRs';
%
np   = length( p_abs );
%
PTZ  = zeros( np, 3 );
%
PTZ(:,1) = p_abs;
PTZ(:,2) = t_abs;
PTZ(:,3) = z_abs;


%=== Delete the temporary directory
delete_tmp_dir( Q.TMP_AREA, tmpdir );
