%------------------------------------------------------------------------
% NAME:     qpack
%
%           The function to read Q definition functions (QDFs).
%
%           This function sets all on and do variables to a value. Most variables
%           are set to 0, but a number of exceptions exist. After these defualt
%           values are set, the function calls the specified QDF (fname).
%
%           Note that a QDF can call another QDF. For example, all common
%           settings can be defined in one QDF, and the QDF for a 
%           particular case starts then by calling the common QDF.
%           
%           After calling the QDF, some smaller operations are performed.
%           So far is only the global variable REPORT_LEVEL set to the 
%           value of Q.QP_LEVEL. 
%
%           The function can also return the verion number of Qpack if
%           the input argument is '-v'. The version number of Qpack is
%           stored/handled by the function QPACK_VERSION.
%
% FORMAT:   Q = qpack( fname )
%              or
%           qpack -v
%
% OUT:      Q       the Q structure
% IN:       fname   the name of the QDF to call
% OPTIONAL: -
%
% TEMPLATE: -
%------------------------------------------------------------------------

% HISTORY: 2001.03.25  Created by Patrick Eriksson


function Q = qpack( fname )


%= A special feature for version number: qpack -v
%
if nargin & strcmp(fname,'-v')
  qpack_version;
  return
end

%=== Set default values. Most things are turned off.
%
Q.ARTS_ERROR_IGNORE    = 0;
Q.QPACK_ERROR_IGNORE   = 0;
Q.QPACK_WARNING_IGNORE = 0;
Q.USE_HDF              = 1;
Q.HSE_IN_ON            = 0;
Q.HSE_RETRIEVAL_ON     = 0;
Q.REFRACTION_ON        = 0;
Q.EMISSION_ON          = 0;
Q.ANTENNA_ON 	       = 0;
Q.DSB_ON     	       = 0;
Q.BACKEND_ON 	       = 0;
Q.BACKEND_IF 	       = 0;
Q.FREQSWITCH_ON        = 0;
Q.FREQSWITCH_REVERSE   = 0;
Q.BINVIEW_ON 	       = 0;
Q.BINNING_ON           = 0;
Q.KRED_ON    	       = 0;
Q.LRED_ON    	       = 0;
Q.CHCORR_ON            = 0;
%
Q.MEASNOISE_DO         = 0;
Q.CALINOISE_DO         = 0;
Q.TEMPERATURE_DO       = 0;
Q.TEMPERATURE_FAST     = 1;
Q.TEMPERATURE_RANGE    = [100 325];
Q.POINTING_DO          = 0;
Q.POINTING_PDF         = 'gaussian';
Q.POINTING_COR         = 1;
Q.FREQUENCY_DO         = 0;
Q.CONTABS_DO           = 0;
Q.EGROUND_DO           = 0;
Q.POLYFIT_DO           = 0;
Q.PPOLYFIT_DO          = 0;
Q.TB_REFLOADS_DO       = 0;
Q.PROPCAL_DO           = 0;
Q.SINEFIT_DO           = 0;
Q.PSINEFIT_DO          = 0;

% for spectro parameters
Q.SPECTRO_TAGS         = [];
Q.SPECTRO_DO           = 0;
Q.INTENS_ON            = 0;
Q.POSITION_ON          = 0;
Q.AGAM_ON              = 0;
Q.SGAM_ON              = 0;
Q.NAIR_ON              = 0;
Q.NSELF_ON             = 0; 
Q.PSHIFT_ON            = 0; 
Q.SAVE                 = ''; 
%
% others
Q.LINEFORMAT  = 'Arts'; %for Line format, This is for the case when
                        % the spectral data is from other catalogs.
	                    % Possible competition: 'Hitran', 'Jpl',
                        % 'Myran2', and 'Arts'		
                        % e.g. Q.LINEFORMAT  = 'Mytran2', reads
                        % from a Mytran format;              
Q.SELTAGS              = '';
Q.PSF_DO               = 0;
Q.FREQ_CALIB_DO        = 0;
%
Q.CLS_SPECIES_POS_ON   = 0;
Q.CLS_RECALC_ABS_ON    = 1;
Q.CLS_ABS_SPECIES_ON   = 0;
Q.CLS_RECALC_WFS_NITER = 1;
Q.CLS_WFS_UNIT         = 'frac';
Q.CLS_NONLIN_ON        = 0;


%=== The only allowed option for these ORDER field is now 1.
%=== The fields are now not listed in README. The fields are still in
%=== the code if the option of ORDER = 3 will be activated sometime.
%
Q.F_ORDER         = 1;
Q.ZA_ORDER        = 1;
Q.ANTENNA_ORDER   = 1;
Q.DSB_ORDER       = 1;
Q.BACKEND_ORDER   = 1;

if nargin

  %=== Call the QDF
  %
  eval([ 'Q = ', fname, '(Q);'])


  %=== Set REPORT_LEVEL
  %
  global REPORT_LEVEL
  %
  REPORT_LEVEL = Q.QP_LEVEL;

end
