%------------------------------------------------------------------------
% NAME:     qpi_continua
%
%           Inline function to include definition of continua in the
%           control file.
%
% FORMAT:   qpi_continua( Q, fid )
%
% OUT:      -
% IN:       Q     Setting structure
%           fid   File identifier for the control file being created.
%------------------------------------------------------------------------

% HISTORY: 2001.04.17  Created by Patrick Eriksson


function qpi_continua( Q, fid )

%=== Open continua file
%
fid_in = fopen( fullfile( Q.SPECTRO_DIR, Q.CONTINUA), 'r' );
%
if fid_in < 0
  error(sprintf('Could not open file %s',fullfile(Q.SPECTRO_DIR,Q.CONTINUA)));
end



%=== Write to cfile ===========================================================

%= Init continua
%
fprintf(fid, 'cont_descriptionInit{\n}\n'); 


%= Copy from definition file
%
s = fgets( fid_in );
%
while isstr( s )
  %
  fprintf( fid, '%s', s );
  %
  s = fgets( fid_in );
  %
end


fclose( fid_in );
