%------------------------------------------------------------------------
% NAME:     article_figs
%
%           This QDF was used to create error characterisation figures
%	    for the Qpack article for JQSRT 2003.
%
%	    The settings corresponds roughly to an Odin-SMR band, but
%           the values do not give a true representation of the Odin-SMR
%	    inversions.
%
% FORMAT:   Q = article_figs( Q )
%
% OUT:      Q    the setting structure for Qpack
% IN:       Q    the setting structure for Qpack
%------------------------------------------------------------------------

% HISTORY: 2003-05-27  Created by Patrick Eriksson


function Q = sample_q( Q )


%=== Report levels
%
Q.QP_LEVEL   = 2;
Q.ARTS_LEVEL = 0;


%=== Directories
%
top_dir          = '/home/patrick/ARTS/Qpack/Samples';
%
Q.ARTS           = 'arts';
Q.TMP_AREA       = '/tmp';
%
Q.OUT            = fullfile(top_dir,'Out','out');
Q.SPECTRO_DIR    = fullfile(top_dir,'Spectroscopy');
Q.CALCGRIDS_DIR  = fullfile(top_dir,'CalcGrids');
Q.SENSOR_DIR     = fullfile(top_dir,'Sensor');
Q.RETRIEVDEF_DIR = fullfile(top_dir,'RetrievDef');


%=== Atmospheres
%
Q.APRIORI_VMR = ...
       '/home/patrick/ARTS/arts-data/atmosphere/fascod/midlatitude-winter';
Q.APRIORI_PTZ     = ...
       '/home/patrick/ARTS/arts-data/atmosphere/fascod/midlatitude-winter.tz.aa';

%
Q.SETUP_VMR = ...
 ['"/home/patrick/ARTS/arts-data/atmosphere/fascod/midlatitude-winter",',...
  '"/home/patrick/ARTS/arts-data/atmosphere/fascod/tropical"' ];
Q.SETUP_PTZ     = ...
 ['"/home/patrick/ARTS/arts-data/atmosphere/fascod/midlatitude-winter.tz.aa",',...
  '"/home/patrick/ARTS/arts-data/atmosphere/fascod/tropical.tz.aa"' ];



%=== Species
%
Q.RETRIEVAL_TAGS   = [ ...
      '"ClO",', ...
      '"O3",', ...
      '"N2O",', ...
      '"H2O-MPM89"' ]; 
Q.SPECIES_KGRIDS   = [ ...
      '"grid.strato.aa",', ...
      '"grid.strato.aa",', ...
      '"grid.lowstrato.aa",', ...
      '"grid.lowstrato.aa"' ];
Q.SPECIES_COVMATS  = [ ...
      '"sx.std.aa",', ...
      '"sx.std.aa",', ...
      '"sx.std.aa",', ...
      '"sx.std.aa",' ];
%
Q.OTHER_TAGS       = '"N2-SelfContStandardType"';


%=== Spectroscopy
%
Q.LINEFILE         = 'lines501.4';
%
Q.LINESHAPE        = 'Voigt_Kuntz3';
Q.LINESHAPE_FACTOR = 'quadratic'; 
Q.LINESHAPE_CUTOFF = -1;
%
Q.CONTINUA         = 'continua_std';


%=== Hydrostatic eq.
Q.HSE_IN_ON          = 1;
Q.HSE_RETRIEVAL_ON   = 0;
Q.HSE_PREF           = 1.01e5;
Q.HSE_ZREF           = 0;


%=== RTE
%
Q.PLATFORM_ALTITUDE  = 625e3;
Q.STEPLENGTH_RTE     = 20e3;
%
Q.GROUND_ALTITUDE    = 200; 
Q.GROUND_EMISSION    = 0.5;
%
Q.REFRACTION_ON      = 0;
Q.REFR_METHOD        = 'Boudouris';
Q.REFR_LFAC          = ceil( Q.STEPLENGTH_RTE/2e3 );
%
Q.EMISSION_ON        = 1;


%=== Calculation grids
%
Q.P_ABS     = 'p_abs.aa';
Q.F_MONO    = 'f_mono.aa';
Q.ZA_PENCIL = 'za_pencil.aa';


%=== Sensor
%
Q.ANTENNA_ON    = 1;
Q.ANTENNA_ZA    = 'antenna_za.aa';
Q.ANTENNA_FILE  = 'antenna.aa';
Q.ANTENNA_ORDER = 1;
Q.ANTENNA_MOVE  = 0.011;
%
Q.DSB_ON        = 1;
Q.DSB_FILE      = 'sbfilter501.380.aa';
Q.DSB_ORDER     = 1;
Q.DSB_FPRIMARY  = 501.38e9;
Q.DSB_LO        = 497.38e9;
%
Q.BACKEND_ON    = 1;
Q.BACKEND_FREQS = 'backend_freqs.aa';
Q.BACKEND_FILE  = 'ac_channel_r1.16.ab';
Q.BACKEND_ORDER = 1;


%=== Thermal noise
%
Q.MEASNOISE_DO     = 2;
Q.MEASNOISE_COVMAT = 'mnoise_501.380.aa';
%
Q.CALINOISE_DO     = 0;
Q.CALINOISE_COVMAT = 'cnoise_501.380.aa';


%=== Retrieval/error quantities beside species
%
Q.TEMPERATURE_DO       = 3;
Q.TEMPERATURE_KGRID    = 'grid.strato.aa';
Q.TEMPERATURE_COVMAT   = 'sx.temperature.aa';
Q.TEMPERATURE_FAST     = 1;
%
Q.POINTING_DO          = 3;
Q.POINTING_STDV        = 0.02;   
Q.POINTING_DELTA       = 0.001;
%
Q.FREQUENCY_DO         = 0;
Q.FREQUENCY_STDV       = 1e6;   
Q.FREQUENCY_DELTA      = 200e3;
%
Q.CONTABS_DO           = 0;
Q.CONTABS_ORDER        = 0;
Q.CONTABS_LIMITS       = [501.18e9 501.58e9];
Q.CONTABS_KGRID        = 'grid.strato.aa';
Q.CONTABS_COVMAT       = 'sx.std.aa';
Q.CONTABS_REF_SPECIES  = '"N2-SelfContStandardType","H2O-MPM89"';
%
Q.EGROUND_DO           = 0;
Q.EGROUND_LIMITS       = [400e9 600e9];
Q.EGROUND_COVMAT       = 'sx.eground.aa';
Q.EGROUND_MINMAX       = [0 1];
%
Q.POLYFIT_DO           = 1;
Q.POLYFIT_ORDER        = 1;
Q.POLYFIT_COVMATS      = '"sx.polyfit.02K.aa","sx.polyfit.02K.aa"';
%
Q.TB_REFLOADS_DO       = 1;
Q.TB_REFLOADS_NOMINAL  = [0 300];
Q.TB_REFLOADS_STDV     = [0 3];
%
Q.PROPCAL_DO           = 0;
Q.PROPCAL_TB_REF       = 0;
Q.PROPCAL_STDV         = 0.2;


%=== Retrieval parameters
%
Q.RETRIEVAL_METHOD     = 'oem';
%
Q.CLS_NONLIN_ON        = 0;


