function do_refmod


%= Read US 1976 (that is defined with 36 points)
%
[p,t,z,s1,s2] = read_ptz( 'US1976.txt', 36 );


%= Create PTZ file
%
write_datafile( 'refmod.ptz.aa', [p,t,z], 'MATRIX', 6, str2mat(s1,s2) );



%= Read a file with US 1966 data, defined with 41 points, to get pressures
%= for the profiles
%
[p2,t2,z2] = read_ptz( 'zpt45n41.jul', 41 );
%
p = 10 .^ interp1( z, log10(p), z2 );


%= Open input file for profiles
%
fid = fopen('refmod99','r');

%= Loop species (positions above 50 are isotopomers, HDO is 49 and is removed
%= below)
for i = 1:50

  %= Read species and source information
  %
  s = fgetl(fid);
  %
  molecule = s(6:13);
  ind      = find ( molecule ~= ' ' );
  molecule = molecule(ind);
  %
  source = deblank( s(16:length(s) ) );

  %= Replace CL with Cl and BR with Br
  %
  ind = findstr( molecule, 'CL' );
  molecule(ind+1) = 'l';
  %
  ind = findstr( molecule, 'BR' );
  molecule(ind+1) = 'r';

  %= Read profile 
  %
  x = read_n( fid, 41 );

  %= Create ARTS file
  %
  if i ~= 49
    write_datafile( ['refmod.',molecule,'.aa'], [p,x], 'MATRIX', 4, source );
  end
end 


%= Close file
%
fclose(fid);



function x = read_n( fid, n )
  x = zeros(n,1);
  %
  for j = 1:ceil(n/5)
    for k = 1:5
      if (j-1)*5+k > n
        break;
      end 
      x((j-1)*5+k) = fscanf( fid, '%e', 1 );
      fscanf( fid, '%c', 1 );
    end
    fgetl( fid );
  end
  %
  x = x(n:-1:1);
return


function [p,t,z,s1,s2] = read_ptz( filename, n )

  %= Open file
  %
  fid = fopen(filename,'r');
  
  %= Read altitudes
  %
  fgetl(fid);
  fgetl(fid);
  %
  z = read_n( fid, n ) * 1e3;
  
  %= Read pressure
  %
  s1 = fgetl(fid);
  %
  p = read_n( fid, n ) * 1e2;
  
  %= Read temperature
  %
  s2 = fgetl(fid);
  %
  t = read_n( fid, n );
  
  %= Close file
  %
  fclose(fid);
return