#!/usr/bin/env python

import os.path
import imp

pyarts = imp.find_module("PyARTS")[1]

def source_module(target):
    if target=='PyARTS.rst':
        return os.path.join(pyarts, "__init__.py")
    else:
        return os.path.join(pyarts, target.split('.')[0] + ".py")

def func_desc_entry(target):
    s=target+': ./desc_func.py '+source_module(target)+'\n\t./desc_func.py '+\
       target[:-4]+'\n'
    return s

def docstring_entry(target):
    s=target+': ./docstring.py '+source_module(target)+'\n\t./docstring.py '+\
       target[:-4]+'\n'
    return s



funcdescfile=file('funcdesclist.txt')
docstringfile=file('docstringlist.txt')

linelist=funcdescfile.readlines()
funcdesclist=[]
for s in linelist:
    if len(s.strip())>0:
        funcdesclist.append(s.strip())

linelist=docstringfile.readlines()
docstringlist=[]
for s in linelist:
    if len(s.strip())>0:
        docstringlist.append(s.strip())

makefile=file('Makefile','w')

makefile.write('userguide.pdf: userguide.tex\n\tpdflatex userguide.tex\n\tpdflatex userguide.tex\n')

makefile.write('userguide.tex: userguide.rst stylesheet.tex ../README.txt makefile_gen.py docstringlist.txt funcdesclist.txt version.rst clouds.png SingleScatteringData.png')
for f in funcdesclist:
    makefile.write(' '+f)
for f in docstringlist:
    makefile.write(' '+f)
makefile.write('\n\trst2latex -g -d --use-latex-toc --use-latex-docinfo --use-latex-citations --stylesheet=stylesheet.tex userguide.rst > userguide.tex\n')

makefile.write('version.rst: version.py ../setup.py\n\tpython version.py\n')

for f in funcdesclist:
    makefile.write(func_desc_entry(f))
for f in docstringlist:
    makefile.write(docstring_entry(f))

makefile.write('clean:\n\trm -f userguide.aux userguide.log userguide.out')
for f in funcdesclist:
    makefile.write(' '+f)
for f in docstringlist:
    makefile.write(' '+f)

makefile.close()
