"""This script uses arts_scat.refice, and the plotting module to plot the
real and imaginary components of the refractive index of ice for a range of
temperatures at 5 EOS-MLS frequencies"""


from PyARTS import arts_scat
from PyARTS.plotting import *

figure(figsize=(12,5))
clf()
f = [122e9,200.5e9,230e9,636.5e9,2531e9]
t=linspace(213.16,272.16,100)
figpos=[0.02,0.06,0.96,0.8]
for i in range(5):
    m=[]
    for ti in t:
        m.append(arts_scat.refice(f[i],ti))
    m=array(m)
    mySubplot(2,5,i+1,figpos)
    plot(t,m.real)
    setp(gca(),'xticks',[200,220,240,260,280])
    if i==0:
        ylabel('Re(m)')
    title(str(f[i]/1e9)+' GHz',position=(0.5,1.15))
    mySubplot(2,5,i+6,figpos)
    plot(t,m.imag)
    setp(gca(),'xticks')
    if i==0:
        ylabel('Im(m)')
    setp(gca(),'xticks',[200,220,240,260,280])
    xlabel('T (K)')

figtext(0.5,0.93,'Complex refractive index of ice for EOSMLS frequencies',
        fontsize=14,horizontalalignment='center')

savefig('eosmlsrefice.png')
savefig('eosmlsrefice.eps')

#show()
