from PyARTS.arts_math import *
import numpy
import unittest

def qrombtestfn(x):
    y=x*numpy.ones([4,4],float)
    return y

def qrombtest():
    Integral,error=qromb(qrombtestfn,2,5,0.00001)
    return Integral,error

class Interp1DFieldByZTest(unittest.TestCase):
    """Testing the function arts_math.interp1DFieldByZkm"""
    zfile='../data/tropical.z.xml'
    tfile='../data/tropical.t.xml'
        
    def testNoErrorsWithGoodInput(self):
        """interp1DFieldByZkm should run with out errors for good input"""
        zkm=10.5
        t=interp1DFieldByZkm(self.zfile,self.tfile,zkm)
    def testOutOfRangeError(self):
        """interp1DFieldByZkm should raise OutOfRangeError with bad input"""
        zkm=1000
        self.assertRaises(OutOfRangeError,
                          interp1DFieldByZkm,self.zfile,
                          self.tfile,zkm)


class LocateTest(unittest.TestCase):
    def test(self):
        """Testing the locate function"""
        xa=[1,2,3,4,5,6,7]
        assert(locate(xa,1)==0)
        assert(locate(xa,2.3)==1)
        assert(locate(xa,7)==5)
	assert(locate(xa,8)==6)
        assert(locate(xa,0)==-1)
        xa=numpy.array(xa,float)
        assert(locate(xa,1)==0)
        assert(locate(xa,2.3)==1)
        assert(locate(xa,7)==5)
        assert(locate(xa,8)==6)
        assert(locate(xa,0)==-1)
        
class PolintTest(unittest.TestCase):
    def test(self):
        """Testing the polint function"""
	y,dy=polint([1,3],[1,3],2)
	assert y==2,"polint failed linear interpolation!"
	y,dy=polint([1,2,3],[1,4,9],4)
	assert y==16,"polint failed quadratic extrapolation!"
	y,dy=polint([1,2,3,6],[1,8,27,216],4)
	assert y==64,"polint failed cubic interpolation!"
	y,dy=polint([1,2,3,6],[1,2,3,6],4)
	assert y==4,"polint failed cubic interpolation!"
	y,dy=polint([1,2,3,6,36,56],[1,2,3,6,36,56],4)
	assert y==4,"polint failed 5th degree interpolation!"


class LinearQrombTest(unittest.TestCase):
    def test(self):
        """testing qromb for a linear function"""
        answer,error=qrombtest()
	assert (answer==numpy.ones([4,4])*10.5).all(),"Integral incorrect!"
	assert (error==numpy.zeros([4,4])).all(),"Non-zero error for linear function!"

class Sin2QrombTest(unittest.TestCase):
    def test(self):
        """testing qromb for sin^2(x)"""
	def y(x):
	    return numpy.sin(x)**2*numpy.ones([2,2],float)
	answer,error=qromb(y,0,numpy.pi/2,0.0001)
	assert abs(answer[0,0]-numpy.pi/4)<0.0001,"Integral incorrect!"

class Sin5xCos7xQrombTest(unittest.TestCase):
    def test(self):
        """integrating sin(5x)cos(7x) between 0 and pi (in a 2 by 2) array"""
	def y(x):
	    return numpy.sin(5*x)*numpy.cos(7*x)*numpy.ones([2,2],float)
	answer,error=qromb(y,0,numpy.pi,0.0001,20,7)
	assert abs(answer[0,0])<0.0001,"Integral incorrect!"

class Sin5xCos7xQrombTestFloat(unittest.TestCase):
    def test(self):
        """integrating sin(5x)cos(7x) between 0 and pi (float)"""
	def y(x):
	    return numpy.sin(5*x)*numpy.cos(7*x)
	answer,error=qromb(y,0,numpy.pi,0.0001,20,7)
	assert abs(answer)<0.0001,"Integral incorrect!"

class array_trapzdTest(unittest.TestCase):
    def test(self):
        """testing array-at-a-time trapzd"""
        x=numpy.array([1.0,2.0,3.0,4.0])
        assert(array_trapzd(x,1.0)==7.5),"Incorrect answer in array_trapzdTest"



if __name__=='__main__':
    unittest.main()


