#######################################################################
#SOME TESTS!
#a good one might be to check the normalisation condition - you know,
#the one with Csca and integrating Z11
#Another good one might be to compare tmatrix spherical results with
#Mie theory
import unittest
from PyARTS.arts_scat import *
from PyARTS.general import DATA_PATH
from PyARTS.arts_types import SingleScatteringData
import numpy

class Compare20_30spheres(unittest.TestCase):
    def testTest(self):
        """Test for consistency between results for spheres in ptype=20
        and ptype=30 formats"""
        precision=0.001
        sphere20=SingleScatteringData({"f_grid":[500e9, 501e9],
                                       "aspect_ratio":1.0000001,
                                       "equiv_radius":100})
        sphere20.calc(precision)
        oblatesphere30=SingleScatteringData({"f_grid":[500e9, 501e9],
                                             "aspect_ratio":1.0000001,
                                             "equiv_radius":100,
                                             "ptype":30})
        oblatesphere30.calc(precision)
        print "\nmaximum relative error between Kjj for horizontally aligned"
        print "slightly oblate sphere and randomly oriented slightly oblate"
        print "sphere (aspect ratio=1.0000001)"
        relerror=(oblatesphere30.ext_mat_data[0,0,:,0,0]-sphere20.ext_mat_data[0,0,0,0,0])/\
                sphere20.ext_mat_data[0,0,0,0,0]
        print relerror.max()
        assert (relerror<0.0001).all(),"Unnacceptable difference between ptype=20 and ptype=30 for spheres"

        print "\nmaximum  off diagonal Kij divided by Kjj for horizontally aligned"
        print "slightly oblate sphere (aspect ratio=1.0000001)"
        relerror=oblatesphere30.ext_mat_data[0,0,:,0,1:]/sphere20.ext_mat_data[0,0,0,0,0]
        maxvector=numpy.zeros(relerror.shape[0],float)
        for i in range(relerror.shape[0]):
            maxvector[i]=relerror[i,relerror[i, :].argmax()]
        print maxvector.max()
        assert maxvector.max()<0.0001,"Off diagonal extinction patrix elements should be (close to) zero for spheres"


        print "\nmaximum relative (to Z11(0,0,0)) error between phase matrix \nfor horizontally aligned"
        print "slightly oblate sphere and randomly oriented slightly oblate"
        print "sphere (aspect ratio=1.0000001)"
        relerror=(numpy.take(oblatesphere30.pha_mat_data[0,0,:,0,0,0,:],[0,1,5,10,11,15],1)-\
                  sphere20.pha_mat_data[0,0,:,0,0,0,:])/sphere20.pha_mat_data[0,0,0,0,0,0,0]
        maxvector=numpy.zeros(relerror.shape[0],float)
        for i in range(relerror.shape[0]):
            maxvector[i]=relerror[i,relerror[i, :].argmax()]

        print maxvector.max()
        assert maxvector.max()<0.0001,"Unacceptable difference in phase matrix between ptype=20 and ptype=30 for spheres"

        print "\nmaximum relative error between Kabs[0] for horizontally aligned"
        print "slightly oblate sphere and randomly oriented slightly oblate"
        print "sphere (aspect ratio=1.0000001)"
        relerror=abs((oblatesphere30.abs_vec_data[0,0,:,0,0]-sphere20.abs_vec_data[0,0,0,0,0]))/\
                sphere20.abs_vec_data[0,0,0,0,0]
        print relerror.max()
        assert relerror.max()<0.002,"Unnacceptable difference between ptype=20 and ptype=30 for spheres"



        prolatesphere30=SingleScatteringData({"f_grid":[500e9, 501e9],
                                              "aspect_ratio":0.9999999,
                                              "equiv_radius":100,
                                              "ptype":30})
        prolatesphere30.calc(precision)

        print "\nmaximum relative error between Kjj for horizontally aligned"
        print "slightly prolate sphere and randomly oriented slightly oblate"
        print "sphere (aspect ratio=1.0000001)"
        relerror=(prolatesphere30.ext_mat_data[0,0,:,0,0]-sphere20.ext_mat_data[0,0,0,0,0])/\
                sphere20.ext_mat_data[0,0,0,0,0]
        print relerror.max()
        assert (relerror<0.0001).all(),"Unnacceptable difference between ptype=20 and ptype=30 for spheres"

        print "\nmaximum  off diagonal Kij divided by Kjj for horizontally aligned"
        print "slightly prolate sphere (aspect ratio=1.0000001)"
        relerror=prolatesphere30.ext_mat_data[0,0,:,0,1:]/sphere20.ext_mat_data[0,0,0,0,0]
        maxvector=numpy.zeros(relerror.shape[0],float)
        for i in range(relerror.shape[0]):
            maxvector[i]=relerror[i,relerror[i, :].argmax()]
        print maxvector.max()
        assert maxvector.max()<0.0001,"Off diagonal extinction patrix elements should be (close to) zero for spheres"


        print "\nmaximum relative (to Z11(0,0,0)) error between phase matrix \nfor horizontally aligned"
        print "slightly prolate sphere and randomly oriented slightly oblate"
        print "sphere (aspect ratio=1.0000001)"
        relerror=(numpy.take(prolatesphere30.pha_mat_data[0,0,:,0,0,0,:],[0,1,5,10,11,15],1)-\
                  sphere20.pha_mat_data[0,0,:,0,0,0,:])/sphere20.pha_mat_data[0,0,0,0,0,0,0]
        maxvector=numpy.zeros(relerror.shape[0],float)
        for i in range(relerror.shape[0]):
            maxvector[i]=relerror[i,relerror[i,:].argmax()]

        print maxvector.max()
        assert maxvector.max()<0.0001,"Unacceptable difference in phase matrix between ptype=20 and ptype=30 for spheres"

        print "\nmaximum relative error between Kabs[0] for horizontally aligned"
        print "slightly prolate sphere and randomly oriented slightly oblate"
        print "sphere (aspect ratio=1.0000001)"
        relerror=abs((prolatesphere30.abs_vec_data[0,0,:,0,0]-sphere20.abs_vec_data[0,0,0,0,0]))/\
                sphere20.abs_vec_data[0,0,0,0,0]
        print relerror.max()
        assert relerror.max()<0.01,"Unnacceptable difference between ptype=20 and ptype=30 for spheres"

class ScatFileTest20(unittest.TestCase):
    """Simple test that generates a SingleScatteringData file"""
    def runTest(self):
        print "Testing randomly oriented oblate spheroid"
        scatdata=SingleScatteringData({"f_grid":[248e9, 249e9],
                                       "aspect_ratio":3.0,
                                       "equiv_radius":100})
        scatdata.calc()
        scatdata.save(DATA_PATH+"/test_scat_file.xml")
        print "testing that we can load generated file"
        scatdata=SingleScatteringData.load(DATA_PATH+"/test_scat_file.xml")
        print "testing that we can regenerate file for loaded"
        print "SingleScatteringData object"
        scatdata.save(DATA_PATH+"/test_scat_file.xml")
    def tearDown(self):
        import os
        os.remove(DATA_PATH+"/test_scat_file.xml")

class ScatFileTest30(ScatFileTest20):
    def runTest(self):
        print "Testing horizontally aligned oblate spheroid" 
        self.scatdata=SingleScatteringData({"f_grid":[248e9, 249e9],
                                            "aspect_ratio":3.0,
                                            "equiv_radius":100,
                                            "ptype":30,
                                            "aa_grid":numpy.arange(0,181,10)})
        self.scatdata.calc()
        self.scatdata.save("test_scat_file.xml")
        print "Testing horizontally aligned prolate spheroid" 
        self.scatdata=SingleScatteringData({"f_grid":[248e9, 249e9],
                                            "aspect_ratio":0.33,
                                            "equiv_radius":100,
                                            "ptype":30,
                                            "aa_grid":numpy.arange(0,181,10)})
        self.scatdata.calc()
        self.scatdata.save(DATA_PATH+"/test_scat_file.xml")

class BatchTest(unittest.TestCase):
    """A test of the batch generate function"""
    def runTest(self):
        print "Running multi-process file generation test (batch generate) "
        #create scat directory if it isn't already there
        self.remove_scat_dir=0
        if not os.path.exists(DATA_PATH+'/scat'):
            os.mkdir(DATA_PATH+'/scat')
            self.remove_scat_dir=1
        argdict={'T_grid':[[220]],'f_grid':[[200.5e9]],'ptype':[20],
                 'aspect_ratio':[0.5,1.0001,2],'phase':'ice',
                 'equiv_radius':numpy.arange(10,1000,50),'NP':[-1],
                 'za_grid':numpy.arange(0,181,10),'aa_grid':numpy.arange(0,181,10)}
        self.outdata=batch_generate(argdict,2)
    def tearDown(self):
        #clean up
        for f in self.outdata:
            os.remove(f)
        if self.remove_scat_dir:
            os.rmdir(DATA_PATH+'/scat')

class QuadFixedTest(unittest.TestCase):
    """Checks that the fixed quad code (if present) gives results sufficiently
    close to the double precision code"""
    def runTest(self):
        #first check that we have the quad version
        if 'tmatrixq' in dir(tmatrix):
            print "Comparing double and quad precision fixed T matrix calculations"

            #define particle
            r_v=100
            aspect_ratio=2
            NP=-1
            precision=0.001
            lam=1000
            mrr=1.7
            mri=0.05
            #define incident and scattered propagation directions
            za_inc=30
            za_scat=45
            aa_inc=67
            aa_scat=130
            #define particle orientation
            BETA=90
            alpha=50
            #calculate phase matrix (double precision)
            tmat_fxd(r_v,aspect_ratio,NP,lam,mrr,mri,precision,use_quad=0)
            Zd=phasmat(lam,za_inc,za_scat,aa_inc,aa_scat,BETA,alpha)
            print "double precision phase matrix: "+str(Zd)
            #calculate phase matrix (quad precision)
            tmat_fxd(r_v,aspect_ratio,NP,lam,mrr,mri,precision,use_quad=1)
            Zq=phasmat(lam,za_inc,za_scat,aa_inc,aa_scat,BETA,alpha)
            print "double precision phase matrix: "+str(Zq)
            print 'difference: '+str(Zq-Zd)
        else:
            print "Skipping QuadFixedTest (quad precision not enabled)"
class QuadRandomTest(unittest.TestCase):
    """Checks that the random quad code (if present) gives results sufficiently
    close to the double precision code"""
    def runTest(self):
        #first check that we have the quad version
        if 'tmq' in dir(tmd):
            print "Comparing double and quad precision random T matrix calculations"
            r_v=100
            aspect_ratio=2
            NP=-1
            precision=0.001
            lam=1000
            mrr=1.7
            mri=0.05
            nza=19
            double_output = tmat_rnd(r_v, aspect_ratio, NP, lam, mrr, mri, precision,
                                     nza, use_quad=0)
            quad_output = tmat_rnd(r_v, aspect_ratio, NP, lam, mrr, mri, precision,
                                   nza, use_quad=1)
            for i in range(len(double_output)):
                print 'double: '+str(double_output[i])
                print 'quad: '+str(quad_output[i])
                print 'difference: '+str(quad_output[i]-double_output[i])
        else:
            print "Skipping QuadRandomTest (quad precision not enabled)"

class ConvErrorTest(unittest.TestCase):
    """Tests behaviour when T-matrix does not converge"""
    #some bad parameters
    r_v=2000,
    aspect_ratio=0.1
    lam=1000
    np=-2
    mrr=1.7
    mri=0.02
    def testTMatFxdRaiseConvError(self):
        """tmat_fxd should raise TMatConvError when given terrible parameters"""
        self.assertRaises(TMatConvError,tmat_fxd,self.r_v,self.aspect_ratio,
                          self.np,self.lam,self.mrr,self.mri,0.001)


class MishchenkoBenchTest(unittest.TestCase):
    """Tests tmat_fxd and tmatrix.ampl against benchmark results presented in
    @ARTICLE
    {mishchenko00,
    author = "M.I. Mishchenko",
    title = "Calculation of the amplitude matrix for a nonspherical particle in a
    fixed orientation",
    journal = "Applied Optics",
    volume = 39,
    number = 6,
    year = 2000,
    pages = "1026--1031"}"""
    def testCylinder(self):
        """Testing cylinder amplitude scattering matrix against Mishchenko benchmark"""
        vvbench=complex(-1.737,19.706)
        vhbench=complex(-0.562,0.247)
        hvbench=-2.013-2.398j
        hhbench=-3.088+20.401j
        equiv_radius=3.0**(1.0/3)/numpy.sqrt(2.5)*10
        tmat_fxd(equiv_radius, aspect_ratio=0.5, NP=-2, lam=6.283185, mrr=1.5,
                 mri=0.02, precision=0.001, use_quad=0)
        vv,vh,hv,hh = tmatrix.ampl(tmatrix.nmax,dlam=6.283185,tl1=65.0,tl=56.0,
                                   pl1=128.0,pl=114.0,alpha=145.0,beta=52.0)
        dvv=vv-vvbench
        dvh=vh-vhbench
        dhv=hv-hvbench
        dhh=hh-hhbench
        assert abs(dvv)/abs(vv)<0.002,"vv component failed"
        assert abs(dvh)/abs(vh)<0.002,"vh component failed"
        assert abs(dhv)/abs(hv)<0.002,"hv component failed"
        assert abs(dhh)/abs(hh)<0.002,"hh component failed"
    def testSpheroid(self):
        """Testing spheroid amplitude scattering matrix against Mishchenko benchmark"""
        vvbench=complex(-5.0941,24.402)
        vhbench=complex(-1.9425,1.9971)
        hvbench=-1.1521-3.0978j
        hhbench=-6.9323+24.748j
        equiv_radius=2**(5.0/6.0)/numpy.sqrt(1+4*numpy.pi*numpy.sqrt(3)/9)*10
        tmat_fxd(equiv_radius, aspect_ratio=0.5, NP=-1, lam=6.283185, mrr=1.5,
                 mri=0.02, precision=0.001, use_quad=0)
        vv,vh,hv,hh = tmatrix.ampl(tmatrix.nmax,dlam=6.283185,tl1=65.0,tl=56.0,
                                   pl1=128.0,pl=114.0,alpha=145.0,beta=52.0)
        dvv=vv-vvbench
        dvh=vh-vhbench
        dhv=hv-hvbench
        dhh=hh-hhbench
        assert abs(dvv)/abs(vv)<0.002,"vv component failed"
        assert abs(dvh)/abs(vh)<0.002,"vh component failed"
        assert abs(dhv)/abs(hv)<0.002,"hv component failed"
        assert abs(dhh)/abs(hh)<0.002,"hh component failed"






if __name__=='__main__':
    unittest.main()
