macro (ARTS_GET_VERSION_FROM_CHANGELOG VERSION_NUMBER CHANGELOG_FILE)

file (READ "${CHANGELOG_FILE}" ARTS_CHANGELOG)

string (REGEX MATCH "\\* arts-([0-9]+-[0-9]+-[0-9a-z]+)" 
  ARTS_FULL_VERSION "${ARTS_CHANGELOG}")

string (REGEX REPLACE ".*\\* arts-([0-9]+)-([0-9]+)-([0-9]+.*)" "\\1.\\2.\\3"
  ARTS_FULL_VERSION "${ARTS_FULL_VERSION}")

set (${VERSION_NUMBER} ${ARTS_FULL_VERSION})

endmacro (ARTS_GET_VERSION_FROM_CHANGELOG VERSION_NUMBER CHANGELOG_FILE)


macro (ARTS_GET_VERSION_FROM_AUTOVERSION VERSION_NUMBER AUTOVERSION_FILE)

file (READ "${AUTOVERSION_FILE}" ARTS_AUTOVERSION)
string (REGEX MATCH "([0-9]+\\.[0-9]+\\.[0-9]+)" 
  ARTS_FULL_VERSION "${ARTS_AUTOVERSION}")

set (${VERSION_NUMBER} ${ARTS_FULL_VERSION})

endmacro (ARTS_GET_VERSION_FROM_AUTOVERSION VERSION_NUMBER AUTO_VERSION_FILE)


macro (ARTS_WRITE_VERSION_FILE VERSION_FILE VERSION_STRING)
  file (READ "${ARTS_BINARY_DIR}/auto_version.txt" ARTS_VERSION)
  file (WRITE "${VERSION_FILE}" "${VERSION_STRING}")
endmacro (ARTS_WRITE_VERSION_FILE VERSION_FILE VERSION_STRING)


