; ==========================================================================
; ####################### ARTS IDL INTERFACE PROCEDURE #####################
; ==========================================================================
;
pro aii_color_table
;
;==========================================================================
;
; NAME:
;       aii_color_table
; PURPOSE:
;       Provides a color table for plots made with IDL.
;
; EXPLANATION:
;       Special color table, derived from the tek_color.
;
; INPUTS:
;       slide  (integer)   the content of the string decides the action, 
;                          Possible values are 'yes' and 'no'.
;
; OUTPUTS:
;       IDL intern color tabale
;
; MODIFICATION HISTORY:
;       07/10/95        created S. Buehler
;       05/12/01        T. Kuhn  alpha version for arts created 
;
; ==========================================================================
; ##########################################################################
; ==========================================================================
;
;r = [ 0,255,  0,  0,  0,196,255,255,160,  0,  0,140,255, 84,170, 14,191,114, $
;      43, 63,127,191,255,170,101, 43, 43, 43,114,191,229,255]
;g = [ 0,  0,255,  0,255,196,  0,127, 54,255,127,  0,  0, 84,170,131,255,255,$
;      255,211,170,140, 84,229,229,229,170,127, 84, 43, 22, 255 ]
;b = [ 0,  0,  0,255,255,  0,211,  0,255,152,255,211,140, 84,170, 84,114,152,$
;      191,211,211,211,229,114,140,170,229,255,255,255,255,0]

rgb = [ [   0 ,   0 ,   0 ],$   ;  0 black
        [ 255 ,   0 ,   0 ],$   ;  1 red
        [   0 ,   0 , 255 ],$   ;  3 blue
        [ 196 , 196 ,   0 ],$   ;  5 
        [ 255 ,   0 , 211 ],$   ;  6 
        [ 255 , 127 ,   0 ],$   ;  7 
        [ 160 ,  54 , 255 ],$   ;  8 
        [ 127 , 170 , 211 ],$   ;  9
        [   0 , 127 , 255 ],$   ; 10
        [ 140 ,   0 , 211 ],$   ; 11
        [ 255 ,   0 , 140 ],$   ; 12
        [  84 ,  84 ,  84 ],$   ; 13
        [ 170 , 170 , 170 ],$   ; 14
        [  14 , 131 ,  84 ],$   ; 15
        [ 191 , 255 , 114 ],$   ; 16
        [ 114 , 255 , 152 ],$   ; 17
        [  43 , 255 , 191 ],$   ; 18
        [  63 , 211 , 211 ],$   ; 19
        [   0 , 255 , 152 ],$   ; 20 
        [ 191 , 140 , 211 ],$   ; 21
        [ 255 ,  84 , 229 ],$   ; 22
        [ 170 , 229 , 114 ],$   ; 23
        [ 101 , 229 , 140 ],$   ; 24
        [  43 , 229 , 170 ],$   ; 25
        [  43 , 170 , 229 ],$   ; 26
        [  43 , 127 , 255 ],$   ; 27
        [ 114 ,  84 , 255 ],$   ; 28
        [ 191 ,  43 , 255 ],$   ; 29
        [ 229 ,  22 , 255 ],$   ; 30
        [   0 , 255 ,   0 ],$   ;  2 light green
        [   0 , 255 , 255 ],$   ;  4 cyan
        [ 255 , 255 ,   0 ] ]   ; 31

tvlct,rgb[0,*],rgb[1,*],rgb[2,*]
;
end
;
; ==========================================================================
; ##########################################################################
; ==========================================================================
