function value = colloc_config(varargin)

% colloc_config Handling of Cloudsat Collocation configuration settings
%
% Similar to 'atmlab'.
%
% $Id: colloc_config.m 6537 2010-10-06 19:00:16Z gerrit $

persistent A


[A,value] = prstnt_struct( A, @colloc_config_defs, varargin );

 
function A = colloc_config_defs

% overwrite existing collocations

A.overwrite = false;

%% maximum collocation distance and time

A.distance = 15; % km
A.interval = 900; % seconds

%% distances to be for sure to be inside the pixel

A.distance_for_average_MHS = 7.5; % km
A.distance_for_average_HIRS = 5; % For HIRS/4

