% QARTS   Defines setting fields for arts calculations
%
%    The function defines all Qarts fields. All fields are initiated to {},
%    that indicates that no value has been specified. No data will be
%    transferred to arts for fields later not given a non-{} value. The
%    settings are converted to control files by *qarts2cfile*. This function
%    adds automatically method calls for saving (standard) variables.
%    everything else must be specified by the qarts fields or be handled by
%    include control files.
%
%    This function is organised in such way that *qcheck* and *qinfo* can be
%    used.
%
%    Allowed formats differ between the fields. For information about a
%    specific field, type e.g.:
%       qinfo( @qarts, 'ABSORPTION' );
%
% FORMAT   [Q,I] = qarts
%        
% OUT   Q  Setting structure (with all fields set to {}).
%       I  Includes same fields as Q, where the content of each field
%          is a description string (used by *qinfo*).

% 2004-09-07   Created by Patrick Eriksson.


function [Q,I] = qarts
 
%-----------------------------------------------------------------------------
Q.ABSORPTION = {};
I.ABSORPTION = [ ...
'String describing how absorption shall be calculated/obtained. ',...
'Existing options are:', ...
'#    {}        : Absorption variables defined by include files. All ',...
'absorption fields below will be ignored.',...    
'#   ''OnTheFly'' : Absorption is calculated for each propagation path ',...
'point. The agenda *abs_scalar_gas_agenda* must here be set by an include ',...
'file. No other absorption variables need to be set.',...
'#   ''CalcTable'': Calculate and use an absorption look-up table. See ',...
'*qarts_abstable* for simple setting of needed variables.',...
'#   ''LoadTable'': Load and use pre-calculated absorption look-up table, ',...
'defined by field *ABS_LOOKUP*.',
];
%-----------------------------------------------------------------------------
Q.ABS_LINES = {};
I.ABS_LINES = [ ...
'The data on spectroscopic lines to use. See *ABS_LINES_FORMAT* for how ',...
'to handle cases without lines. Can be given in two ways:', ...
'#1. As a file name. All formats handled by arts can then be used. See', ...
' ABS_LINES_FORMAT. The reading is not restricted to any frequency range.', ...
'#2. As an array of line data. This option is only allowed when ',...
'ABS_LINES_FORMAT is set to ''Arts''.'
];
%-----------------------------------------------------------------------------
Q.ABS_LINES_FORMAT = {};
I.ABS_LINES_FORMAT = [ ...
'The format of spectroscopic data.', ...
'#   Possible line formats are ''Arts'', ''Hitran'', ''Jpl'' and ',...
'''Mytran2''. Note that these strings must be given exactly as stated here ',...
'(first upper case etc.).',...
'#   The field can further be set to ''None'' which indicates that no line ',...
'data shall be included (the WSV *abs_lines_per_species* is set to be empty).'
];
%-----------------------------------------------------------------------------
Q.ABS_LINESHAPE = {};
I.ABS_LINESHAPE = [ ...
'The line shape to use. The same line shape is used for all tag groups.', ...
' Shall be a string. ', ...
'Do "arts -d abs_lineshapeDefine" to list valid options.'
];
%-----------------------------------------------------------------------------
Q.ABS_LINESHAPE_CUTOFF = {};
I.ABS_LINESHAPE_CUTOFF = [ ...
'The line shape cut-off to apply. The same cut-off is used for all tag', ...
' groups. A value of -1 means no cut-off. ', ...
'Do "arts -d abslineshapeDefine" for further information.'
];
%-----------------------------------------------------------------------------
Q.ABS_LINESHAPE_FACTOR = {};
I.ABS_LINESHAPE_FACTOR = [ ...
'The line shape normalisation factor to apply. The same factor is used', ...
' for all tag groups. Shall be a string. ', ...
'Do "arts -d abs_lineshapeDefine" for valid options.'
];
%-----------------------------------------------------------------------------
Q.ABS_LOOKUP = {};
I.ABS_LOOKUP = [ ...
'Has the same functionality as the arts WSV with the same name.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.ABS_MODELS = {};
I.ABS_MODELS = [ ...
'Control files including descriptions of absorption models to ', ...
'use (called continua in arts). This shall be a series of calls of ', ...
'*abs_cont_descriptionAppend* (call of *abs_cont_descriptionInit* shall ',...
'be included).',...
'#   Given as an array of strings. The atmlab setting ARTS_INCLUDES is ',...
'recognised. A file containing standard choices is: ',...
'ARTS_INCLUDES/continua.arts'
];
%-----------------------------------------------------------------------------
Q.ABS_NLS = {};
I.ABS_NLS = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. Can be set by *qarts_abs_species*.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.ABS_NLS_PERT = {};
I.ABS_NLS_PERT = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable. Empty ([])signifies no perturbations.'
];
%-----------------------------------------------------------------------------
Q.ABS_P = {};
I.ABS_P = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.ABS_SPECIES = {};
I.ABS_SPECIES = [ ...
'Specification of absorption species. Arts requires in many cases that ', ...
'H2O and N2 are included. ',... 
'This is a structure array defining species and associated retrieval ',...
'variables. These sub-fields are defined: ', ...
'# ',...
'#<TAG> Tag group data, following *arts_tgs_cnvrt*.', ...
'# ',...
'#<ATMDATA> VMR data for the species. The input shall follow the atmdata ',...
'format, defined in *isatmdata*. The data specified here are not directly ',...
'given to arts, it can only be used to set-up *VMR_FIELD*. This step is ',...
'handled by *qarts_vmr_field*. The field is accordingly not mandatory. ',...
'The main usage of this field should be to import data of climatology ',...
'character. Can be given as a variable or a file saved through *gf_save*.', ...
'# ',...
'#<RETRIEVE> If set to true the species is retrieved. Otherwise the ', ...
'species is not retrieved (what a surprise!).', ...
'# ',...
'#<UNIT> Retrieval unit. Allowed choices are ''rel'', ''vmr'', ''nd'', ', ...
'and ''logrel''. For some more information:',...
'#arts -d jacobianAddAbsSpecies.', ...
'# ',...
'#<GRIDS> Retrieval grids for the species. An array of vectors of length 3:',...
' {p_grid,lat_grid,lon_grid}. Grids for dimensions not used shall be ',...
'empty.',...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for the species. Size must ',...
'match the grid field. Data must match <UNIT>. A matrix, that can be ',...
'sparse.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved state for the species ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.',...
'# ',...
'#<L2_RANGE> Fine tuning of L2 data ranges. ',...
'The default is to store data directly matching the retrieval ',...
'grids. This is done if the field is non-existing. This ',...
'field allows you to either crop or extend range of the L2 data. ',...
'It is then a vector of length, at least, twice the atmospheric ',...
'dimensionality: [p_min p_max lat_min lat_max lon_min lon_max] where ',...
'lat_min gives the minimum latitude to include etc. ',...
'# If a given limit is inside the range covered by the corresponding ',...
'retrieval grid, this results in that the data are cropped. This ',...
'feature can be used to remove parts that are of no interest for ',...
'L2 data (such as parts always having a low measurement response). ',...
'# The default L2 output is not reflecting the fact that values at ',...
'end points of the retrieval grids are valid all the way to the ',...
'matching atmospheric limit. This field can also be used to ',...
'incorporate this part. If a limit is outside the retrieval grid, ',...
'the L2 data will also include the retrieved state at the ',...
'specified or the atmospheric limit (which is the closest to the ',...
'retrieval grid). In practice this signifies a duplication of end point ',...
'data.',...
'# Only retrieved profile and errors are modified. Averaging kernel, ',...
'covariance and gain matrices are kept consistent with the original ',...
'retrieval grids.'
];
%-----------------------------------------------------------------------------
Q.ABS_T = {};
I.ABS_T = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.ABS_T_PERT = {};
I.ABS_T_PERT = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable. Empty ([]) signifies no perturbations.'
];
%-----------------------------------------------------------------------------
Q.ABS_VMRS = {};
I.ABS_VMRS = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.ABS_WSMS = {};
I.ABS_WSMS = [ ...
'Workspace method calls to include just before calculation of absorption.'
];
%-----------------------------------------------------------------------------
Q.ANTENNA_DIM = {};
I.ANTENNA_DIM = [ ...
'As the arts WSV with the same name.', ...
'#   This field can be ignored, depending on SENSOR_RESPONSE.'
];
%-----------------------------------------------------------------------------
Q.ATMOSPHERE_DIM = {};
I.ATMOSPHERE_DIM = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.BATCH = {};
I.BATCH = [ ...
'Batch calculations. Defined by a structure, described in ',...
'*qartsBatch*. Type ''qinfo(@qartsBatch);'' for further information. ',...
'Batch calculations are not started automatically (in e.g. *arts_y*), but ',...
'must be selected specifically (most easily done by using *arts_batch*).' 
];
%-----------------------------------------------------------------------------
Q.CLOUDBOX_DO = {};
I.CLOUDBOX_DO = [ ...
'Boolean to activate the cloud box (scattering calculations), or not.',...
'#   {}: Nothing is done. Relevant data are assumed to be specified by ',...
'inclusion files.',...
'#    0: Call of *cloudboxOff* is included.',...
'#    1: Action follows setting of field *CLOUDBOX*.'
];
%-----------------------------------------------------------------------------
Q.CLOUDBOX = {};
I.CLOUDBOX = [ ...
'Handling of cloudbox/scattering. Defined by a structure, described in ',...
'*qartsCloudbox*. Type ''qinfo(@qartsCloudbox);'' for further information.'
];
%-----------------------------------------------------------------------------
Q.EMISSION_AGENDA = {};
I.EMISSION_AGENDA = [ ...
'As the arts WSV with the same name.', ...
' WSMs are listed as an array of strings, with possible arguments.'
];
%-----------------------------------------------------------------------------
Q.F_GRID = {};
I.F_GRID = [ ...
'Has the same functionality as the arts WSV with the same name.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'variable.'
];
%-----------------------------------------------------------------------------
Q.FFIT = {};
I.FFIT = [ ...
'Structure for specification of frequency fit retrievals. No retrieval is ',...
'made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddFreqShiftAndStretch*. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate frequency retrieval.', ...    
'# ',...
'#<DF> Size for numerical perturbation. See used WSM.', ...
'# ',...
'#<ORDER> Order of frequency fit, max value is 1 (0=shift, 1=stretch).', ...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for frequency shift and ',...
'stretch. A 1x1 or 2x2 matrix, depending on ORDER.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved frequency fit variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.HSE = {};
I.HSE = [ ...
'Variables associated with hydrostatic equilibrium. A structure with the ',...
'sub-fields:',...
'# ',...
'#<ON> Flag to enforce hydrostatic equilibrium. If true, the WSV *z_field*',... 
'is recalculated by *z_fieldFromHSE* (note that a "first guess" *z_field* ',... 
'must be provided).',...
'# ',...
'#<P> Pressure for reference point. Matches the WSV *p_hse*.',...
'# ',...
'#<ACCURACY> Calculation accuracy. Matches the WSV *z_hse_accuracy*.',...
'# ',...
'#If the field is unset, no action is taken. This equals to set Q.HSE.ON ',...
'to false. Note the setting Q.T.HSE which controls the calculation of t-',...
'jacobians. The two settings are treated as independent, but should ',...
'be set to the same value (true/false). If the HSE is maintained during ',...
'the iterations of a temperature retrieval is controled by THIS field.'
];    
%-----------------------------------------------------------------------------
Q.INCLUDES = {};
I.INCLUDES = [ ...
'Paths to control files to be included. These files will be included ',...
'at the top of the control file, only preceded by WSMS_AT_START. Given ',...
'as an array of strings.',...
'#   The atmlab setting ARTS_INCLUDES is recognised. To include the ',...
'standard arts general definition file, select:',...
'{''ARTS_INCLUDES/general.arts''}'
];
%-----------------------------------------------------------------------------
Q.INPUT_FILE_FORMAT = 'binary';
I.INPUT_FILE_FORMAT = [ ...
'The file format for arts input files. That is, the format of the files ',...
'created in matlab to be read by arts. Possible options are ''binary'', '...
'and ''double''. The binary option, that is default, should be most '...
'efficient. Use ''double'' if you want to visually inspect the files ',...
'generated. (The option ''float'' is not allowed, as this is not always '...
'sufficient for frequency data.)'
];
%-----------------------------------------------------------------------------
Q.IY_CLEARSKY_AGENDA = {};
I.IY_CLEARSKY_AGENDA = [ ...
'As the arts WSV with the same name.', ...
' WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.IY_SPACE_AGENDA = {};
I.IY_SPACE_AGENDA = [ ...
'As the arts WSV with the same name. ', ...
'WSMs are listed as an array of strings, with possible arguments. ', ...
'See PPATH_STEP_AGENDA for a practical example on format to use.'
];
%-----------------------------------------------------------------------------
Q.J_DO = {};
I.J_DO = [ ...
'Boolean to include calculation of jacobians.',...
'#   {}: Nothing is done. Relevant data are assumed to be specified by ',...
'inclusion files.',...
'#    0: Call of *jacobianOff* is included.',...
'#    1: Action follows setting of field *J*.'
];
%-----------------------------------------------------------------------------
Q.LAT_GRID = {};
I.LAT_GRID = [ ...
'Has the same functionality as the arts WSV with the same name, with the ', ...
'difference that a scalar value is accepted when ATMOSPHERE_DIM = 1. It ',...
'could be needed to set such a scalar value when *qarts_vmr_field* and ',...
'similar functions are used.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.LON_GRID = {};
I.LON_GRID = [ ...
'Has the same functionality as the arts WSV with the same name, with the ', ...
'difference that a scalar value is accepted when ATMOSPHERE_DIM = 1. It ',...
'could be needed to set such a scalar value when *qarts_vmr_field* and ',...
'similar functions are used.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.L2_EXTRA = {};
I.L2_EXTRA = [ ...
'Information to functions repacking retrieval information. Such a product ', ...
'is normally denoted as L2 data. This field lists data to be included ', ...
'beside the direct retrieval quantities, for which their L2 field has ',...
'the same functionality. The information is given as string array, e.g.:',...
'#    Q.L2_EXTRA = {''cost'',''mresp'',''ptz''}',...
'#There is no general L2 function and the possible data output (and ',...
'coding) differs between the functions.'
];
%-----------------------------------------------------------------------------
Q.MBLOCK_AA_GRID = {};
I.MBLOCK_AA_GRID = [ ...
'Has the same functionality as the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   If the antenna dimension is 1, this variable can be left as {}. ', ...
'For 2D antennas it has to be set even if the sensor does not include an ', ...
'antenna.', ...
'#   Can be given either as the name of a XML file, or as a Matlab',...
' variable.'
];
%-----------------------------------------------------------------------------
Q.MBLOCK_ZA_GRID = {};
I.MBLOCK_ZA_GRID = [ ...
'Has the same functionality as the arts WSV with the same name. ', ...
'This has to be set even if the sensor does not include an antenna.', ...
'#   Can be given either as the name of a XML file, or as a Matlab',...
' variable.'
];
%-----------------------------------------------------------------------------
Q.OUTPUT_FILE_FORMAT = {};
I.OUTPUT_FILE_FORMAT = [ ...
'As the arts WSV with the same name. That is, the format for files created ',...
'by arts. Possible options are ''binary'' and ''ascii''. The binary option ',...
'should in general be most efficient.'
];
%-----------------------------------------------------------------------------
Q.POINTING = {};
I.POINTING = [ ...
'Structure for specification of pointing fit retrievals. No retrieval is', ...
'made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddPointing*. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate pointing retrieval.', ...    
'# ',...
'#<DZA> Size for numerical perturbation. See used WSM.', ...
'# ',...
'#<POLY_ORDER> Order of polynomial to describe pointing errors. ', ...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for pointing fit variables. ',...
'A square matrix with POLY_ORDER+1.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved pointing variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.POLYFIT = {};
I.POLYFIT = [ ...
'Structure for specification of polynomial baseline fits. No retrieval is', ...
'made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddPolyfit*. All no_xxx_variation arguments of the WSM ',...
'are set to default value. The different polynomial coefficients are ',...
'assumed to be uncorrelated. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate pointing retrieval', ...    
'# ',...
'#<ORDER> Order of polynomial fit.', ...
'# ',...
'#<SX0> Covariance matrix of a priori knowledge for coefficient of order ',...
'zero. There shall be such a matrix for each coefficient order until:',...
'# ',...
'#<SXn> Covariance matrix of a priori knowledge for coefficient of order ',...
'POLY_ORDER. The last required covariance matrix.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved baseline variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.PPATH_LMAX = {};
I.PPATH_LMAX = [ ...
'As the arts WSV with the same name .', ...
'#   Can be given either as the name of a XML file, or as a Matlab',...
' variable.'
];
%-----------------------------------------------------------------------------
Q.PPATH_LRAYTRACE = {};
I.PPATH_LRAYTRACE = [ ...
'As the arts WSV with the same name .', ...
'#   Can be given either as the name of a XML file, or as a Matlab',...
' variable.'
];
%-----------------------------------------------------------------------------
Q.PPATH_STEP_AGENDA = {};
I.PPATH_STEP_AGENDA = [ ...
'As the arts WSV with the same name.', ...
'WSMs are listed as an array of strings. ', ...
'An example showing how an agenda definition looks like:', ...
'#   Q.PPATH_STEP_AGENDA={''ppath_stepGeometric''}' 
];
%-----------------------------------------------------------------------------
Q.P_GRID = {};
I.P_GRID = [ ...
'Has the same functionality as the arts WSV with the same name.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.R_GEOID = {};
I.R_GEOID = [ ...
'Geoid radius. As the arts WSV with the same name .'
];
%-----------------------------------------------------------------------------
Q.RAW_ATMOSPHERE = {};
I.RAW_ATMOSPHERE = [ ...
'If set a "raw atmosphere" in read. This is the main file name for the ',...
'raw atmosphere. See further ''arts -d AtmRawRead''. ',...
'#Data in the fields T_FIELD, Z_FIELD or VMR_FIELD are included at a later ',...
'stage and will then overwrite the data from the raw atmosphere. This ',...
'thus some flexibility to mix data from different sources.'
];
%-----------------------------------------------------------------------------
Q.RAW_ATM_EXPAND_1D = {};
I.RAW_ATM_EXPAND_1D = [ ...
'Boolean to expand an 1D raw atmosphere to set ATMOSPHERE_DIM. If set to ',...
' 1, the WSM *AtmFieldsCalcExpand1D* is used instead of *AtmFieldsCalc*.',...
'This variable is only used if RAW_ATMOSPHERE is set.'
];
%-----------------------------------------------------------------------------
Q.REFR_INDEX_AGENDA = {};
I.REFR_INDEX_AGENDA = [ ...
'As the arts WSV with the same name. ', ...
'If PPATH_STEP_AGENDA does not involve refraction, this field can be ', ...
'left as {}.',...
'#    WSMs are listed as an array of strings. ', ...
'See PPATH_STEP_AGENDA for a practical example on format to use.' 
];
%-----------------------------------------------------------------------------
Q.SENSOR_DO = {};
I.SENSOR_DO = [ ...
'Boolean to include sensor characteristics. Otherwise monochromatic pencil ',...
'beam calculations are performed. *SENSOR_POS/LOS* are used in both cases. ',...
'#   {}: Nothing is done. Relevant data are assumed to be specified by ',...
'inclusion files.',...
'#    0: Call of *sensorOff* is included.',...
'#    1: Action follows setting of field *SENSOR_RESPONSE*.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_LOS = {};
I.SENSOR_LOS = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_POS = {};
I.SENSOR_POS = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE = {};
I.SENSOR_RESPONSE = [ ...
'As the arts WSV with the same name. Three main options exist:', ...
'#1: The first option is to specify each variable associated with the ',...
'sensor individually. This field can then be the name of a XML file or ',...
'a Matlab sparse matrix. Other fields that must be specified for this ',...
'option include: ANTENNA_DIM, MBLOCK_ZA/AA_GRID and ',...
'SENSOR_RESPONSE_F/ZA/AA/POL.',...
'#2: The name of control files to include (ARTS_INCLUDES recognised). ',...
'Given as an array of strings.',...
'#3: Calculate the response from basic data. This field shall then be a ',...
'structure, following the definitions in *qartsSensor*. Type ',...
'''qinfo(@qartsSensor);'' for definition of required data fields.',...
'Other fields that must/may be specified here include ANTENNA_DIM and ',...
'MBLOCK_ZA/AA_GRID.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_AA = {};
I.SENSOR_RESPONSE_AA = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_AA_GRID = {};
I.SENSOR_RESPONSE_AA_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_F = {};
I.SENSOR_RESPONSE_F = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_F_GRID = {};
I.SENSOR_RESPONSE_F_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_POL = {};
I.SENSOR_RESPONSE_POL = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a Matlab',...
' variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_POL_GRID = {};
I.SENSOR_RESPONSE_POL_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a Matlab ',...
'variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_ZA = {};
I.SENSOR_RESPONSE_ZA = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_ZA_GRID = {};
I.SENSOR_RESPONSE_ZA_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.STOKES_DIM = {};
I.STOKES_DIM = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SURFACE_PROP_AGENDA = {};
I.SURFACE_PROP_AGENDA = [ ...
'As the arts WSV with the same name.', ...
' WSMs are listed as an array of strings.', ...
' See PPATH_STEP_AGENDA for a practical example on format to use.' 
];
%-----------------------------------------------------------------------------
Q.T = {};
I.T = [ ...
'Data and setting associated with atmospheric temperatures. Normally used ',...
'when retrieving temperature. Otherwise, *T_FIELD* can be set directly.',...
'# ',...
'#<ATMDATA> The input shall follow the atmdata format, defined in ',...
'*isatmdata*. The data specified here are not directly given to arts, it ',...
'can only be used to set-up *T_FIELD*. This step is handled by ',...
'*qarts_t_or_z_field*. The main usage of this field should be to import ',...
'data of climatology character. Can be given as a variable or a file saved ',...
'through *gf_save*.',...
'# ',...
'#<RETRIEVE> If set to true, atmospheric temperatures are retrieved.', ...
'# ',...
'#<GRIDS> Retrieval grids for temperature. An array of vectors of length 3:',...
' {p_grid,lat_grid,lon_grid}. Grids for dimensions not used shall be ',...
'empty.',...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for temperature. Size must ',...
'match the grid field. Data must match <UNIT>. A matrix, that can be ',...
'sparse.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved state for temperature ',...
'will be included in the L2 output. Otherwise not.',...
'# ',...
'#<L2_RANGE>  As the same field for ABS_SPECIES.',...
'# ',...
'#<HSE> As the argument to *jacobianAddTemperature* with same name. ',...
'Default here is "on". This refers only to the actual jacobian calculation.',...
' If the atmosphere itself fulfils HSE or not is controled by Q.HSE.',...
'# ',...
'#<METHOD> As the argument to *jacobianAddTemperature* with same name. ',...
'Default here is "analytical".',...
'# ',...
'#<DT> As the argument to *jacobianAddTemperature* with same name. ',...
'Default here is 1 K.',...
'# ',...
'#None of the fields are mandatory for pure forward calculations. If ',...
'RETRIEVAL is set to false, the other retrieval related fields are ignored.'
];  
%-----------------------------------------------------------------------------
Q.T_FIELD = {};
I.T_FIELD = [ ...
'As the arts WSV with the same name. Will replace temperature data inserted',...
' through RAW_ATMOSPHERE.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.TNOISE_C = {};
I.TNOISE_C = [ ...
'Thermal noise correlation. A matrix (sparse preferably) giving the ', ...
'correlation of thermal noise between channels. Hence, the diagonal ',...
'elements shall all be one. If the thermal noise is the same for all ',...
'channels and has a standard deviation of s, the covariance matrix is ',...
's*s*TNOISE_C.'
];
%-----------------------------------------------------------------------------
Q.VMR_FIELD = {};
I.VMR_FIELD = [ ...
'As the arts WSV with the same name. Will replace VMR data inserted ',...
'through RAW_ATMOSPHERE.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.',...
'#   For retrievals, the a priori state for *ABS_SPECIES* is determined ',...
'by this field.'
];
%-----------------------------------------------------------------------------
Q.WIND_U_FIELD = {};
I.WIND_U_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.WIND_V_FIELD = {};
I.WIND_V_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.WIND_W_FIELD = {};
I.WIND_W_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.WSMS_AT_END = {};
I.WSMS_AT_END = [ ...
'Workspace method calls to include at the far end of the control file. ',...
'As WSMS_AT_START beside position in control file.'
];
%-----------------------------------------------------------------------------
Q.WSMS_AT_START = {};
I.WSMS_AT_START = [ ...
'Workspace method calls to include at the top of the control file. These ',...
'calls will be executed before inclusion of files specified in INCLUDES.',...
'#Method calls are specified as an cell array of strings. For example, if ', ...
'no inclusion files are used, these calls could be useful to include',...
'#   { ''VectorSet(abs_n2,[0.7808])'', ''abs_cont_descriptionInit'' }'
];
%-----------------------------------------------------------------------------
Q.WSMS_BEFORE_RTE = {};
I.WSMS_BEFORE_RTE = [ ...
'Workspace method calls to include just before execution of *YCALC_WSMS* or ',...
'batch core part. Accordingly, this field is considered only if ',...
'spectra are calculated (ignored for e.g. pure absorption calculations). ',...
'Format as for WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.YCALC_WSMS = {};
I.YCALC_WSMS = [ ...
'Workspace method calls for performing radiative transfer calculations. ',...
'The standard choice should be that this fields includes a call of *yCalc*.',... 
' There is no clear division between this field and *WSMS_BEFORE_RTE*, but ',...
'for best flexibility this field should start with *yCalc* (or corresponding',...
' method), followed by post-processing not handled by other fields.',...
'#   Accordingly, this field is considered only if spectra are calculated ',...
'(ignored for e.g. pure absorption calculations). Format as for WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.Y_UNIT = {};
I.Y_UNIT = [ ...
'As the arts WSV with the same name. That is, the radiance unit. ',...
'The following options exist:', ...
'#   ''1''       : Basic radiances [W/m2/Hz/sr]',...
'#   ''RJBT''    : Conversion to brightness temperature by the Rayleigh-',...
'Jeans approximation of the Planck function.',...
'#   ''PlanckBT'': Conversion to brightness temperature by the Planck ',...
    'function.',...
'#For further information: ''arts -d y_unit''.'
];
%-----------------------------------------------------------------------------
Q.Z_ATMDATA = {};
I.Z_ATMDATA = [ ...
'The input shall follow the atmdata format, defined in *isatmdata*. The ',...
'data specified here are not directly given to arts, it can only be used ',...
'to set-up *Z_FIELD*. This step is handled by *qarts_t_or_z_field*. ',...
'The main usage of this field should be to import data of climatology ',...
'character. Can be given as a variable or a file saved through *gf_save*.'
];
%-----------------------------------------------------------------------------
Q.Z_FIELD = {};
I.Z_FIELD = [ ...
'As the arts WSV with the same name. Will replace altitude data inserted ',...
'through RAW_ATMOSPHERE.', ...
'#   Can be given either as the name of a XML file, or as a matching ',...
'Matlab variable.'
];
%-----------------------------------------------------------------------------
Q.Z_SURFACE = {};
I.Z_SURFACE = [ ...
'Surface altitude (above reference ellispoid). As the arts WSV with the ',...
'same name.'
];
%-----------------------------------------------------------------------------
