function [gmtStructureElements,gmtStructStructElements] = gmt_inputs
%% gmt_inputs
%  Purpose: A list of all the inputs and their types to gmt_plot
%
% OUT
%     cells: {@fhandle to chech the input,'stringname of field'}
%
% NOTE (to editor):
%    Make sure that new variables are added to these lists!
% $Id
% Created by Salomon Eliasson

gmtStructureElements    = {...
    @(x)(ischar(x))				,'basemap_axis'         ;...
    @(x)(islogical(x) || (isscalar(x) && x<2)),'display';...
    @(x)(ischar(x))				,'filename'             ;...
    @(x)(ischar(x))				,'figuretype'           ;...
    @(x)(iscellstr(x))			,'gmtset'               ;...
    @(x)(isscalar(x))			,'header_size'          ;...
    @(x)(isscalar(x))			,'header_offset'        ;...
    @(x)(islogical(x)||(isscalar(x)&&x<2)),'keep_files' ;...
    @(x)(ischar(x))				,'measure_unit'         ;...
    @(x)(islogical(x) || (isscalar(x) && x<2)),'nodata' ;...
    @(x)(ischar(x))				,'outdir'               ;...
    @(x)(ischar(x))				,'ticks'                ;...
    @(x)(ischar(x))				,'title'                ;...
    @(x)(ischar(x))				,'unit'                 ;...
    @(x)(ischar(x))				,'xunit'                ;...
    @(x)(ischar(x))				,'plotPlacement'        ;...
    @(x)(ischar(x))				,'region'               ;...
    @(x)(isvector(x))			,'datarange'            ;...
    @(x)(ischar(x))				,'grdimage'             ;...
    @(x)(ischar(x))				,'makecpt'              ;...
    @(x)(ischar(x))				,'cptfile'              ;...
    @(x)(ischar(x))				,'ctable'               ;...
    @(x)(ischar(x))				,'color_background'     ;...
    @(x)(ischar(x))				,'color_foreground'     ;...
    @(x)(ischar(x))				,'color_nan'            ;...
    @(x)(isscalar(x))			,'nlevels'              ;...
    @(x)(isscalar(x))			,'stepsize'             ;...
    @(x)(isvector(x))			,'tickval'              ;...
    @(x)(ischar(x))				,'grdcontour'           ;...
    @(x)(ischar(x))				,'pscale'               ;...
    @(x)(ischar(x))				,'pscale_nan'           ;...
    @(x)(islogical(x)||(isscalar(x)&&x<2)),'savelegend' ;...
    @(x)(islogical(x)||(isscalar(x)&&x<2)),'nanlegend'  ;...
    @(x)(ischar(x))				,'projection'           ;...
    @(x)(isscalar(x))			,'center'               ;...
    @(x)(isscalar(x))			,'map_width'            ;...
    @(x)(ischar(x))				,'proj'                 ;...
    @(x)(ischar(x))				,'pscoast'              ;...
    @(x)(iscell(x))				,'pspoly'               ;...
    @(x)(iscell(x))				,'pspolycolor'          ;...
    @(x)(iscell(x))				,'pspolythick'          ;...
    @(x)(isstruct(x))			,'locations'            ;...
    @(x)(isstruct(x)||ischar(x)),'coast'                ;...
    @(x)(isstruct(x)||ischar(x)),'nearneighbor'         ;...
    @(x)(isstruct(x)||ischar(x)),'pstext'               ;...
    @(x)(isstruct(x)||islogical(x)||(isscalar(x)&&x<2)) ,'legend';...
    };

gmtStructStructElements = struct(...
'coast',{{...
    @(x)(isscalar(x))			,'features'             ;...
    @(x)(ischar(x))				,'resolution'           ;...
    @(x)(ischar(x))				,'rivers'               ;...
    @(x)(isscalar(x))			,'width'                ;...
    @(x)(ischar(x))				,'color'                }},...
'nearneighbor',{{...
    @(x)(ischar(x))				,'search'               ;...
    @(x)(isscalar(x))			,'resolution'           }},...
'legend',{{...
    @(x)(isscalar(x))			,'annot_font_size_primary';...
    @(x)(isscalar(x))			,'box_spacing'          ;...
    @(x)(ischar(x))				,'position'             ;...
    @(x)(ischar(x))				,'position_nan'         ;...
    @(x)(islogical(x)||(isscalar(x)&&x<2)),'equalboxwidth';...
    @(x)(isscalar(x)||ischar(x)),'length'               ;...
    @(x)(ischar(x))				,'orientation'          ;...
    @(x)(ischar(x))				,'shift_tick_annotations';...
    @(x)(isscalar(x))			,'sidebar'              ;...
    @(x)(iscellstr(x))			,'tick_annotations'     ;...
    @(x)(ischar(x))				,'tick_annotation_format';...
    @(x)(islogical(x)||(isscalar(x) && x<2)),'tick_centering';...
    @(x)(isscalar(x))			,'tick_length'          ;...
    @(x)(isscalar(x))			,'tick_spacing'         ;...
    @(x)(ischar(x)||isscalar(x)),'width'                ;...
    @(x)(ischar(x)||isscalar(x)),'xpos'                 ;...
    @(x)(ischar(x)||isscalar(x)),'ypos'                 }},...
'colorrange',{{...
    @(x)(iscell(x))				,'colors'               ;...
    @(x)(ischar(x))				,'color_model'          }},...
'locations',{{...
    @(x)(isscalar(x))  			,'lat'                  ;...
    @(x)(isscalar(x))			,'lon'                  ;...
    @(x)(ischar(x))				,'name'                 ;...
    @(x)(ischar(x))				,'shape'                ;...
    @(x)(isscalar(x))			,'size'                 ;...
    @(x)(ischar(x))				,'color'                ;...
    @(x)(isscalar(x))			,'textsize'             ;...
    @(x)(ischar(x))				,'textcolor'            ;...
    @(x)(ischar(x))				,'textalign'            }},...
'contourline',{{...
    @(x)(isscalar(x))			,'spacing'              ;...
    @(x)(isvector(x))			,'range'                ;...
    @(x)(isscalar(x))			,'linethick'            ;...
    @(x)(ischar(x))				,'more'                 }},...
'psbox',{{...
    @(x)(isvector(x))			,'box'                  ;...
    @(x)(isvector(x))			,'boxes'                ;...
    @(x)(iscell(x))				,'boxcolor'             ;...
    @(x)(iscell(x))				,'boxthick'             }},...
'pstext',{{...
    @(x)(ischar(x))			    ,'text'                 ;...
    @(x)(isscalar(x))			,'lat'                  ;...
    @(x)(isscalar(x))			,'lon'                  ;...
    @(x)(ischar(x))				,'color'                ;...
    @(x)(isscalar(x))			,'fontnum'              ;...
    @(x)(isscalar(x))			,'justify'              ;...
    @(x)(isscalar(x))			,'angle'                ;...    
    @(x)(isscalar(x))			,'thick'                }}...
 );