macro (ARTS_TEST_RUN_CTLFILE TESTNAME CTLFILE)
  string(REGEX REPLACE "/" "." TESTNAME_LONG ${CTLFILE})
  string(REGEX REPLACE ".arts$" "" TESTNAME_LONG ${TESTNAME_LONG})
  set(TESTNAME_LONG arts.ctlfile.${TESTNAME}.${TESTNAME_LONG})
  if (CMAKE_MAJOR_VERSION EQUAL 2 AND CMAKE_MINOR_VERSION EQUAL 6)
    set(ARTS ${CMAKE_CURRENT_BINARY_DIR}/../src/arts -r022)
    if (ARTS_XML_DATA_DIR)
      set(ARTS ${ARTS} -D${ARTS_XML_DATA_DIR})
    endif (ARTS_XML_DATA_DIR)
    add_test(
      ${TESTNAME_LONG}
      COMMAND ${ARTS} ${CMAKE_CURRENT_SOURCE_DIR}/${CTLFILE}
      )
  else (CMAKE_MAJOR_VERSION EQUAL 2 AND CMAKE_MINOR_VERSION EQUAL 6)
    set(ARTS arts -r022)
    if (ARTS_XML_DATA_DIR)
      set(ARTS ${ARTS} -D${ARTS_XML_DATA_DIR})
    endif (ARTS_XML_DATA_DIR)
    add_test(
      NAME ${TESTNAME_LONG}
      COMMAND ${ARTS} ${CMAKE_CURRENT_SOURCE_DIR}/${CTLFILE}
      )
  endif (CMAKE_MAJOR_VERSION EQUAL 2 AND CMAKE_MINOR_VERSION EQUAL 6)
endmacro (ARTS_TEST_RUN_CTLFILE)

macro (ARTS_TEST_CMDLINE TESTNAME OPTIONS)
  if (CMAKE_MAJOR_VERSION EQUAL 2 AND CMAKE_MINOR_VERSION EQUAL 6)
    set(ARTS ${CMAKE_CURRENT_BINARY_DIR}/../src/arts)
    add_test(
      arts.cmdline.${TESTNAME}
      COMMAND ${ARTS} ${OPTIONS} ${ARGN}
      )
  else (CMAKE_MAJOR_VERSION EQUAL 2 AND CMAKE_MINOR_VERSION EQUAL 6)
    set(ARTS arts)
    add_test(
      NAME arts.cmdline.${TESTNAME}
      COMMAND ${ARTS} ${OPTIONS} ${ARGN}
      )
  endif (CMAKE_MAJOR_VERSION EQUAL 2 AND CMAKE_MINOR_VERSION EQUAL 6)
endmacro (ARTS_TEST_CMDLINE TESTNAME OPTIONS)

macro (ARTS_TEST_CTLFILE_DEPENDS TESTNAME DEPENDNAME)
  set_tests_properties(
    arts.ctlfile.${TESTNAME}
    PROPERTIES DEPENDS arts.ctlfile.${DEPENDNAME}
    )
endmacro (ARTS_TEST_CTLFILE_DEPENDS)

