% QP2_Y   Defines recognised fields for qpack2 measurement data
%
%    This function is organised in such way that *qcheck* and *qinfo*
%    can be used. To list all existing fields:
%       qinfo( @qp2_y );
%
%    Allowed formats differ between the fields. For information about a 
%    specific field, type e.g.:
%       qinfo( @qp2_y, 'Y' );
%
% FORMAT   [Q,I] = qp2_y
%        
% OUT   Q  Setting structure with default values for all recognised fields.
%       I  Includes same fields as Q, where the content of each field
%          is a description string (used by *qinfo*).

% 2009-07-01   Created by Patrick Eriksson.


function [Q,I] = qp2_y
  
%-----------------------------------------------------------------------------
Q.AA = {};
I.AA = [ ...
'Line-of-sight azimuth angle for the measurement. Only considered if ',...
'ATMOSPERE_DIM set to 3. A scalar value, or a ',...
'vector. See further *ZA*.',...'
];
%-----------------------------------------------------------------------------
Q.DAY = {};
I.DAY = [ ...
'Measurement time information. All these fields (YEAR, MONTH, ...) are ',...
'numeric scalars. This information is primarily used to extract data from ',...
'the climatology databases.'
];
%-----------------------------------------------------------------------------
Q.F = {};
I.F = [ ...
'Frequency for each value of Y. Not required information. Qpack2 uses ', ...
'this field only for consistency checks.'
];
%-----------------------------------------------------------------------------
Q.HOUR = {};
I.HOUR = [ ...
'Optional data. Allows a more detailed specification of measurement time. ',...
'Otherwise as field DAY.'
];
%-----------------------------------------------------------------------------
Q.HSE_P = {};
I.HSE_P = [ ...
'The reference point when enforcing hydrostatic equilibrium. The ',...
'geometrical altitude (HSE_Z) is given for one presssure (HSE_P).'
];
%-----------------------------------------------------------------------------
Q.HSE_Z = {};
I.HSE_Z = [ ...
'The reference point when enforcing hydrostatic equilibrium. The ',...
'geometrical altitude (HSE_Z) is given for one presssure (HSE_P).'
];
%-----------------------------------------------------------------------------
Q.LATITUDE = {};
I.LATITUDE = [ ...
'The geographical position of the measurement.'
];
%-----------------------------------------------------------------------------
Q.LONGITUDE = {};
I.LONGITUDE = [ ...
'The geographical position of the measurement. '
];
%-----------------------------------------------------------------------------
Q.MINUTE = {};
I.MINUTE = [ ...
'Optional data. Allows a more detailed specification of measurement time. ',...
'Otherwise as field DAY.'
];
%-----------------------------------------------------------------------------
Q.MONTH = {};
I.MONTH = [ ...
'Measurement time information. All these fields (YEAR, MONTH, ...) are ',...
'numeric scalars. This information is primarily used to extract data from ',...
'the climatology databases.'
];
%-----------------------------------------------------------------------------
Q.SECOND = {};
I.SECOND = [ ...
'Optional data. Allows a more detailed specification of measurement time. ',...
'Otherwise as field DAY.'
];
%-----------------------------------------------------------------------------
Q.TNOISE = {};
I.TNOISE = [ ...
'Magnitude of thermal noise, given as 1 standard devation. A scalar or a ',...
'column vector having the same length as y. If a scalar, the value is ',...
'applied for all spectrometer channels. If the measurement consists of ',...
'several spectra (see *ZA*), this field must be a matrix (or row vector) ',...
'where the columns give the noise for each spectrum.'
];
%-----------------------------------------------------------------------------
Q.Y = {};
I.Y = [ ...
'The spectrum.'
];
%-----------------------------------------------------------------------------
Q.YEAR = {};
I.YEAR = [ ...
'Measurement time information. All these fields (YEAR, MONTH, ...) are ',...
'numeric scalars. This information is primarily used to extract data from ',...
'the climatology databases.'
];
%-----------------------------------------------------------------------------
Q.ZA = {};
I.ZA = [ ...
'Line-of-sight zenith angle for the measurement. A scalar value, or a ',...
'vector. The fields *Z_PLATFORM* and *ZA*, as well as *AA* for 3D case, ',...
'must have the same size. IF these fields have a length > 1, the ',...
'measurement will consist of several spectra (having same *LAT* and *LON). ',...
'IN ARTS, these spectra are simulated as seperate measurement blocks. ',...
'Further, *TNOISE* must have a matching size, where the numbers of columns ',...
'shall match length of *ZA*.'
];
%-----------------------------------------------------------------------------
Q.Z_PLATFORM = {};
I.Z_PLATFORM = [ ...
'Altitude (above geoid) of observation platform. A scalar value, or a ',...
'vector. See further *ZA*.',...'
];
%-----------------------------------------------------------------------------
