% QARTS   Defines setting fields for arts calculations
%
%    The function defines all Qarts fields. All fields are initiated to {},
%    that indicates that no value has been specified. No data will be
%    transferred to arts for fields later not given a non-{} value. The
%    settings are converted to control files by *qarts2cfile*. This function
%    adds automatically method calls for saving (standard) variables.
%    everything else must be specified by the qarts fields or be handled by
%    include control files.
%
%    This function is organised in such way that *qcheck* and *qinfo* can be
%    used.
%
%    Allowed formats differ between the fields. For information about a
%    specific field, type e.g.:
%       qinfo( @qarts, 'ABSORPTION' );
%
% FORMAT   [Q,I] = qarts
%        
% OUT   Q  Setting structure (with all fields set to {}).
%       I  Includes same fields as Q, where the content of each field
%          is a description string (used by *qinfo*).

% 2004-09-07   Created by Patrick Eriksson.


function [Q,I] = qarts
 
%-----------------------------------------------------------------------------
Q.ABS_LINES = {};
I.ABS_LINES = [ ...
'The data on spectroscopic lines to use. See *ABS_LINES_FORMAT* for how ',...
'to handle cases without lines. Can be given in two ways:', ...
'#1. As a file name. All formats handled by arts can then be used. See', ...
' ABS_LINES_FORMAT. The reading is not restricted to any frequency range.', ...
'#2. As an array of line data. This option is only allowed when ',...
'ABS_LINES_FORMAT is set to ''Arts''.'
];
%-----------------------------------------------------------------------------
Q.ABS_LINES_FORMAT = {};
I.ABS_LINES_FORMAT = [ ...
'The format of spectroscopic data.', ...
'#   Possible line formats are ''Arts'', ''Hitran'', ''Jpl'' and ',...
'''Mytran2''. Note that these strings must be given exactly as stated here ',...
'(first upper case etc.).',...
'#   The field can further be set to ''None'' which indicates that no line ',...
'data shall be included (the WSV *abs_lines_per_species* is set to be empty).'
];
%-----------------------------------------------------------------------------
Q.ABS_LINESHAPE = {};
I.ABS_LINESHAPE = [ ...
'The line shape to use. The same line shape is used for all tag groups.', ...
' Shall be a string. ', ...
'Do "arts -d abs_lineshapeDefine" to list valid options.'
];
%-----------------------------------------------------------------------------
Q.ABS_LINESHAPE_CUTOFF = {};
I.ABS_LINESHAPE_CUTOFF = [ ...
'The line shape cut-off to apply. The same cut-off is used for all tag', ...
' groups. A value of -1 means no cut-off. ', ...
'Do "arts -d abslineshapeDefine" for further information.'
];
%-----------------------------------------------------------------------------
Q.ABS_LINESHAPE_FACTOR = {};
I.ABS_LINESHAPE_FACTOR = [ ...
'The line shape normalisation factor to apply. The same factor is used', ...
' for all tag groups. Shall be a string. ', ...
'Do "arts -d abs_lineshapeDefine" for valid options.'
];
%-----------------------------------------------------------------------------
Q.ABS_LOOKUP = {};
I.ABS_LOOKUP = [ ...
'Has the same functionality as the arts WSV with the same name.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.ABS_MODELS = {};
I.ABS_MODELS = [ ...
'Control files including descriptions of absorption models to ', ...
'use (called continua in arts). This shall be a series of calls of ', ...
'*abs_cont_descriptionAppend* (call of *abs_cont_descriptionInit* shall ',...
'be included).',...
'#   Given as an array of strings. The atmlab setting ARTS_INCLUDES is ',...
'recognised. A file containing standard choices is: ',...
'ARTS_INCLUDES/continua.arts'
];
%-----------------------------------------------------------------------------
Q.ABS_NLS = {};
I.ABS_NLS = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. Can be set by *qarts_abs_species*.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.ABS_NLS_PERT = {};
I.ABS_NLS_PERT = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text. Empty ([]) signifies no perturbations.'
];
%-----------------------------------------------------------------------------
Q.ABS_P = {};
I.ABS_P = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.ABS_SPECIES = {};
I.ABS_SPECIES = [ ...
'Specification of absorption species. Arts requires in many cases that ', ...
'H2O and N2 are included. ',... 
'This is a structure array defining species and associated retrieval ',...
'variables. These sub-fields are defined: ', ...
'# ',...
'#<TAG> Tag group data, following *arts_tgs_cnvrt*.', ...
'# ',...
'#<ATMDATA> VMR data for the species. The input shall follow the atmdata ',...
'format, defined in *isatmdata*. The data specified here are not directly ',...
'given to arts, it can only be used to set-up *VMR_FIELD*. This step is ',...
'handled by *qarts_vmr_field*. The field is accordingly not mandatory. ',...
'The main usage of this field should be to import data of climatology ',...
'character. Can be given as a variable or a file saved through *gf_save*. ',...
'This field is recognised and used automatically by Qpack2.',...
'# ',...
'#<RETRIEVE> If set to true the species is retrieved. Otherwise the ', ...
'species is not retrieved (what a surprise!).', ...
'# ',...
'#<UNIT> Retrieval unit. Allowed choices are ''rel'', ''vmr'', ''nd'', ', ...
'and ''logrel''. For some more information:',...
'#arts -d jacobianAddAbsSpecies.', ...
'# ',...
'#<GRIDS> Retrieval grids for the species. An array of vectors of length 3:',...
' {p_grid,lat_grid,lon_grid}. Grids for dimensions not used shall be ',...
'empty.',...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for the species. Size must ',...
'match the grid field. Data must match <UNIT>. A matrix, that can be ',...
'sparse.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved state for the species ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.',...
'# ',...
'#<L2_RANGE> Fine tuning of L2 data ranges. ',...
'The default is to store data directly matching the retrieval ',...
'grids. This is done if the field is non-existing. This ',...
'field allows you to either crop or extend range of the L2 data. ',...
'It is then a vector of length, at least, twice the atmospheric ',...
'dimensionality: [p_min p_max lat_min lat_max lon_min lon_max] where ',...
'lat_min gives the minimum latitude to include etc. ',...
'# If a given limit is inside the range covered by the corresponding ',...
'retrieval grid, this results in that the data are cropped. This ',...
'feature can be used to remove parts that are of no interest for ',...
'L2 data (such as parts always having a low measurement response). ',...
'# The default L2 output is not reflecting the fact that values at ',...
'end points of the retrieval grids are valid all the way to the ',...
'matching atmospheric limit. This field can also be used to ',...
'incorporate this part. If a limit is outside the retrieval grid, ',...
'the L2 data will also include the retrieved state at the ',...
'specified or the atmospheric limit (which is the closest to the ',...
'retrieval grid). In practice this signifies a duplication of end point ',...
'data.',...
'# Only retrieved profile and errors are modified. Averaging kernel, ',...
'covariance and gain matrices are kept consistent with the original ',...
'retrieval grids.'...
'# ',...
'#<MINMAX> Min and max allowed value for retrievals. A single min and ',...
'max value is applied for each species. The field can be left undefined, ',...
'be empty, be a scalar or vector of length 2. A single value as taken as ',...
'min, and is then set to Inf. The min value can be set to -Inf. The unit',...
'follows the field *UNIT*.',...
'# The primary usage of the field should be to avoid negative vmr values. ',...
'(The limits are applied also during the iterations of a non-linear inversion.'
];
%-----------------------------------------------------------------------------
Q.ABS_T = {};
I.ABS_T = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.ABS_T_PERT = {};
I.ABS_T_PERT = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.ABS_VMRS = {};
I.ABS_VMRS = [ ...
'As the arts WSV with the same name. Only needed if an absorption look-up ', ...
'shall be calculated. See *qarts_set_abs_lookup* for simple setting of ',...
'this field.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.ABS_WSMS = {};
I.ABS_WSMS = [ ...
'Workspace method calls to include just before calculation of absorption. ',...
'Format and options as WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.ABS_XSEC_AGENDA = {};
I.ABS_XSEC_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of ',...
'strings.',...
'#   If the field *ABSORPTION* is set, this agenda is set to its most ',...
'common choice. Accordingly, this field is only needed if your ',...
'calculations require a deviating agenda definition.'
];
%-----------------------------------------------------------------------------
Q.ABSORPTION = {};
I.ABSORPTION = [ ...
'String describing how absorption shall be calculated/obtained. ',...
'Existing options are:', ...
'#    {}        : Absorption variables defined by include files. All ',...
'absorption fields above will be ignored.',...    
'#   ''OnTheFly'' : Absorption is calculated for each propagation path ',...
'point. The agenda *abs_scalar_gas_agenda* must here be set by an include ',...
'file. No other absorption variables need to be set.',...
'#   ''CalcTable'': Calculate and use an absorption look-up table. See ',...
'*qarts_abstable* for simple setting of needed variables.',...
'#   ''LoadTable'': Load and use pre-calculated absorption look-up table, ',...
'defined by field *ABS_LOOKUP*.',...
'#If this field is set, *ABS_XSEC_AGENDA* and *PROPMAT_CLEARSKY_AGENDA* ',...
'are set matching calculations of standard type.'
];
%-----------------------------------------------------------------------------
Q.ANTENNA_DIM = {};
I.ANTENNA_DIM = [ ...
'As the arts WSV with the same name.', ...
'#   This field can be ignored, depending on SENSOR_RESPONSE.'
];
%-----------------------------------------------------------------------------
Q.ATMOSPHERE_DIM = {};
I.ATMOSPHERE_DIM = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.BATCH = {};
I.BATCH = [ ...
'Batch calculations. Defined by a structure, described in ',...
'*qartsBatch*. Type ''qinfo(@qartsBatch);'' for further information. ',...
'Batch calculations are not started automatically (in e.g. *arts_y*), but ',...
'must be selected specifically (most easily done by using *arts_batch*).' 
];
%-----------------------------------------------------------------------------
Q.BLACKBODY_RADIATION_AGENDA = {};
I.BLACKBODY_RADIATION_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.CLOUDBOX = {};
I.CLOUDBOX = [ ...
'Handling of cloudbox/scattering. Defined by a structure, described in ',...
'*qartsCloudbox*. Type ''qinfo(@qartsCloudbox);'' for further information.'
];
%-----------------------------------------------------------------------------
Q.CLOUDBOX_DO = {};
I.CLOUDBOX_DO = [ ...
'Boolean to activate the cloud box (scattering calculations), or not.',...
'#   {}: Nothing is done. Relevant data are assumed to be specified by ',...
'inclusion files.',...
'#    0: Call of *cloudboxOff* is included.',...
'#    1: Action follows setting of field *CLOUDBOX*.'
];
%-----------------------------------------------------------------------------
Q.F_GRID = {};
I.F_GRID = [ ...
'Has the same functionality as the arts WSV with the same name.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.FSHIFTFIT = {};
I.FSHIFTFIT = [ ...
'Structure for specification of frequency shift retrievals. No retrieval',...
'is made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddFreqShift*. The polynomial order is hard-coded to ',...
'zero. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate frequency retrieval.', ...    
'# ',...
'#<DF> Size for numerical perturbation.', ...
'# ',...
'#<SX> Variance of a priori knowledge on the variable.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved frequency fit variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.FSTRETCHFIT = {};
I.FSTRETCHFIT = [ ...
'Structure for specification of frequency stretch retrievals. No retrieval ',...
'is made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddFreqStretch*. The polynomial order is hard-coded to ',...
'zero. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate frequency retrieval.', ...    
'# ',...
'#<DF> Size for numerical perturbation.', ...
'# ',...
'#<SX> Variance of a priori knowledge on the variable.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved frequency fit variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.HSE = {};
I.HSE = [ ...
'Variables associated with hydrostatic equilibrium. A structure with the ',...
'sub-fields:',...
'# ',...
'#<ON> Flag to enforce hydrostatic equilibrium. If true, the WSV *z_field*',... 
'is recalculated by *z_fieldFromHSE* (note that a "first guess" *z_field* ',... 
'must be provided).',...
'# ',...
'#<P> Pressure for reference point. Matches the WSV *p_hse*.',...
'# ',...
'#<ACCURACY> Calculation accuracy. Matches the WSV *z_hse_accuracy*.',...
'# ',...
'#If the field is unset, no action is taken. This equals to set Q.HSE.ON ',...
'to false. Note the setting Q.T.HSE which controls the calculation of t-',...
'jacobians. The two settings are treated as independent, but should ',...
'be set to the same value (true/false). If the HSE is maintained during ',...
'the iterations of a temperature retrieval is controlled by THIS field.'
];    
%-----------------------------------------------------------------------------
Q.INCLUDES = {};
I.INCLUDES = [ ...
'Paths to control files to be included. These files will be included ',...
'at the top of the control file, only preceded by WSMS_AT_START. Given ',...
'as an array of strings. Format and options as for WSMS_AT_START.',...
'#   The atmlab setting ARTS_INCLUDES is recognised. To include the ',...
'standard arts general definition file, select:',...
'{''ARTS_INCLUDES/general.arts''}'
];
%-----------------------------------------------------------------------------
Q.INPUT_FILE_FORMAT = 'binary';
I.INPUT_FILE_FORMAT = [ ...
'The file format for arts input files. That is, the format of the files ',...
'created in Matlab to be read by arts. Possible options are ''binary'', '...
'and ''double''. The binary option, that is default, should be most '...
'efficient. Use ''double'' if you want to visually inspect the files ',...
'generated. (The option ''float'' is not allowed, as this is not always '...
'sufficient for frequency data.)'
];
%-----------------------------------------------------------------------------
Q.IY_AUX_VARS = {};
I.IY_AUX_VARS = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.IY_MAIN_AGENDA = {};
I.IY_MAIN_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.IY_SPACE_AGENDA = {};
I.IY_SPACE_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'

];
%-----------------------------------------------------------------------------
Q.IY_SUB_AGENDA = {};
I.IY_SUB_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.IY_SURFACE_AGENDA = {};
I.IY_SURFACE_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.IY_TRANSMITTER_AGENDA = {};
I.IY_TRANSMITTER_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.IY_UNIT = {};
I.IY_UNIT = [ ...
'As the arts WSV with the same name. That is, the radiance unit. ',...
'The options include:', ...
'#   ''1''       : Basic radiances [W/m2/Hz/sr]',...
'#   ''RJBT''    : Conversion to brightness temperature by the Rayleigh-',...
'Jeans approximation of the Planck function.',...
'#   ''PlanckBT'': Conversion to brightness temperature by the Planck ',...
    'function.',...
'#For further information: ''arts -d iy_unit''.'
];
%-----------------------------------------------------------------------------
Q.J_DO = {};
I.J_DO = [ ...
'Boolean to include calculation of jacobians.',...
'#   {}: Nothing is done. Relevant data are assumed to be specified by ',...
'inclusion files.',...
'#    0: Call of *jacobianOff* is included.',...
'#    1: Action follows setting of field *J*.'
];
%-----------------------------------------------------------------------------
Q.LAT_GRID = {};
I.LAT_GRID = [ ...
'As the arts WSV with the same name. For example, shall be empty for 1D ', ...
'simulations.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.LAT_TRUE = {};
I.LAT_TRUE = [ ...
'As the arts WSV with the same name.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.LON_GRID = {};
I.LON_GRID = [ ...
'As the arts WSV with the same name. For example, shall be empty for 1D ', ...
'and 2D simulations.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.LON_TRUE = {};
I.LON_TRUE = [ ...
'As the arts WSV with the same name.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.L2_EXTRA = {};
I.L2_EXTRA = [ ...
'Information to functions repacking retrieval information. Such a product ', ...
'is normally denoted as L2 data. This field lists data to be included ', ...
'beside the direct retrieval quantities, for which their L2 field has ',...
'the same functionality. The information is given as string array, e.g.:',...
'#    Q.L2_EXTRA = {''cost'',''mresp'',''ptz''}',...
'#There is no general L2 function and the possible data output (and ',...
'coding) differs between the functions.'
];
%-----------------------------------------------------------------------------
Q.MAG_U_FIELD = {};
I.MAG_U_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.MAG_U = {};
I.MAG_U = [ ...
'Data and settings associated with MAG_U_FIELD. Has the same role as T with ',...
'respect to T_FIELD, but as there are no retrievals associated with MAG_U ',...
'there is only one sub-field here:',...
'# ',...
'#<ATMDATA> The input shall follow the atmdata format, defined in ',...
'*isatmdata*. The data specified here are not directly given to arts, it ',...
'can only be used to set-up *MAG_U_FIELD*. This step is handled by ',...
'*qarts_atm_field*. The main usage of this field should be to import ',...
'data of climatology character. Can be given as a variable or a file saved ',...
'through *gf_save*. ',...
'This field is recognised and used automatically by Qpack2.',...
];
%-----------------------------------------------------------------------------
Q.MAG_V_FIELD = {};
I.MAG_V_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.MAG_V = {};
I.MAG_V = [ ...
'Data and settings associated with the v-component of the magnetic field. ',...
'Defined as MAG_U, and the details are nor repeated here.'
];
%-----------------------------------------------------------------------------
Q.MAG_W_FIELD = {};
I.MAG_W_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.MAG_W = {};
I.MAG_W = [ ...
'Data and settings associated with the w-component of the magnetic field. ',...
'Defined as MAG_U, and the details are nor repeated here.'
];
%-----------------------------------------------------------------------------
Q.MBLOCK_AA_GRID = {};
I.MBLOCK_AA_GRID = [ ...
'Has the same functionality as the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   If the antenna dimension is 1, this variable can be left as {}. ', ...
'For 2D antennas it has to be set even if the sensor does not include an ', ...
'antenna.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.MBLOCK_ZA_GRID = {};
I.MBLOCK_ZA_GRID = [ ...
'Has the same functionality as the arts WSV with the same name. ', ...
'This has to be set even if the sensor does not include an antenna.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.OUTPUT_FILE_FORMAT = {};
I.OUTPUT_FILE_FORMAT = [ ...
'As the arts WSV with the same name. That is, the format for files created ',...
'by arts. Possible options are ''binary'' and ''ascii''. The binary option ',...
'should in general be most efficient.'
];
%-----------------------------------------------------------------------------
Q.P_GRID = {};
I.P_GRID = [ ...
'Has the same functionality as the arts WSV with the same name.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.POINTING = {};
I.POINTING = [ ...
'Structure for specification of pointing fit retrievals. No retrieval is', ...
'made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddPointingZa*. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate pointing retrieval.', ...    
'# ',...
'#<DZA> Size for numerical perturbation. See used WSM.', ...
'# ',...
'#<POLY_ORDER> Order of polynomial to describe the time variation of ',...
'pointing errors.', ...
'# ',...
'#<CALCMODE> The manner in which the jacobian is determined. See  used WSM',...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for pointing fit variables. ',...
'A square matrix of size POLY_ORDER+1.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved pointing variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.POLYFIT = {};
I.POLYFIT = [ ...
'Structure for specification of polynomial baseline fits. No retrieval is', ...
'made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddPolyfit*. All no_xxx_variation arguments of the WSM ',...
'are set to default value. The different polynomial coefficients are ',...
'assumed to be uncorrelated. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate pointing retrieval', ...    
'# ',...
'#<ORDER> Order of polynomial fit.', ...
'# ',...
'#<SX0> Covariance matrix of a priori knowledge for coefficient of order ',...
'zero. There shall be such a matrix for each coefficient order until:',...
'# ',...
'#<SXn> Covariance matrix of a priori knowledge for coefficient of order ',...
'POLY_ORDER. The last required covariance matrix.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved baseline variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.PPATH_AGENDA = {};
I.PPATH_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.PPATH_LMAX = {};
I.PPATH_LMAX = [ ...
'As the arts WSV with the same name .', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.PPATH_LRAYTRACE = {};
I.PPATH_LRAYTRACE = [ ...
'As the arts WSV with the same name .', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.PPATH_STEP_AGENDA = {};
I.PPATH_STEP_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.PROPMAT_CLEARSKY_AGENDA = {};
I.PROPMAT_CLEARSKY_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of ',...
'strings.',...
'#   If the field *ABSORPTION* is set, this agenda is set to its most ',...
'common choice (for the selected ABSORPTION option). Accordingly, this ',...
'field is only needed if your calculations require a deviating agenda ',...
'definition.'
];
%-----------------------------------------------------------------------------
Q.RAW_ATMOSPHERE = {};
I.RAW_ATMOSPHERE = [ ...
'If set, a "raw atmosphere" in read. This is the main file name for the ',...
'raw atmosphere. See further ''arts -d AtmRawRead''.',...
'#Data in the fields T_FIELD, Z_FIELD or VMR_FIELD are included at a later ',...
'stage and will then overwrite the data from the raw atmosphere. This ',...
'gives thus some flexibility to mix data from different sources.'
];
%-----------------------------------------------------------------------------
Q.RAW_ATM_EXPAND_1D = {};
I.RAW_ATM_EXPAND_1D = [ ...
'Boolean to expand an 1D raw atmosphere to set ATMOSPHERE_DIM. If set to ',...
'1, the WSM *AtmFieldsCalcExpand1D* is used instead of *AtmFieldsCalc*.',...
'This variable is only used if RAW_ATMOSPHERE is set.'
];
%-----------------------------------------------------------------------------
Q.REFELLIPSOID = {};
I.REFELLIPSOID = [ ...
'Reference ellipsoid. As the arts WSV with the same name .'
];
%-----------------------------------------------------------------------------
Q.REFR_INDEX_AIR_AGENDA = {};
I.REFR_INDEX_AIR_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_DO = {};
I.SENSOR_DO = [ ...
'Boolean to include sensor characteristics. Otherwise monochromatic pencil ',...
'beam calculations are performed. *SENSOR_POS/LOS* are used in both cases. ',...
'#   {}: Nothing is done. Relevant data are assumed to be specified by ',...
'inclusion files.',...
'#    0: Call of *sensorOff* is included.',...
'#    1: Action follows setting of field *SENSOR_RESPONSE*.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_LOS = {};
I.SENSOR_LOS = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_POS = {};
I.SENSOR_POS = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE = {};
I.SENSOR_RESPONSE = [ ...
'As the arts WSV with the same name. Three main options exist:', ...
'#1: The first option is to specify each variable associated with the ',...
'sensor individually. This field can then be the name of a XML file or ',...
'a Matlab sparse matrix. Other fields that must be specified for this ',...
'option include: ANTENNA_DIM, MBLOCK_ZA/AA_GRID and ',...
'SENSOR_RESPONSE_F/ZA/AA/POL.',...
'#2: The name of control files to include (ARTS_INCLUDES recognised). ',...
'Given as an array of strings.',...
'#3: Calculate the response from basic data. This field shall then be a ',...
'structure, following the definitions in *qartsSensor*. Type ',...
'''qinfo(@qartsSensor);'' for definition of required data fields.',...
'Other fields that must/may be specified here include ANTENNA_DIM and ',...
'MBLOCK_ZA/AA_GRID.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_AA = {};
I.SENSOR_RESPONSE_AA = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_AA_GRID = {};
I.SENSOR_RESPONSE_AA_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_F = {};
I.SENSOR_RESPONSE_F = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_F_GRID = {};
I.SENSOR_RESPONSE_F_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_POL = {};
I.SENSOR_RESPONSE_POL = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_POL_GRID = {};
I.SENSOR_RESPONSE_POL_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_ZA = {};
I.SENSOR_RESPONSE_ZA = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_RESPONSE_ZA_GRID = {};
I.SENSOR_RESPONSE_ZA_GRID = [ ...
'As the arts WSV with the same name. ', ...
'This field can be ignored, depending on setting of SENSOR_RESPONSE.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.SENSOR_TIME = {};
I.SENSOR_TIME = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SINEFIT = {};
I.SINEFIT = [ ...
'Structure for specification of sinusoidal baseline fits. No retrieval is', ...
'made if field is empty or sub-field RETRIEVAL is set to false. The WSM ',...
'used is *jacobianAddSinefit*. All no_xxx_variation arguments of the WSM ',...
'are set to default value. The different period lengths are assumed ',...
'to be uncorrelated. These sub-fields are defined:',...
'# ',...
'#<RETRIEVE> Flag to activate retrieval', ...    
'# ',...
'#<PERIODS> Period lengths of the fit.', ...
'# ',...
'#<SX1> Covariance matrix of a priori knowledge for coefficients of first ',...
'period length. This is applied as the covariance for both the sine and ',...
'cosine term, assuming that the two terms are uncorrelated. That is, for ',...
'single spectra retrievals, SX1 is a scalar, giving the variance for both ',...
'a and b, where the baseline is modelled as a*sin(...)+b*cos(...). ',...
'There shall be such a matrix for each period length until:',...
'# ',...
'#<SXn> Covariance matrix of a priori knowledge for last period length. ',...
'The last required covariance matrix.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved baseline variables ',...
'will be included in the L2 output. Otherwise not. This field has no ',...
'importance if RETRIEVE is false.'
];
%-----------------------------------------------------------------------------
Q.STOKES_DIM = {};
I.STOKES_DIM = [ ...
'As the arts WSV with the same name.'
];
%-----------------------------------------------------------------------------
Q.SURFACE_RTPROP_AGENDA = {};
I.SURFACE_RTPROP_AGENDA = [ ...
'As the arts WSV with the same name. WSMs are listed as an array of strings.'
];
%-----------------------------------------------------------------------------
Q.T = {};
I.T = [ ...
'Data and setting associated with atmospheric temperatures. Normally used ',...
'when retrieving temperature. Otherwise, *T_FIELD* can be set directly.',...
'# ',...
'#<ATMDATA> The input shall follow the atmdata format, defined in ',...
'*isatmdata*. The data specified here are not directly given to arts, it ',...
'can only be used to set-up *T_FIELD*. This step is handled by ',...
'*qarts_atm_field*. The main usage of this field should be to import ',...
'data of climatology character. Can be given as a variable or a file saved ',...
'through *gf_save*. ',...
'This field is recognised and used automatically by Qpack2.',...
'# ',...
'#<RETRIEVE> If set to true, atmospheric temperatures are retrieved.', ...
'# ',...
'#<GRIDS> Retrieval grids for temperature. An array of vectors of length 3:',...
' {p_grid,lat_grid,lon_grid}. Grids for dimensions not used shall be ',...
'empty.',...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for temperature. Size must ',...
'match the grid field. Data must match <UNIT>. A matrix, that can be ',...
'sparse.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved state for temperature ',...
'will be included in the L2 output. Otherwise not.',...
'# ',...
'#<L2_RANGE>  As the same field for ABS_SPECIES.',...
'# ',...
'#<MINMAX> Min and max allowed value for retrievals. Works exactly as ',...
'for ABS_SPECIES.',...
'# ',...
'#<HSE> As the argument to *jacobianAddTemperature* with same name. ',...
'Default here is "on". This refers only to the actual jacobian calculation.',...
' If the atmosphere itself fulfils HSE or not is controlled by Q.HSE.',...
'# ',...
'#<METHOD> As the argument to *jacobianAddTemperature* with same name. ',...
'Default here is "analytical".',...
'# ',...
'#<DT> As the argument to *jacobianAddTemperature* with same name. ',...
'Default here is 1 K.',...
'# ',...
'#None of the fields are mandatory for pure forward calculations. If ',...
'RETRIEVAL is set to false, the other retrieval related fields are ignored.'
];  
%-----------------------------------------------------------------------------
Q.T_FIELD = {};
I.T_FIELD = [ ...
'As the arts WSV with the same name. Will replace temperature data inserted',...
' through RAW_ATMOSPHERE.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.TNOISE_C = {};
I.TNOISE_C = [ ...
'Thermal noise correlation. A matrix (sparse preferably) giving the ', ...
'correlation of thermal noise between channels. Hence, the diagonal ',...
'elements shall all be one. If the thermal noise is the same for all ',...
'channels and has a standard deviation of s, the covariance matrix is ',...
's*s*TNOISE_C.'
];
%-----------------------------------------------------------------------------
Q.TRANSMITTER_POS = {};
I.TRANSMITTER_POS = [ ...
'As the arts WSV with the same name.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.VMR_NEGATIVE_OK = {};
I.VMR_NEGATIVE_OK = [ ...
'Corresponds directly to the argument *negative_vmr_ok* of ',...
'*atmfields_checkedCalc*. Default is false, and only needed if you want ',...
'to the flag to true.'
];
%-----------------------------------------------------------------------------
Q.VMR_FIELD = {};
I.VMR_FIELD = [ ...
'As the arts WSV with the same name. Will replace VMR data inserted ',...
'through RAW_ATMOSPHERE.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.',...
'#   For retrievals, the a priori state for *ABS_SPECIES* is determined ',...
'by this field.'
];
%-----------------------------------------------------------------------------
Q.WIND_U = {};
I.WIND_U = [ ...
'Data and settings associated with the u-component of winds. Normally used ',...
'when retrieving winds. Otherwise, *WIND_U_FIELD* can be set directly.',...
'# ',...
'#<ATMDATA> The input shall follow the atmdata format, defined in ',...
'*isatmdata*. The data specified here are not directly given to arts, it ',...
'can only be used to set-up *WIND_U_FIELD*. This step is handled by ',...
'*qarts_atm_field*. The main usage of this field should be to import ',...
'data of climatology character. Can be given as a variable or a file saved ',...
'through *gf_save*. ',...
'This field is recognised and used automatically by Qpack2.',...
'# ',...
'#<RETRIEVE> If set to true, this atmospheric wind is retrieved.', ...
'# ',...
'#<GRIDS> Retrieval grids for the wind. An array of vectors of length 3:',...
' {p_grid,lat_grid,lon_grid}. Grids for dimensions not used shall be ',...
'empty.',...
'# ',...
'#<SX> Covariance matrix of a priori knowledge for temperature. Size must ',...
'match the grid field. Data must match <UNIT>. A matrix, that can be ',...
'sparse.',...
'# ',...
'#<L2> Flag for any function creating L2 data. See comments for ',...
'*L2_EXTRA*. If set to true, the retrieved state for this wind component ',...
'will be included in the L2 output. Otherwise not.',...
'# ',...
'#<L2_RANGE>  As the same field for ABS_SPECIES.',...
'# ',...
'#None of the fields are mandatory for pure forward calculations. If ',...
'RETRIEVAL is set to false, the other retrieval related fields are ignored.'
];  
%-----------------------------------------------------------------------------
Q.WIND_U_FIELD = {};
I.WIND_U_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.WIND_V = {};
I.WIND_V = [ ...
'Data and settings associated with the v-component of winds. Defined ',...
'as WIND_U, and the details are nor repeated here.'
];
%-----------------------------------------------------------------------------
Q.WIND_V_FIELD = {};
I.WIND_V_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.WIND_W = {};
I.WIND_W = [ ...
'Data and settings associated with the w-component of winds. Defined ',...
'as WIND_U, and the details are nor repeated here.'
];
%-----------------------------------------------------------------------------
Q.WIND_W_FIELD = {};
I.WIND_W_FIELD = [ ...
'As the arts WSV with the same name. Can be set to [].', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.WSMS_AT_END = {};
I.WSMS_AT_END = [ ...
'Workspace method calls to include at the far end of the control file. ',...
'Format and options as for WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.WSMS_AT_START = {};
I.WSMS_AT_START = [ ...
'Workspace method calls to include at the top of the control file. These ',...
'calls are only preceded by possible settings set by INCLUDES.',...
'# Method calls are specified as an cell array of strings. For example, if ',...
'no inclusion files are used, these calls could be useful to include',...
'#   { ''VectorSet(abs_n2,[0.7808])'', ''abs_cont_descriptionInit'' }',...
'#A simple if/else/end feature is supported, with the format shown below. ',...
'The argument to the if-statement must be a field of Q that is a boolean. ',...
'Nested if-statements are not allowed. An example:',...
'#   <IF> J_DO',...
'#    (something)',...
'#   <ELSE>',...
'#    (something else)',...
'#   <END>',...
'#That is, <IF>, <ELSE> and <END> are used as identifiers. The identifiers ',...
'must start the line. For <ELSE> and <END>, the rest of the line must be ',...
'empty.'
];
%-----------------------------------------------------------------------------
Q.WSMS_BEFORE_ATMSURF = {};
I.WSMS_BEFORE_ATMSURF = [ ...
'Workspace method calls to include just before setting up the atmosphere ',...
'and the surface. That is, before consider e.g. Q.P_GRID, Q.T_FIELD, ',...
'Q.Z_SURFACE. Format and options as for WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.WSMS_BEFORE_RTE = {};
I.WSMS_BEFORE_RTE = [ ...
'Workspace method calls to include just before execution of *YCALC_WSMS* ',...
'or batch core part. Accordingly, this field is considered only if ',...
'spectra are calculated (ignored for e.g. pure absorption calculations). ',...
'Format and options as for WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.YCALC_WSMS = {};
I.YCALC_WSMS = [ ...
'Workspace method calls for performing radiative transfer calculations. ',...
'The standard choice should be that this fields includes a call of *yCalc*.',... 
' There is no clear division between this field and *WSMS_BEFORE_RTE*, but ',...
'for best flexibility this field should start with *yCalc* (or corresponding',...
' method), followed by post-processing not handled by other fields.',...
'#   Accordingly, this field is considered only if spectra are calculated ',...
'(ignored for e.g. pure absorption calculations). Format and options as ',...
'for WSMS_AT_START.'
];
%-----------------------------------------------------------------------------
Q.Z = {};
I.Z = [ ...
'Data and settings associated with Z_FIELD. Has the same role as T with ',...
'respect to T_FIELD, but as there are no retrievals associated with Z ',...
'there is only one sub-field here:',...
'# ',...
'#<ATMDATA> The input shall follow the atmdata format, defined in ',...
'*isatmdata*. The data specified here are not directly given to arts, it ',...
'can only be used to set-up *Z_FIELD*. This step is handled by ',...
'*qarts_atm_field*. The main usage of this field should be to import ',...
'data of climatology character. Can be given as a variable or a file saved ',...
'through *gf_save*. ',...
'This field is recognised and used automatically by Qpack2.',...
];
%-----------------------------------------------------------------------------
Q.Z_FIELD = {};
I.Z_FIELD = [ ...
'As the arts WSV with the same name. Will replace altitude data inserted ',...
'through RAW_ATMOSPHERE.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
Q.Z_SURFACE = {};
I.Z_SURFACE = [ ...
'Surface altitude (above reference ellipsoid). As the arts WSV with the ',...
'same name.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
