function [gmtStructureElements,gmtStructStructElements] = gmt_inputs
%% gmt_inputs
%  Purpose: A list of all the inputs and their types to gmt_plot
%
% OUT
%     cells: {@fhandle to chech the input,'stringname of field'}
%
% NOTE (to editor):
%    Make sure that new variables are added to these lists!
% $Id: gmt_inputs.m 8548 2013-07-23 21:27:59Z seliasson $
% Created by Salomon Eliasson

gmtStructureElements    = {...
    @(x)(ischar(x)||isscalar(x))    ,'annot_font_size_primary';...
    @ischar                         ,'basemap_axis'         ;...
    @isscalar                       ,'center'               ;...
    @ischar                         ,'cptfile'              ;...
    @ischar                         ,'ctable'               ;...
    @(x)(isstruct(x)||(islogical(x) || (isscalar(x) && x<2))) ,'coast'                ;...
    @ischar                         ,'color_background'     ;...
    @ischar                         ,'color_foreground'     ;...
    @ischar                         ,'color_nan'            ;...
    @isvector                       ,'datarange'            ;...
    @(x)(islogical(x) || (isscalar(x) && x<2)),'display'    ;...
    @(x)isstruct(x)||(islogical(x) || (isscalar(x) && x<2))  ,'extra_legend'         ;...
    @ischar                         ,'filename'             ;...
    @ischar                         ,'figuretype'           ;...
    @ischar                         ,'grdimage'             ;...
    @ischar                         ,'grdcontour'           ;...
    @iscellstr                      ,'gmtset'               ;...
    @ischar                         ,'header'               ;...
    @(x)(ischar(x)||isscalar(x))    ,'header_font'          ;...
    @(x)(ischar(x)||isscalar(x))    ,'header_fontsize'      ;...
    @ischar                         ,'header_offset'        ;...
    @(x)islogical(x)||(isscalar(x)&&x<2),'keep_files'       ;...
    @(x)isstruct(x)||islogical(x)||(isscalar(x)&&x<2),'legend';...
    @isstruct                       ,'locations'            ;...
    @(x)(ischar(x)||isscalar(x))    ,'map_width'            ;...
    @ischar                         ,'makecpt'              ;...
    @ischar                         ,'measure_unit'         ;...
    @(x)islogical(x)||(isscalar(x)&&x<2),'nanlegend'        ;...
    @(x)isstruct(x)||ischar(x)      ,'nearneighbor'         ;...
    @(x)islogical(x)||(isscalar(x) && x<2),'nodata'         ;...
    @isscalar                       ,'nlevels'              ;...
    @ischar                         ,'outdir'               ;...
    @ischar                         ,'plotPlacement'        ;...
    @ischar                         ,'projection'           ;...
    @ischar                         ,'proj'                 ;...
    @ischar                         ,'pscoast'              ;...
    @iscell                         ,'pspoly'               ;...
    @iscell                         ,'pspolycolor'          ;...
    @iscell                         ,'pspolythick'          ;...
    @ischar                         ,'pscale'               ;...
    @ischar                         ,'pscale_extra'         ;...
    @(x)isstruct(x)||ischar(x)      ,'pstext'               ;...
    @ischar                         ,'region'               ;...
    @(x)islogical(x)||(isscalar(x)&&x<=2),'savelegend'      ;...
    @isscalar                       ,'stepsize'             ;...
    @ischar                         ,'ticks'                ;...
    @isvector                       ,'tickval'              ;...
    @ischar                         ,'unit'                 ;...
    @ischar                         ,'xunit'                ;...
    };

gmtStructStructElements = struct(...
'coast',{{...
    @isscalar			,'features'             ;...
    @ischar				,'resolution'           ;...
    @ischar				,'rivers'               ;...
    @isscalar			,'width'                ;...
    @ischar				,'color'                }},...
'colorrange',{{...
    @iscell				,'colors'               ;...
    @ischar				,'color_model'          }},...
'contourline',{{...
    @isscalar			,'spacing'              ;...
    @isvector			,'range'                ;...
    @isscalar			,'linethick'            ;...
    @ischar				,'more'                 }},...
'extra_legend',{{...
    @ischar             ,'name'                 ;...
    @ischar             ,'type'                 ;...
    @ischar             ,'position'             ;...
    @(x)(ischar(x)||isscalar(x)),'fontsize'     ;...    
    }},...
'legend',{{...
    
    @isscalar                   ,'box_spacing'              ;...
    @(x)islogical(x)||(isscalar(x)&&x<2),'equalboxwidth';...
    @(x)(ischar(x)||isscalar(x)),'font_size'                ;...
    @(x)(ischar(x)||isscalar(x)),'length'                   ;...
    @ischar                     ,'orientation'              ;...
    @ischar                     ,'position'                 ;...
    @ischar                     ,'position_nan'             ;...
    @ischar                     ,'shift_tick_annotations'   ;...
    @isscalar                   ,'sidebar'                  ;...
    @iscellstr                  ,'tick_annotations'         ;...
    @ischar                     ,'tick_annotation_format'   ;...
    @(x)islogical(x)||(isscalar(x) && x<2),'tick_centering' ;...
    @(x)(ischar(x)||isscalar(x)),'tick_length'              ;...
    @isscalar                   ,'tick_spacing'             ;...
    @(x)(ischar(x)||isscalar(x)),'width'                    ;...
    @(x)(ischar(x)||isscalar(x)),'xpos'                     ;...
    @(x)(ischar(x)||isscalar(x)),'ypos'                     }},...
'locations',{{...
    @isscalar  			,'lat'                  ;...
    @isscalar			,'lon'                  ;...
    @ischar				,'name'                 ;...
    @ischar				,'shape'                ;...
    @isscalar			,'size'                 ;...
    @ischar				,'color'                ;...
    @isscalar			,'textsize'             ;...
    @ischar				,'textcolor'            ;...
    @ischar             ,'textalign'            }},...
'nearneighbor',{{...
    @ischar				,'search'               ;...
    @isscalar			,'resolution'           }},...
'psbox',{{...
    @isvector			,'box'                  ;...
    @isvector			,'boxes'                ;...
    @iscell				,'boxcolor'             ;...
    @iscell				,'boxthick'             }},...
'pstext',{{...
    @ischar			    ,'text'                 ;...
    @isscalar			,'lat'                  ;...
    @isscalar			,'lon'                  ;...
    @ischar				,'color'                ;...
    @isscalar           ,'fontnum'              ;...
    @isscalar			,'justify'              ;...
    @isscalar			,'angle'                ;...    
    @isscalar			,'thick'                }});
