% HOSTNAME   Returns name of computer
%
% FORMAT   hname = hostname
%        
% OUT   hname   String with computer name.

% 2005-02-15   Created by Patrick Eriksson.


function hname = hostname

persistent hp;

if isempty(hp)

  [st,hname] = system( 'hostname -s' );

  %- Remove any newline character
  %
  if hname(end) == sprintf('\n')
    hname = hname(1:end-1);
  end
  
  hp = hname;

else
  hname = hp;
end