% QARTSSENSOR   Defines setting fields for ARTS sensor response calculations
%
%    The function provides a description of each field.
%
%    This function is organised in such way that *qcheck* and *qinfo*
%    can be used.
%
% FORMAT   [H,I] = qartsSensor
%        
% OUT   H  Setting structure with default values for all recognised fields.
%       I  Includes same fields as H, where the content of each field
%          is a description string (used by *qinfo*).

% 2005-01-26   Created by Mattias Ekström.


function [H,I] = qartsSensor
 
%-----------------------------------------------------------------------------
H.ANTENNA_DO = {};
I.ANTENNA_DO = [ ...
'Flag to include call of *sensor_responseAntenna* even if not a single ',...
'antenna variable of *qartsSensor* is set.'
];
%-----------------------------------------------------------------------------
H.ANTENNA_DLOS = {};
I.ANTENNA_DLOS = [ ...
'As the ARTS WSV with the same name.', ...
' If the sensor response does not include an antenna this field can', ...
' be left as {}. If set, call of *sensor_responseAntenna* is added.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.ANTENNA_OPTION2D = {};
I.ANTENNA_OPTION2D = [ ...
'Matches the GIN *option_2d* of sensor_responseAntenna. Must be given as ', ...
'a string.', ...
'#   Can be left undefined for 1D antenna patterns.'
];
%-----------------------------------------------------------------------------
H.ANTENNA_RESPONSE = {};
I.ANTENNA_RESPONSE = [ ...
'Has the same functionality as the ARTS WSV with the same name.', ...
' If the sensor response does not include an antenna this field can', ...
' be left as {}.  If set, call of *sensor_responseAntenna* is added.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.BACKEND_DO = {};
I.BACKEND_DO = [ ...
'Flag to include call of *sensor_responseBackend* even if not a single ',...
'backend variable of *qartsSensor* is set.'
];
%-----------------------------------------------------------------------------
H.BACKEND_CHANNEL_RESPONSE = {};
I.BACKEND_CHANNEL_RESPONSE = [ ...
'Has the same functionality as the ARTS WSV with the same name.', ...
' If the sensor response does not include the backend, this variable', ...
' can be left as {}. If set, call of *sensor_responseBackend * or ', ...
'*sensor_responseMultiMixerBackend* is added. ', ...
'#   Can be given either as the name of a XML file, or as a Matlab',...
' variable.'
];
%-----------------------------------------------------------------------------
H.BEAM_SWITCHING = {};
I.BEAM_SWITCHING = [ ...
'Flag to trigger call of *sensor_responseBeamSwitching*.'
];
%-----------------------------------------------------------------------------
H.F_BACKEND = {};
I.F_BACKEND = [ ...
'Matches the ARTS WSV with the same name or *f_backend_multi*.', ...
' If the sensor response does not include the backend, this variable', ...
' can be left as {}. If set, call of *sensor_responseBackend * or ', ...
'*sensor_responseMultiMixerBackend* is added. ', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.F_SWITCHING = {};
I.F_SWITCHING = [ ...
'Size of frequency switching. If this field is set ',...
'*sensor_responseBackendFrequencySwitching* is used instead of ', ...
'*sensor_responseBackend*.', ...
'# If set, this field must be a vector of length 2, where the first ',...
'values is the frequency throw for the cycle with negative weight and the ',...
'second value is the throw for the other measurement cycle.'
];
%-----------------------------------------------------------------------------
H.FILL_FGRID = {};
I.FILL_FGRID = [ ...
'If field is set, *sensor_responseFillFgrid* is used. In short, this ',...
'activates a polynomial interpolation of the spectra to a finer grid. This ',...
'in order to decrease the impact of that the sensor response methods treat ', ...
'the spectra to be piecewise linear functions. This grid filling can improve ',...
'considerable the calculation accaracy for a given length of *f_grid. But ',...
'negative effects can happen for unlucky choices of grid.',...
'# If set, this field must be a vector of length 2, where the first ',...
'values is polynomial order for the interpolation, and the second is the ',...
'number of points to insert in each gap of *f_grid*. See further ',...
'*sensor_responseFillFgrid*.'
];
%-----------------------------------------------------------------------------
H.IF2RF = {};
I.IF2RF = [ ...
'If set to true, a call of *sensor_responseIF2RF* is made. This call is ',...
'placed between the mixer and backend parts.'
];
%-----------------------------------------------------------------------------
H.INSTRUMENT_POL = {};
I.INSTRUMENT_POL = [ ...
'Has the same functionality as the ARTS WSV with the same name. If set, ', ...
'*sensor_responsePolarisation* is called as first step in setting up the ', ...
'sensor response matrix.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.LO = {};
I.LO = [ ...
'Matches the ARTS WSV with the same name or *lo_multi*.', ...
' If the sensor response does not include the mixer, this variable', ...
' can be left as {}. If set, call of *sensor_responseBackend * or ', ...
'*sensor_responseMultiMixerBackend* is added. ', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.MIXER_DO = {};
I.MIXER_DO = [ ...
'Flag to include call of *sensor_responseMixer* even if not a single ',...
'backend variable of *qartsSensor* is set.'
];
%-----------------------------------------------------------------------------
H.SENSOR_NORM = {};
I.SENSOR_NORM = [ ...
'As the ARTS WSV with the same name.'
];
%-----------------------------------------------------------------------------
H.SIDEBAND_MODE = {};
I.SIDEBAND_MODE = [ ...
'Matches the ARTS WSV with the same name or *sideband_mode_multi*.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.SIDEBAND_RESPONSE = {};
I.SIDEBAND_RESPONSE = [ ...
'Matches the ARTS WSV with the same name or *sideband_response_multi*. ', ...
'If the sensor response does not include a mixer and sideband filter, ', ...
'this variable can be left as {}. If set, call of *sensor_responseMixer*',...
' or *sensor_responseMultiMixerBackend* is added.', ...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
H.STOKES_ROTATION = {};
I.STOKES_ROTATION = [ ...
'Has the same functionality as the ARTS WSV with the same name. ', ...
'If the sensor response does not include rotation, this variable ', ...
'can be left as {}. Setting this field triggers that a call of the WSM ', ...
'*sensor_responseStokesRotation* is included.',...
'#   Can be given either as the name of a file, as a matching Matlab ',...
'variable or control file text.'
];
%-----------------------------------------------------------------------------
