function command = grdimage(in)
% GRDIMAGE appends options to GMT grdimage
%
% purpose: Appends options to a short script and calls the GMT
%
% IN
%       cptfile   %s              .cpt-file used for grdimage from makecpt.m
%
% OUT   command   %s              string command to be used in system call
%
% Created by Salomon Eliasson
% $Id: grdimage.m 9860 2016-05-27 10:33:54Z seliasson $

grdimage = 'gmt grdimage';

%location of file, region and projection
grdimage = sprintf('%s %s -R -J -X -Y',grdimage,in.grdfile);

% The default bicubic interpolation introduces artifacts. 
% Nearneighbor to nearest point causes problems for high density data. 

% The following is supposed to be the default, but some projections fail in
% certain circumstances if the following is omitted
grdimage = sprintf('%s -nb+t0.5',grdimage);

% selects Overlay plot mode and assuming more pscode will be appended
grdimage = sprintf('%s -O -K',grdimage);

%colortable
grdimage = sprintf('%s -C%s',grdimage,in.cptfile);

command = sprintf('%s >> %s.ps',grdimage,in.filename);