% LINEWIDTH     Calculate the FWHM of an absorption line.
%
% FORMAT   lw = linewidth(f, a)
%
% OUT   lw         Linewidth.
% IN    f          Frequency grid.
%       a          Absortion cross-sections.

% 2016-12-08   Lukas Kluft: Created.

function lw = linewidth(f, a)
    tmp = fnzeros(interp1(f, a - max(a) / 2, 'linear', 'pp'));
    lw = diff(tmp(1, :));
end
