classdef CollocatedNNIWP < NNTrainedProduct & InstrumentVisualiser & CollocationRetrievalDatabaseProduct
    
    % To be documented.
    %
    % See also: NNTrainedProduct, InstrumentVisualiser, CollocationRetrievalDatabaseProduct

    properties
       maxsize = 200000;
       
       inputs = struct();
%             'MEAN_AVHRR_Y', struct(...
%                 'transform', @(x)x, ...
%                 'invtransform', @(x)x, ...
%                 'lims', [100, 400], ...
%                 'chans', [4, 5]));
%                'chans', [1, 2, 4, 5]), ...
%            'MEAN_ECMWF_Skin_temperature', struct(...
%                'transform', @(x)x, ...
%                'invtransform', @(x)x, ...
%                'lims', [100 400]), ...
%            'B_SZA', struct(...
%                'transform', @sind, ...
%                'invtransform', @asind, ...
%                'lims', [0 80]));
%        inputs = struct(...
%            'B_BT', struct(...
%                 'transform', @(x)x, ...
%                 'invtransform', @(x)x, ...
%                 'lims', [100 400], ...
%                 'chans', [3, 4, 5]));
            
       targets = struct(...
            'MEAN_IWP_2C', struct(...
                'transform', @log10, ...
                'invtransform', @(x)10.^x, ...
                'classify', 10));
                 %'lims', [realmin realmax], ...
           
        dbname = 'Collocated_cacmah_avhrr';
        date1 = [2007, 1, 1];
        date2 = [2008, 1, 0];
        sat1 = 'noaa18';
        sat2 = 'noaa18';
        fields = {'POS2', 'LAT1', 'LON1', 'TIME1', 'LAT2', 'LON2', ...
                  'MHS_LAT', 'MHS_LON', 'A_LAT', 'A_LONG', ...
                  'H_LAT', 'H_LONG', 'MEAN_ROIWP', 'MEAN_IOROIWP', ...
                  'MEAN_IWP_2C', 'MEAN_dardar_IWP', ...
                  'MEAN_ECMWF_Skin_temperature', 'FRAC40_dardar_IWP', ...
                  'NO_ROIWP', 'NO_IOROIWP', 'NO_IWP_2C', ...
                  'NO_dardar_IWP', 'MEAN_AVHRR_Y', ...
                  'MEAN_AVHRR_FLAG_3AB', 'H_BT', 'B_BT', ...
                  'NO_AVHRR_Y', 'B_SZA', 'B_LZA', 'B_LAA', 'B_SAA'};

        collocation_limits = struct();
%         struct('B_BT', [100 400], ...
%             'MEAN_AVHRR_Y', [0 400], ...
%             'LAT1', [-40, 40], ...
%             'B_SZA', [0 80]);

        collocation_filters = {};
%         ...
%             {@(avhrr, surf) avhrr(:, 5) - surf < -20, ...
%              {'MEAN_AVHRR_Y', 'MEAN_ECMWF_Skin_temperature'}}, ...
%             {@(avhrr) avhrr(:, 5) - avhrr(:, 4) > -2, ...
%              {'MEAN_AVHRR_Y'}}, ...
%             };
    end 
    
    properties (Constant)
       chans = [1, 2, 4, 5];
       freqs = {'0.58-0.68', '0.725-1.0', '3.55-3.93', '10.3-11.3', '11.5-12.5'};
        
    end

    methods
        function self = CollocatedNNIWP(varargin)
            self = self@NNTrainedProduct(varargin{:});
        end
        
        function cc = fix_cols_in_postprocessing(self, cc)
            % when reprocessing, don't want to recollocate but use stored
            % fields.  However, they may have different names in the
            % cols-structure.  Re-arrange so that this can be used.
            if isfield(cc, 'MHS')
                %cc.B_BT = [0, 0, cc.MHS];
                cc.B_BT = cc.MHS;
            end
            cc.LAT1 = cc.LAT;
            cc.LON1 = cc.LON;
            cc.TIME1 = cc.TIME;
        end
    end

end
%[M, c] = D.Collocated_cacmah_avhrr.read([2007, 1, 1], [2007, 1, 3], {'noaa18', 'noaa18'}, {'POS2', 'LAT1', 'LON1', 'LAT2', 'LON2', 'MHS_LAT', 'MHS_LON', 'A_LAT', 'A_LONG', 'H_LAT', 'H_LONG', 'MEAN_ROIWP', 'MEAN_IOROIWP', 'MEAN_IWP_2C', 'MEAN_dardar_IWP', 'MEAN_ECMWF_Skin_temperature', 'FRAC100_dardar_IWP', 'NO_ROIWP', 'NO_IOROIWP', 'NO_IWP_2C', 'NO_dardar_IWP', 'MEAN_AVHRR_Y', 'MEAN_AVHRR_FLAG_3AB', 'H_BT', 'B_BT', 'NO_AVHRR_Y', 'B_SZA', 'B_LZA', 'B_LAA'}, struct('B_BT', [100 400], 'MEAN_AVHRR_Y', [0 400], 'LAT1', [-40, 40]));

