; ==========================================================================
; ####################### ARTS IDL INTERFACE PROCEDURE #####################
; ==========================================================================
;
pro aii_color_table
;
;==========================================================================
;+
; NAME:
;       aii_color_table
; PURPOSE:
;       Provides a color table for plots made with IDL.
;
; EXPLANATION:
;       Special color table, derived from the tek_color.
;
; INPUTS:
;       slide  (integer)   the content of the string decides the action, 
;                          Possible values are 'yes' and 'no'.
;
; OUTPUTS:
;       IDL intern color tabale
;
; MODIFICATION HISTORY:
;       07/10/95        created S. Buehler
;       05/12/01        T. Kuhn  alpha version for arts created 
;-
; ==========================================================================
; ##########################################################################
; ==========================================================================
;
;r = [ 0,255,  0,  0,  0,196,255,255,160,  0,  0,140,255, 84,170, 14,191,114, $
;      43, 63,127,191,255,170,101, 43, 43, 43,114,191,229,255]
;g = [ 0,  0,255,  0,255,196,  0,127, 54,255,127,  0,  0, 84,170,131,255,255,$
;      255,211,170,140, 84,229,229,229,170,127, 84, 43, 22, 255 ]
;b = [ 0,  0,  0,255,255,  0,211,  0,255,152,255,211,140, 84,170, 84,114,152,$
;      191,211,211,211,229,114,140,170,229,255,255,255,255,0]

rgb = [ [   0 ,   0 ,   0 ],$   ;  0 black
        [ 235 ,  10 ,   0 ],$   ;  1 red
        [  50 ,  50 , 205 ],$   ;  2 marine
        [   0 , 205 , 150 ],$   ;  3 dark green
        [ 150 , 150 , 155 ],$   ;  4 dark grey
        [  70 , 150 , 200 ],$   ;  5 middle blue
        [  14 , 131 ,  84 ],$   ;  6 very dark green
        [ 175 , 155 ,  50 ],$   ;  7 sand
        [ 200 , 100 ,   0 ],$   ;  8 brown
        [ 200 ,   0 , 200 ],$   ;  9 dark violette
        [  63 , 211 , 211 ],$   ; 10 light blue-green
        [   0 , 255 , 152 ],$   ; 11 light green
        [  84 ,  84 ,  84 ],$   ; 12 nearly black
        [ 170 , 170 , 170 ],$   ; 13 middle gray
        [ 235 ,  50 ,  50 ],$   ; 14 intensive red
        [ 191 , 255 , 114 ],$   ; 15 light yellow-green
        [ 114 , 255 , 152 ],$   ; 16 light green-blue
        [  43 , 255 , 191 ],$   ; 17 light green
        [  63 , 211 , 211 ],$   ; 18 middle blue-greem
        [ 190 , 110 ,   0 ],$   ; 19 marron brown
        [ 170 ,  90 ,   0 ],$   ; 20 dark brown
        [ 180 , 180 , 180 ],$   ; 21 light grey 1
        [ 200 , 200 , 200 ],$   ; 22 light grey 2
        [ 220 , 220 , 220 ],$   ; 23 light grey 3
        [ 250 , 250 , 250 ],$   ; 24 light grey 4
        [  43 , 170 , 229 ],$   ; 25
        [  43 , 127 , 255 ],$   ; 26
        [ 114 ,  84 , 255 ],$   ; 27
        [ 191 ,  43 , 255 ],$   ; 28
        [ 229 ,  22 , 255 ],$   ; 29
        [   0 , 255 , 255 ],$   ; 31 cyan
        [ 255 , 255 ,   0 ] ]   ; 32

tvlct,rgb[0,*],rgb[1,*],rgb[2,*]
;
end
;
; ==========================================================================
; ##########################################################################
; ==========================================================================
