/*! \file  auto_wsv.h
    \brief Declares the enum type that acts as a
    handle for workspace variables. Also declares the
    workspace itself.

    This file was generated automatically by make_auto_wsv_h.cc.
    <b>DO NOT EDIT!</b>

    \date Feb  4 2009, 08:16:37 */

#ifndef auto_wsv_h
#define auto_wsv_h

#include "absorption.h"
#include "los.h"

/*! This is only used for a consistency check. You can get the
    number of workspace variables from wsv_data.nelem(). */
#define N_WSV 65

enum WsvHandle{
  lines_,
  lines_per_tg_,
  tgs_,
  wfs_tgs_,
  wfss_tgs_,
  lineshape_,
  cont_description_names_,
  cont_description_models_,
  cont_description_parameters_,
  raw_ptz_,
  raw_vmrs_,
  p_abs_,
  f_mono_,
  t_abs_,
  z_abs_,
  h2o_abs_,
  n2_abs_,
  vmrs_,
  abs_,
  abs0_,
  abs_per_tg_,
  xsec_per_tg_,
  hse_,
  emission_,
  za_pencil_,
  z_tan_,
  z_plat_,
  l_step_,
  refr_,
  refr_lfac_,
  refr_model_,
  refr_index_,
  r_geoid_,
  z_ground_,
  t_ground_,
  e_ground_,
  los_,
  source_,
  trans_,
  y_space_,
  y_,
  y0_,
  h_,
  absloswfs_,
  k_grid_,
  k_,
  k_names_,
  k_aux_,
  kx_,
  kx_names_,
  kx_lengths_,
  kx_aux_,
  kb_,
  kb_names_,
  kb_lengths_,
  kb_aux_,
  S_S_,
  batchname_,
  ybatch_,
  absbatch_,
  jacbatch_,
  radiosonde_data_,
  coolrate_,
  p_coolrate_,
  method_list_
};

/** The declaration of the (great) workspace. */
class WorkSpace {
public:
/** A list of spectral line data. */
  ArrayOfLineRecord lines;
/** A list of spectral line data for each tag.
    \verbatim
    Dimensions: (tag_groups.nelem()) (# of lines for this tag)
    \endverbatim */
  ArrayOfArrayOfLineRecord lines_per_tg;
/** This is an array of arrays of OneTag tag definitions.
    \verbatim
    It defines the available tag groups for the calculation
    of absorption coefficients and weighting functions.
    Contrary to the original Bredbeck definition, tags within a
    group must belong to the same species, because one VMR profile
    is associated with each tag group.
    \endverbatim */
  TagGroups tgs;
/** This is an array of arrays of tag group definitions.
    \verbatim
    It defines the tag groups for the calculation of weighting
    functions. The selected tag groups must be a subgroup of the
    tag groups defined for the absorption coefficient calculation.
    \endverbatim */
  TagGroups wfs_tgs;
/** This is an array of arrays of tag group definitions.
    \verbatim
    It defines the tag groups for the calculation of weighting
    functions. The selected tag groups must be a subgroup of the
    tag groups defined for the absorption coefficient calculation.
    \endverbatim */
  TagGroups wfss_tgs;
/** Lineshape specification: function, norm, cutoff.
    \verbatim
    There is one entry for
    each abs_tag, not for each species. This means if you have several
    abs_tags for different isotopes or transitions of a species, you
    may use different lineshapes.
    \endverbatim */
  ArrayOfLineshapeSpec lineshape;
/** Continuum / full model absorption tag names.
    \verbatim
    This variable should
    contain a list of tag names of continuum and full models, respectively.
    Associated with this WSV is the WSV
    `cont_description_models' which contains the specific model version of
    each continuum / full model absorption tag and the WSV
    `cont_description_parameters' which should contain the continuum / full model
    user defined parameters. The user defined parameters are only used when
    the specified model is 'user'. See also the online documentation in
    arts/doc/doxygen/html/continua_cc.html.
    
    The following full water vapor models are implemented:
    'H2O-MPM87': absorption model (line and continuum) according to 
       H. J. Liebe,
       A contribution to modeling atmospheric millimeter-wave properties,
       Frequenz,  41, 1987, 31-36
       and
       H. J. Liebe and D. H. Layton,
       Millimeter-wave properties of the atmosphere:
       Laboratory studies and propagation modeling,
       U.S. Dept. of Commerce, National Telecommunications and Information
       Administration, Institute for Communication Sciences,
       325 Broadway, Boulder, CO 80303-3328, report 87224.
    'H2O-MPM89': absorption model (line and continuum) according to 
       H. J. Liebe,
     Int. J. Infrared and Millimeter Waves, 10(6), 1989, 631
    'H2O-MPM93': absorption model (line and continuum) according to 
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel,
     Palma de Mallorca, Spain, 1993, May 17-21 
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    'H2O-CP98': absorption model (line and continuum) according to 
       S. L. Cruz-Pol et al.,
     Radio Science, 33(5), 1319, 1998   (ece.uprm.edu/~pol/Atmosphere.html)
    'H2O-PWR98': absorption model (line and continuum) according to 
       P. W. Rosenkranz,
        Radio Science, 33(4),  919, 1998, Radio Science, 34(4), 1025, 1999
       (ftp: mesa.mit.edu/phil/lbl_rt).
    
    The following full oxygen models are implemented:
    'O2-MPM93': absorption model (line and continuum) according to
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel,
     Palma de Mallorca, Spain, 1993, May 17-21
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    'O2-PWR93': absorption model (line and continuum) according to 
       P. W. Rosenkranz,
     Chapter 2, in M. A. Janssen, 
       Atmospheric Remote Sensing by Microwave Radiometry
       John Wiley & Sons, Inc., 1993 (mesa.mit.edu/phil/lbl_rt)
    
    The following continuum parameterizations are implemented:
    H2O-H2O ('H2O-SelfContStandardType'):
       P. W. Rosenkranz, 
       Radio Science, Vol. 33, No 4, Pages 919-928, 1998 and 
       Radio Science, Vol. 34, No 4, Page 1025, 1999 (mesa.mit.edu/phil/lbl_rt)
    H2O-air ('H2O-ForeignContStandardType'): 
       P. W. Rosenkranz, 
       Radio Science, Vol. 33, No 4, Pages 919-928, 1998 and 
       Radio Science, Vol. 34, No 4, Page 1025, 1999 (mesa.mit.edu/phil/lbl_rt)
    H2O-air ('H2O-ContMPM93'): 
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel,
     Palma de Mallorca, Spain, 1993, May 17-21
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    O2-air ('O2-SelfContStandardType'):
       P. W. Rosenkranz,
       Chapter 2, in M. A. Janssen,
       Atmospheric Remote Sensing by Microwave Radiometry,
       John Wiley & Sons, Inc., 1993
       (mesa.mit.edu/phil/lbl_rt)
       and also described in 
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel,
     Palma de Mallorca, Spain, 1993, May 17-21
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    N2-N2 ('N2-SelfContStandardType'):
       The functional form of Rosenkranz but with more input parameters.
       P. W. Rosenkranz,
       Chapter 2, in M. A. Janssen,
       Atmospheric Remote Sensing by Microwave Radiometry,
       John Wiley & Sons, Inc., 1993 (mesa.mit.edu/phil/lbl_rt)
    N2-N2 ('N2-SelfContMPM93'):
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel, Palma de Mallorca, Spain, 1993, May 17-21 
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    CO2-CO2 ('CO2-SelfContPWR93'):
       P. W. Rosenkranz,
       Chapter 2, in M. A. Janssen,
       Atmospheric Remote Sensing by Microwave Radiometry,
       John Wiley & Sons, Inc., 1993 (mesa.mit.edu/phil/lbl_rt)
    CO2-N2 ('CO2-ForeignContPWR93'):
       P. W. Rosenkranz,
       Chapter 2, in M. A. Janssen,
       Atmospheric Remote Sensing by Microwave Radiometry,
       John Wiley & Sons, Inc., 1993 (mesa.mit.edu/phil/lbl_rt)
    
    The following cloud absorption models are implemented:
    Suspended water droplet ('liquidcloud-MPM93') 
       absorption parameterization from the MPM93 model:
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel,
     Palma de Mallorca, Spain, 1993, May 17-21
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    Ice water droplet absorption ('icecloud-MPM93') 
       parameterization from MPM93 model:
       H. J. Liebe and G. A. Hufford and M. G. Cotton,
       Propagation modeling of moist air and suspended water/ice
       particles at frequencies below 1000 GHz,
       AGARD 52nd Specialists Meeting of the Electromagnetic Wave
       Propagation Panel,
     Palma de Mallorca, Spain, 1993, May 17-21
       (ftp.its.bldrdoc.gov/pub/mpm93/)
    
    The following rain extinction model is implemented:
    Rain extinction parameterization ('rain-MPM93') from the
       MPM93 model, described in:
       H. J. Liebe,
       MPM - An Atmospheric Millimeter-Wave Propagation Model,
       Int. J. Infrared and Millimeter Waves, vol. 10(6),
       pp. 631-650, 1989;
       and based on:
       Olsen, R.L., D.V. Rogers, and D. B. Hodge,
       The aR^b relation in the calculation of rain attenuation,
       IEEE Trans. Antennas Propagat., vol. AP-26, pp. 318-329, 1978.
       IMPORTANT NOTE: rain-MPM93 parameterizes the EXTINCTION by rain,
        not just the absorption. Therefore it is not suitable for 
        calculating thermal emission by rain!
        Please use rain-MPM93 only for calculation of attenuation.
    
    
    \endverbatim */
  ArrayOfString cont_description_names;
/** Continuum / full model absorption model description parameter.
    \verbatim
    See the WSV `cont_description_names' for a detailed description
    of the allowed continuum models. There should be one string here
    for each entry in `cont_description_names'.See also the onlinedocumentation in arts/doc/doxygen/html/continua_cc.html.
    
    \endverbatim */
  ArrayOfString cont_description_models;
/** Continuum model parameters.
    \verbatim
    See the WSV `cont_description_names'
    for a detailed description of the allowed continuum models. There
    should be one parameter vector here for each entry in
    `cont_description_names'. See also the online documentation in
    arts/doc/doxygen/html/continua_cc.html.
    
    \endverbatim */
  ArrayOfVector cont_description_parameters;
/** Matrix has rows:
    1.
    \verbatim
    Pressure in Pa
    2. Temperature in K
    3. Altitude in m
    \endverbatim */
  Matrix raw_ptz;
/** The individual VMR profiles.
    \verbatim
    Each species VMR profile comes with a
    pressure profile. The different species can hence be on different
    grids.
    The matrix has rows:
    1. Pressure in Pa
    2. VMR profile (absolute number)
    The array dimension is determined by the number of tag groups.
    \endverbatim */
  ArrayOfMatrix raw_vmrs;
/** The pressure grid for the absorption coefficients [Pa].
    \verbatim
    This
    is the basic independent grid for the absorption calculation, both
    in the 1D and 2D case. Therefore it remains a vector, even in 2D.
    The "raw" atmospheric data shall be interpolated to p_abs before
    the absorption calculations starts.
    \endverbatim */
  Vector p_abs;
/** The monochromatic frequency grid [Hz]. */
  Vector f_mono;
/** Temperature associated with the pressures in p_abs [K] */
  Vector t_abs;
/** Vertical altitudes associated with the pressures in p_abs [m] */
  Vector z_abs;
/** The total water profile associated with the pressures in p_abs [-] */
  Vector h2o_abs;
/** The total nitrogen profile associated with the pressures in p_abs [-] */
  Vector n2_abs;
/** The VMRs (unit: absolute number) on the p_abs grid.
    \verbatim
    Dimensions: [tag_groups.nelem(), p_abs.nelem()]
    \endverbatim */
  Matrix vmrs;
/** The matrix of absorption coefficients (in units of [1/m]).
    \verbatim
    Dimensions: [f_mono.nelem(), p_abs.nelem()]
    \endverbatim */
  Matrix abs;
/** A second absoprtion matrix.
    \verbatim
    This matrix can be used, for example,
    to store absorption read from a file that shall be added to *abs*.
    \endverbatim */
  Matrix abs0;
/** These are the absorption coefficients individually for each
    tag group.
    \verbatim
    The Array contains one matrix for each tag group,
    the matrix format is the same as that of abs
    \endverbatim */
  ArrayOfMatrix abs_per_tg;
/** These are the cross sections individually for each tag
    group.
    \verbatim
    The Array contains one matrix for each tag group,
    the matrix format is the same as that of abs
    \endverbatim */
  ArrayOfMatrix xsec_per_tg;
/** This vector holds the parameters for calculating hydrostatic 
    equilibrium (HSE).
    \verbatim
    The length of the vector is either 1 or 5, where
    the values are: 
       1: On/off flag. 0 = ignore HSE, 1 = consider HSE.
       2: The pressure of the reference point [Pa]. 
       3: The altitude of the reference point [m]. 
       4: Gravitational acceleration at the geoid surface [m/s2]. 
       5: Number of iterations of the calculations.
    If the on/off flag is set to 1, the length of the vector must be 5,
    while if the flag is 0 a length of 1 is OK.
    See the function hseCalc for some more details.
    \endverbatim */
  Vector hse;
/** Boolean to include emssion in the calculation of spectra.
    \verbatim
    If this variable is set to 0 (zero) pure transmission calculations 
    will be simulated and, for example, yCalc will give optical 
    thicknesses instead of radiation intensities.
    \endverbatim */
  Index emission;
/** Pencil beam zenith angle grid [deg].
    \verbatim
    The observation direction is specified by the angle between zenith 
    and the LOS.
    \endverbatim */
  Vector za_pencil;
/** Tangent altitude for each spectrum [m].
    \verbatim
    These tangent altitudes include the effect of refraction (if set). 
    In the case of a ground intersection, a geometrical prolongation 
    below the ground is applied to determine the tangent altitude. 
    For upward observations where there are no tangent altitudes, 
    *z_tan* is set to 999 km. 
    It should be noted that the LOS calculations take *za_pencil* as 
    input, not *z_tan*. However, *za_pencil* can be calculated from 
    *z_tan* by the function *zaFromZtan*. 
    \endverbatim */
  Vector z_tan;
/** Vertical altitude, above the geoid, of the observation platform [m]. */
  Numeric z_plat;
/** The maximum length, along the LOS, between the points of LOS [m].
    \verbatim
    The final step length will in most cases equal the selected length.
    There are two rare exceptions:
      1. Downward observations from within the atmosphere, where the step
         length is adjusted downwards to get an integer number of steps
         between the sensor and the tangent or ground point.
      2. Limb sounding and the distance from the tangent point to the
         atmospheric limit (the highest absorption altitude) is smaller
         than the selected length. The length is then adjusted to this
         distance
    \endverbatim */
  Numeric l_step;
/** Boolean for inclusion of refraction (0=no refraction, 1=refraction). */
  Index refr;
/** This factor determines the step length used during the ray tracing 
    performed when considering refraction.
    \verbatim
    The step length applied is *l_step* divided by *refr_lfac*. 
    Accordingly, this factor gives how many ray tracing steps that are 
    performed for each step of the LOS.
    \endverbatim */
  Index refr_lfac;
/** A string giving what parameterization to use for the calculation of 
    refractive index.
    \verbatim
    See *refrCalc* for existing choices.
    \endverbatim */
  String refr_model;
/** The refractive index at the pressure levels in p_abs [-]. */
  Vector refr_index;
/** The local curvature radius of the geoid along the LOS [m]. */
  Numeric r_geoid;
/** The vertical altitude above the geoid of the ground [m]. */
  Numeric z_ground;
/** The physical temperature of the ground [K]. */
  Numeric t_ground;
/** The ground emission factor for the frequencies in f_mono [0-1]. */
  Vector e_ground;
/** Structure to define the line of sight (LOS).
    \verbatim
    See los.h for 
    definition of the structure.
    \endverbatim */
  Los los;
/** Mean source function between the points of the LOS. */
  ArrayOfMatrix source;
/** The transmissions between the points of the LOS [-]. */
  ArrayOfMatrix trans;
/** Radiation entering the atmosphere at the top of the atmosphere, 
    typically cosmic background radiation.
    \verbatim
    This variable is most easily 
    set by the function *y_spaceStd*.
    \endverbatim */
  Vector y_space;
/** The working set of spectra.
    \verbatim
    The spectra from the different zenith angles are appended to form *y*.
    \endverbatim */
  Vector y;
/** A reference spectrum.
    \verbatim
    This variable can be used e.g. to save a copy
    of *y* or to compare the spectra before and after some operation(s).
    \endverbatim */
  Vector y0;
/** The H matrix.
    \verbatim
    Can be used to apply the sensor model to monochromatic pencil beam
    spectra and weighting functions. 
    
    \endverbatim */
  Matrix h;
/** Line of sight weighting functions.
    \verbatim
    See AUG for definition of this quantity. 
    \endverbatim */
  ArrayOfMatrix absloswfs;
/** Retrieval grid to be used in calculation of weighting functions (WFs)
    For example, *k_grid* is the pressure altitude grid for species WFs.
    \verbatim
    Not all WFs need 'k_grid* as input.
    \endverbatim */
  Vector k_grid;
/** The weighting functions (WFs) for a single retrieval/error group. */
  Matrix k;
/** Names of the retrieval identies in *k*. */
  ArrayOfString k_names;
/** Auxiliary data for *k*.
    \verbatim
    The number of rows of this matrix equals the
    length of the state vector for the retrieval group (the number of
    columns of k).
    The columns hold different quantities:
      Col 1: retrieval grid (or correspondingly)
      Col 2: a priori values
    \endverbatim */
  Matrix k_aux;
/** The state weighting function matrix. */
  Matrix kx;
/** Names of the retrieval identities in *kx*. */
  ArrayOfString kx_names;
/** The length of the state vector for each retrieval identity in *kx*. */
  ArrayOfIndex kx_lengths;
/** Auxiliary data for *kx*.
    \verbatim
    As *k_aux* but with the data of the 
    different retrieval groups appended vertically.
    \endverbatim */
  Matrix kx_aux;
/** The model parameters weighting function matrix. */
  Matrix kb;
/** Names of the model parameter identities in *kb*. */
  ArrayOfString kb_names;
/** The length of the model vector for each retrieval identity in *kb*. */
  ArrayOfIndex kb_lengths;
/** Auxiliary data for *kb*.
    \verbatim
    As *k_aux* but with the data of the 
    different forward model groups appended vertically.
    \endverbatim */
  Matrix kb_aux;
/** Stores the accuracy of the spectroscopic parameters read from catalog
    This are necessary for the the spectroscopic error analysis
    number columns = 2; first keeps the absolute error, second the error in percents
    number lines equal of spectroscopic parameters investigated (the number of
    columns of k). */
  Matrix S_S;
/** Default basename for batch data. */
  String batchname;
/** A batch of spectra.
    \verbatim
    The spectra are stored as columns in a matrix
    \endverbatim */
  Matrix ybatch;
/** A batch of absorption coefficients.
    \verbatim
    FIXME
    \endverbatim */
  ArrayOfMatrix absbatch;
/** A batch of jacobian matrices.
    \verbatim
    FIXME
    \endverbatim */
  ArrayOfMatrix jacbatch;
/** An array of Matrix holding data for many radiosonde launches.
    \verbatim
    The
    dimension of the Array is the number of radiosonde launches. Each
    Matrix within the Array has dimension nx4, where n is the number of
    pressure levels. The columns of the Matrix are:
    
    pressure [Pa] temperature [K] altitude [m] VMR [1]
    \endverbatim */
  ArrayOfMatrix radiosonde_data;
/** Cooling rate matrix, in unit of K/s/Hz.
    \verbatim
    Dimensions: [f_mono.nelem(), z_crates.nelem()]
    \endverbatim */
  Matrix coolrate;
/** Pressures for which to calculate cooling rates. */
  Vector p_coolrate;
/** A list of methods.
    \verbatim
    See "arts -d MethodListDefine"
    for an explanation what a method list is.
    \endverbatim */
  ArrayOfIndex method_list;
};

#endif  // auto_wsv_h
