/*! \file  auto_wsv_groups.h
    \brief Defines the enum type that acts as a
    handle for workspace variables groups.

    Also defined here is a special pointer class that can hold
    a pointer to any workspace variable.

    This file was generated automatically by make_auto_wsv_groups_h.cc.
    <b>DO NOT EDIT!</b>

    \date Feb  4 2009, 08:16:35 */

#ifndef auto_wsv_groups_h
#define auto_wsv_groups_h

#include "los.h"
#include "absorption.h"

/*! This is only used for a consistency check. You can get the
    number of groups from wsv_group_names.nelem(). */
#define N_WSV_GROUPS 14

/*! The enum type that identifies wsv groups.
    This is used to group workspace variables of the same type
    together, so that generic methods can operate on any of them. */
enum WsvGroup{
  Index_,
  Numeric_,
  String_,
  Vector_,
  Matrix_,
  ArrayOfIndex_,
  ArrayOfString_,
  ArrayOfVector_,
  ArrayOfMatrix_,
  ArrayOfLineRecord_,
  ArrayOfArrayOfLineRecord_,
  ArrayOfLineshapeSpec_,
  TagGroups_,
  Los_,
};

/*! Base class for the different Wsv pointers.
    This contains a virtual function for the
    conversion operator for each group.

    \author Stefan Buehler */
class WsvP {
public:
  virtual operator Index*(){safety();return NULL;};
  virtual operator Numeric*(){safety();return NULL;};
  virtual operator String*(){safety();return NULL;};
  virtual operator Vector*(){safety();return NULL;};
  virtual operator Matrix*(){safety();return NULL;};
  virtual operator ArrayOfIndex*(){safety();return NULL;};
  virtual operator ArrayOfString*(){safety();return NULL;};
  virtual operator ArrayOfVector*(){safety();return NULL;};
  virtual operator ArrayOfMatrix*(){safety();return NULL;};
  virtual operator ArrayOfLineRecord*(){safety();return NULL;};
  virtual operator ArrayOfArrayOfLineRecord*(){safety();return NULL;};
  virtual operator ArrayOfLineshapeSpec*(){safety();return NULL;};
  virtual operator TagGroups*(){safety();return NULL;};
  virtual operator Los*(){safety();return NULL;};

virtual ~WsvP(){};

private:
/*! Safety check. This is called by all the virtual conversion
    operators. It just stops the program with an error message. This
    should never happen, because conversion should only be attempted
    to the correct type, for which an overloaded conversion operator
    exists. */
  void safety() {
    cerr << "Internal error: Tried to convert a WsvP "
         << "pointer to the wrong type.\n";
    exit(1);
  };
};

#endif  // auto_wsv_groups_h
