from PyARTS import *

import os
import numpy

#First generate the cloud stuff

lat1=-2.0
lat2=2.0
lon1=-2.0
lon2=2.0
ztopkm=14.0
zbottomkm=13.0
cb_size={'np':5,'nlat':5,'nlon':5} #no need for 41 lat and lon
zfile='../data/tropical.z.xml'
IWC=0.01
tfile='../data/tropical.t.xml'

a_cloud=clouds.boxcloud(ztopkm,zbottomkm,lat1,lat2,
                        lon1,lon2,cb_size,zfile,
                        tfile,IWC)
random_plate=clouds.Crystal(ptype=20,NP=-1,aspect_ratio=2.000001)
a_cloud.addHydrometeor(random_plate)
a_cloud.scat_file_gen(f_grid=[334e9,335e9],num_proc=2)
a_cloud.pnd_field_gen('pnd_field.xml')

#save your cloud object for later use
general.quickpickle(a_cloud,'cloud.pickle')

#and make yourself a better pressure grid
old_grid=numpy.logspace(numpy.log10(101300),numpy.log10(1300),20)
new_grid=arts_math.gridmerge(old_grid,a_cloud.p_grid[1:-2])
artsXML.save(new_grid,'new_p_grid.xml')

#and also better lat/lon grids
old_grid=artsXML.load('../data/lat_grid.xml')
new_grid=arts_math.gridmerge(old_grid,a_cloud.lat_grid[1:-2])
artsXML.save(new_grid,'new_lat_grid.xml')
old_grid=artsXML.load('../data/lon_grid.xml')
new_grid=arts_math.gridmerge(old_grid,a_cloud.lon_grid[1:-2])
artsXML.save(new_grid,'new_lon_grid.xml')

#And now do the arts simulation
arts_params={
    "atm_basename":"../data/tropical",#changes to 3D later
    "cloud_box":a_cloud.cloudbox,
    'freq':334.65e9,
    "abs_species":['H2O','N2','O2'],
    "abs_lookup":"../data/ciwsir_gas_abs_lookup.xml.bin",
    "lat_grid":"new_lat_grid.xml",
    "lon_grid":"new_lon_grid.xml",
    "max_time":10,
    "p_grid":"new_p_grid.xml",
    "pnd_field_raw":a_cloud.pnd_file,
    "rte_pos":{'r_or_z':95000.1+arts_geometry.EARTH_RADIUS,'lat':9.1,'lon':0, "corrected": True},
    "rte_los":{'za':99.14,'aa':180},
    "scat_data_file":a_cloud.scat_files,
    "stokes_dim":4,
    "dim": 3,
    'z_field_is_1D':1
    }

# disabled GH 2011-05-18: how to get f_index?
#
#my_run=arts.ArtsRun(arts_params,'montecarlo','cfile.arts')
#my_run.run()
##save the run instance for later
#general.quickpickle(my_run,'my_run.pickle')
#
#print 'y = '+str(my_run.output['y'])
#print 'error = '+str(my_run.output['mc_error'])
#print 'time = '+str(my_run.time_elapsed)
#
