""" Generates and plots a SLIData2 object than can be used as
mc_incoming for ARTS-MC runs.
This example requires the matplotlib package"""

from PyARTS.arts_file_components import EARTH_RADIUS
from PyARTS.plotting import *
from PyARTS.arts import create_incoming_lookup

#Define the parameters needed for 1D clear sky RT 
arts_params={
  "atm_basename":"../data/tropical",
  "lat_grid":"../data/lat_grid.xml",
  "lon_grid":"../data/lon_grid.xml",
  "p_grid":{'start':101300,'stop':1300,'nelem':50},
  "r_geoid":EARTH_RADIUS,
  "stokes_dim":1,
  "dim": 1,
  "z_ground":0,
  'freq':334.65e9,
  "abs_species":['H2O','N2','O2'],
  "abs_lookup":"../data/ciwsir_gas_abs_lookup.xml.bin"
  }

#The next line creates an initialised SLIData2 object with the right
#function for calculating incoming radiances 

# GH 2011-05-18, commented out, cannot get this to work, no z_field?!
#
#A=create_incoming_lookup(arts_params,zkm0=linspace(6,16,10),
#                         za0=linspace(0,180,10))
#
##refine the grid
#A.refine(200)
#
##start plotting
#figpos=[0.02,0.02,0.96,0.9]
#figure(figsize=(16,5))
#ax1=mySubplot(1,3,1,figpos)
#A.plot()
#title('A.refine(200)')
#xlabel('zenith angle')
#ylabel('z')
#
##refine the grid some more
#A.refine(1000)
#
##another plot
#mySubplot(1,3,2,figpos)
#A.plot()
#title('A.refine(1000)')
#xlabel('zenith angle')
#
##refine the grid some more
#A.refine(5000)
#
##plot it again
#mySubplot(1,3,3,figpos)
#A.plot()
#title('A.refine(5000)')
#xlabel('zenith angle')
##title for the figure
#figtext(0.5,0.93,'A=create_incoming_lookup(arts_params,zkm0=linspace(6,16,10),za0=linspace(0,180,10))',horizontalalignment='center',fontsize=14)
##save the figure
#savefig('plot.png')
#savefig('plot.eps')
#
##Save the gridded data in ARTS XML format
#A.save('../data/mc_incoming.xml')
#
##show the plot
##show()
