from numpy.distutils.core import setup,Extension
try:
    from distutils.command.build_py import build_py_2to3 as build_py
except ImportError:
    from distutils.command.build_py import build_py

import os
import os.path

# get version number

changelog_path = os.path.join(os.path.dirname(__file__), "ChangeLog")
substr = "PyARTS-"
with open(changelog_path) as fp:
    for line in fp:
        if substr in line:
            version_no = line[(line.index(substr)+len(substr)):].strip().replace("-", ".")
            break
    else:
        raise Exception("Cannot determine PyARTS version from ChangeLog")

include_dirs=['./src']
libraries=[]

HAVE_QUAD=os.getenv('HAVE_QUAD','0')
HAVE_QUAD=int(HAVE_QUAD)

if HAVE_QUAD:
    tmatrix_sig_file='./src/tmatrixQUAD.pyf'
    tmd_sig_file='./src/tmdQUAD.pyf'
else:
    tmatrix_sig_file='./src/tmatrix.pyf'
    tmd_sig_file='./src/tmd.pyf'


tmdsources=[tmd_sig_file,'./src/tmd.f','./src/main_dummy.c','./src/lpd.f']
tmatrixsources=[tmatrix_sig_file,'./src/tmatrix.f',
                './src/avg_tmatrix.f','./src/main_dummy.c','./src/lpd.f']

if HAVE_QUAD:
    tmatrixsources.extend(['./src/tmatrixq.f','./src/lpq.f'])
    tmdsources.extend(['./src/tmq.f','./src/lpq.f'])


scatsubs=Extension(name = 'scatsubs',
		   sources = ['./src/scatsubs.pyf','./src/scatsubs.f',
                              './src/main_dummy.c'],
		   include_dirs=include_dirs
		   )

tmd=Extension(name = 'tmd',
              sources = tmdsources,
              include_dirs=include_dirs,
              libraries=libraries
	      )

tmatrix=Extension(name = 'tmatrix',
                  sources = tmatrixsources,
                  include_dirs=include_dirs,
                  libraries=libraries
		  )

REFICE=Extension(
    name = 'REFICE',
    sources = ['./src/REFICE.pyf','./src/REFICE.f','./src/main_dummy.c'],
    include_dirs=include_dirs
    )

setup(name = 'PyARTS',
      url = 'http://www.sat.ltu.se/arts/tools/',
      version = version_no,
      description  = 'ARTS related python modules',
      author       = "Cory Davis and Gerrit Holl",
      author_email = "gerrit.holl@ltu.se",
      packages  = ["PyARTS"],
      ext_package = 'PyARTS',
      ext_modules  = [scatsubs,tmd,tmatrix,REFICE],
      scripts = ['scat_file_batch'],
      package_data={'PyARTS':['share/*']},
      cmdclass = {'build_py': build_py},
      )
