from PyARTS import arts_types
from PyARTS import arts_math
from PyARTS import clouds
import unittest
import os
from scipy import *
from scipy import integrate
from PyARTS import arts_scat

import numpy
#numpy.seterr(all="raise")

class BoxCloudTest(unittest.TestCase):
    lat1=-1.8
    lat2=1.8
    lon1=-1.8
    lon2=1.8
    ztopkm=13.4
    zbottomkm=11.9
    cb_size={'np':5,'nlat':6,'nlon':7}
    zfile='../data/tropical.z.xml'
    IWC=1.0
    tfile='../data/tropical.t.xml'
    def testNoErrors(self):
        """boxcloud should produce a cloud object (and generate files)
        without errors"""
        a_cloud=clouds.boxcloud(self.ztopkm,self.zbottomkm,self.lat1,self.lat2,
                                self.lon1,self.lon2,self.cb_size,self.zfile,
                                self.tfile,self.IWC)
        sph=clouds.Crystal(ptype=20,NP=-1,aspect_ratio=1.000001)
        a_cloud.addHydrometeor(sph)
        a_cloud.scat_file_gen(f_grid=[200e9,201e9],num_proc=2)
        a_cloud.pnd_field_gen('pnd_field.xml')
    def tearDown(self):
        os.remove('pnd_field.xml')

class DropletTest(unittest.TestCase):
    def testScatteringProperties(self):
        """Testing accuracy of Droplet scattering properties/pnd fields"""
        #calculate extinction coefficient produced by Droplet
        a_cloud=clouds.boxcloud(10,5,-1,1,-1,1,{'np':5,'nlat':5,'nlon':5},
                                '../data/tropical.z.xml',
                                '../data/tropical.t.xml',LWC=0.1)
        water_droplet=clouds.Droplet(c1=6,c2=1,rc=20,npoints=5)
        a_cloud.addHydrometeor(water_droplet,habit_fraction=1.0)
        a_cloud.scat_file_gen(f_grid=[8.99e10,90e9], num_proc=1)
        a_cloud.pnd_field_gen('/dev/null')
        scat_data=arts_types.SingleScatteringData.load(a_cloud.scat_files[0])
        k=a_cloud.pnd_fields[0].data[4,4,4]*scat_data.ext_mat_data[0,0,0,0,0]
        #print k
        #calculate extinction coefficient 'manually'
        def numdens_x_ext_coeff(r):
            numdens=clouds.nioku(0.1,r,rc=20,c1=6,c2=1)
            scat_data=arts_types.SingleScatteringData({'equiv_radius':r,
                                                      'phase':'liquid',
                                                      'aspect_ratio':1.000001,
                                                      'f_grid':[89.9e9,90e9],
                                                      'T_grid':[260,280,300,320],
                                                      'ptype':20,'NP':-1})
            scat_data.calc()
            return numdens*scat_data.ext_mat_data[0,0,0,0,0]
        #integrate k over size distribution
        k1=integrate.quad(numdens_x_ext_coeff,0.1,1000)[0]
        #print k1
        assert abs(k-k1)/k<0.01,"extinction coefficient more than 1% away from manually calculated value (" + str(abs(k-k1)/k) + ")"

class NiokuTest(unittest.TestCase):
    def testNormalisationOfNiokuDistribution(self):
        """Testing the normalisation of the Nioku size distribution"""
        IWC=0.01
        rc=10.0
        c1=6.0
        c2=1.0
        def func(r):
            return clouds.nioku(IWC,r,rc,c1,c2)*r**3
        IWC_from_nioku=4*pi/3*1e-12*arts_math.qromb(func,0.01,1000.0)[0]
        #print 'IWC = '+str(IWC_from_nioku)
        assert (abs(IWC_from_nioku-IWC)/IWC < 0.01),"normalisation problem in nioku"

class GammaTest(unittest.TestCase):
    def testNormalisationOfGammaDistribution(self):
        """Testing the normalisation of the Gamma size distribution"""
        from scipy import integrate
        def func(r):
            return clouds.gamma_dist(r,0.1,50.0,1.2,phase='ice')*4*pi*r**3*clouds.rho_ice*1e-12/3
        try:
            #IWC_from_gamma=integrate.quad(func,0.001,1000)[0]
            IWC_from_gamma=arts_math.qromb(func,0.001,1000)[0]
            #print IWC_from_gamma
        except ImportError:
            print "this test requires SciPy"
            return
        assert (abs(IWC_from_gamma-0.1)/0.1 < 0.01),"normalisation problem in gamma_dist"
    def testScatteringProperties(self):
        """Testing accuracy of Gamma scattering properties/pnd fields"""
        #calculate extinction coefficient produced by Droplet
        a_cloud=clouds.boxcloud(10,5,-1,1,-1,1,{'np':5,'nlat':5,'nlon':5},
                                '../data/tropical.z.xml',
                                '../data/tropical.t.xml',IWC=0.1)
        ice_gamma=clouds.Gamma(r_eff=20,g=1.5)
        a_cloud.addHydrometeor(ice_gamma,habit_fraction=1.0)
        a_cloud.scat_file_gen(f_grid=[8.99e10,90e9], num_proc=1)
        a_cloud.pnd_field_gen('/dev/null')
        scat_data=arts_types.SingleScatteringData.load(a_cloud.scat_files[0])
        k=a_cloud.pnd_fields[0].data[4,4,4]*scat_data.ext_mat_data[0,0,0,0,0]
        #print k
        #calculate extinction coefficient 'manually'
        def numdens_x_ext_coeff(r):
            numdens=clouds.gamma_dist(r,0.1,r_eff=20,g=1.5)
            scat_data=arts_types.SingleScatteringData({'equiv_radius':r,
                                                      'phase':'ice',
                                                      'aspect_ratio':1.000001,
                                                      'f_grid':[89.9e9,90e9],
                                                      'T_grid':[215,272.15],
                                                      'ptype':20,'NP':-1})
            scat_data.calc()
            return numdens*scat_data.ext_mat_data[0,0,0,0,0]
        #integrate k over size distribution
        k1=arts_math.qromb(numdens_x_ext_coeff,0.1,1000,0.000001)[0]
        #from scipy import integrate
        #k1=integrate.quad(numdens_x_ext_coeff,0.0,2000)[0]

        #print k1
        assert abs(k-k1)/k<0.01,"extinction coefficient more than 1% away from manually calculated value (" + str(abs(k-k1)/k) + ")"

if __name__=='__main__':
    unittest.main()

