from PyARTS.plotting import *
from PyARTS.general import *

data=quickunpickle('failures.pickle')


def doplot(np,ar):
    x=data[np][ar]
    lasti=x.index(1.0)+1;print lasti
    x=array(x[:lasti])
    y=arange(len(x))+1
    plot(x,y,'ro')
    setp(gca(),'ylim',[0,y[-1]+1])
    dx=x[0]*2/90
    for i in range(len(x)):
        text(x[i]+dx,y[i],str(int(x[i])),fontsize=8)
    xlabel('size parameter')

clf()

mySubplot(2,2,1)
doplot(-1,1.0)
ylabel('aspect ratio')
title('Oblate Spheroids')

mySubplot(2,2,2)
doplot(-1,-1.0)
ylabel('1/(aspect ratio)')
title('Prolate Spheroids')

mySubplot(2,2,3)
doplot(-2,1.0)
ylabel('aspect ratio')
title('Oblate Cylinders')
gca().set_xlim([0,50])

mySubplot(2,2,4)
doplot(-2,-1.0)
ylabel('1/(aspect ratio)')
title('Prolate Cylinders')
gca().set_xlim([0,50])

savefig('tmatlim.png')


show()

