macro (ARTS_TEST_RUN_CTLFILE TESTNAME CTLFILE)
  string(REGEX REPLACE "/" "." TESTNAME_LONG ${CTLFILE})
  string(REGEX REPLACE ".arts$" "" TESTNAME_LONG ${TESTNAME_LONG})
  set(TESTNAME_LONG arts.ctlfile.${TESTNAME}.${TESTNAME_LONG})
  set(ARTS arts -r002 -I${CMAKE_CURRENT_SOURCE_DIR})
  if (ARTS_XML_DATA_DIR)
    set(ARTS ${ARTS} -D${ARTS_XML_DATA_DIR})
  endif()
  add_test(
    NAME ${TESTNAME_LONG}
    COMMAND ${ARTS} ${CMAKE_CURRENT_SOURCE_DIR}/${CTLFILE}
    )
endmacro (ARTS_TEST_RUN_CTLFILE)

macro (ARTS_TEST_CMDLINE TESTNAME OPTIONS)
  set(ARTS arts)
  add_test(
    NAME arts.cmdline.${TESTNAME}
    COMMAND ${ARTS} ${OPTIONS} ${ARGN}
    )
endmacro (ARTS_TEST_CMDLINE TESTNAME OPTIONS)

macro (ARTS_TEST_CTLFILE_DEPENDS TESTNAME DEPENDNAME)
  set_tests_properties(
    arts.ctlfile.${TESTNAME}
    PROPERTIES DEPENDS arts.ctlfile.${DEPENDNAME}
    )
endmacro (ARTS_TEST_CTLFILE_DEPENDS)

