#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue May 22 12:14:03 2018

Plots testdata/dtest-"+ls+"/ files.

First figure shows values of analytically and perturbed
computations of the derivatives for a few variable.

Second figure shows the relative differences between
analytically and perturbed calculations for the same
derivatives.

@author: larsson
"""

import typhon
import numpy as np
import matplotlib.pyplot as plt

f = np.linspace(-1, 1, 501)
DPM = typhon.arts.xml.load("testdata/zeeman/dpropmat.xml")
PM = typhon.arts.xml.load("testdata/zeeman/propmat.xml")[0].data[0, 0]
dpmT = typhon.arts.xml.load("testdata/zeeman/propmat_dT.xml")[0].data[0, 0]
dpmvmr = typhon.arts.xml.load("testdata/zeeman/propmat_dvmr.xml")[0].data[0, 0]
dpmf = typhon.arts.xml.load("testdata/zeeman/propmat_df.xml")[0].data[0, 0]
dpmu = typhon.arts.xml.load("testdata/zeeman/propmat_du.xml")[0].data[0, 0]
dpmv = typhon.arts.xml.load("testdata/zeeman/propmat_dv.xml")[0].data[0, 0]
dpmw = typhon.arts.xml.load("testdata/zeeman/propmat_dw.xml")[0].data[0, 0]
dpmH = typhon.arts.xml.load("testdata/zeeman/propmat_dH.xml")[0].data[0, 0]

pm = PM * 1
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0])
plt.tight_layout()

dpm = DPM[0].data[0, 0]
pm = (dpmT - PM) / 0.01
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()

dpm = DPM[1].data[0, 0]
pm = (dpmvmr - PM) / 0.00001
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()

dpm = DPM[2].data[0, 0]
pm = (dpmf - PM) / 0.0001e9
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()

dpm = DPM[3].data[0, 0]
pm = (dpmu - PM) / 0.01e-6
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()

dpm = DPM[4].data[0, 0]
pm = (dpmv - PM) / 0.01e-6
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()

dpm = DPM[5].data[0, 0]
pm = (dpmw - PM) / 0.01e-6
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()

dpm = DPM[6].data[0, 0]
H = [25e-6, 60e-6, 10e-6]
pm = (dpmH - PM) / (0.001 * np.sqrt(np.array(H).dot(H)))
plt.figure(figsize=(7, 7))
plt.subplot(4, 4, 1)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 2)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 3)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 4)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 5)
plt.plot(f, pm[:, 1], f, dpm[:, 1])
plt.subplot(4, 4, 6)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 7)
plt.plot(f, pm[:, 4], f, dpm[:, 4])
plt.subplot(4, 4, 8)
plt.plot(f, pm[:, 5], f, dpm[:, 5])
plt.subplot(4, 4, 9)
plt.plot(f, pm[:, 2], f, dpm[:, 2])
plt.subplot(4, 4, 10)
plt.plot(f, -pm[:, 4], f, -dpm[:, 4])
plt.subplot(4, 4, 11)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.subplot(4, 4, 12)
plt.plot(f, pm[:, 6], f, dpm[:, 6])
plt.subplot(4, 4, 13)
plt.plot(f, pm[:, 3], f, dpm[:, 3])
plt.subplot(4, 4, 14)
plt.plot(f, -pm[:, 5], f, -dpm[:, 5])
plt.subplot(4, 4, 15)
plt.plot(f, -pm[:, 6], f, -dpm[:, 6])
plt.subplot(4, 4, 16)
plt.plot(f, pm[:, 0], f, dpm[:, 0])
plt.tight_layout()
plt.show()
