% QARTS_CLOUDBOX   Defines setting fields for ARTS cloudbox calculations
%
%    The function provides a description of each recognised field and sets
%    the fields to {}.
%
%    This function is organised in such way that *qcheck* and *qinfo*
%    can be used.
%
% FORMAT   [C,I] = qartsCloudbox
%        
% OUT   C  Setting structure with default values for all recognised fields.
%       I  Includes same fields as C, where the content of each field
%          is a description string (used by *qinfo*).

% 2005-03-14   Created by Patrick Eriksson.


function [C,I] = qartsCloudbox
 
%-----------------------------------------------------------------------------
C.LIMITS = {};
I.LIMITS = [ ...
'Cloudbox limits. Given as a vector, with length 2-6 depending on the ',...
'atmospheric dimensionality. Absolute units are used (not indices). ',...
'Geometrical altitude is used for the vertical dimension. See further ',...
'cloudboxSetManuallyAltitude. The vector can be longer than actually needed.'
];
%-----------------------------------------------------------------------------
C.METHOD = {};
I.METHOD = [ ...
'Calculation method for scattering. Allowed options are:',...
'#   ''DOIT'' : Discrete ordinate iterative method',...
'#   ''MC''   : Backward Monte Carlo',...
'#   ''FOS''  : Fixed order of scattering',...
'#   ''none'' : Scattering calculations handled differently.',...
'A method must always be selected when Q_CLOUDBOX_DO=1.'
];
%-----------------------------------------------------------------------------
C.METHOD_PRMTRS = {};
I.METHOD_PRMTRS = [ ...
'Parameters and data for scattering calculation method, given as a ',...
'structure. DATA must always be specified when Q_CLOUDBOX_DO=1. ',...
'The set of fields of this structure depend on choosen METHOD:',...
'# ',...
'#*** MC ***',...
'#   STD_ERR         : As the *MCGeneral* keyword argument with same name.',...
'#                     The unit of this value is determined by Q.Y_UNIY.',...
'#   MAX_TIME        : As the *MCGeneral* keyword argument with same name.',...
'#   MAX_ITER        : As the *MCGeneral* keyword argument with same name.',...
'#   MIN_ITER        : As the *MCGeneral* keyword argument with same name.',...
'# ',...
'#*** DOIT ***',...
'#   N_ZA_GRID       : ',...
'#As the keyword arguments of *DoitAngularGridsSet*.',...
'#   N_AA_GRID       : ',...
'#As the keyword arguments of *DoitAngularGridsSet*.',...
'#   ZA_GRID_OPT_FILE: ',...
'#As the keyword arguments of *DoitAngularGridsSet*.', ...
' If no filename is given ("", '''' or []), equidistant grids are used ', ...
'for  RT and scattering integral. This option can be used for down-looking', ...
' simulations.',...
'#   SCAT_ZA_INTERP  : ',...
'#As the WSV with same name. Set through *DoitAngularGridsSet*. Must be ',...
'set to ''linear'' or ''polynomial'' independently if an interpolation ',...
'is performed or not. The later is controlled by *ZA_GRID_OPT_FILE*.',...
'#   EPSILON         : ',...
'#As the keyword argument of *doit_conv_flagAbsBT*. ',...
'Here given as a vector. Length of vector must be >= *STOKES_DIM*. ',...
'The vector is truncated if longer.',...
'#   ALL_F           : ',...
'#As the keyword argument *all_frequencies* of *doit_i_fieldSetClearsky*. ',...
'If true, the internal intensity field of the cloud box is reset to the ',...
'clear sky field for each frequency. Otherwise, this is done only for the ',...
'the first frequency, and the previous solution field is used as starting ',...
'point for subsequent frequencies.',...
'#   NORMALIZE       : ',...
'#As the keyword argument *normalize* of *doit_i_fieldUpdateSeq1D*. ',...
'Default is 0.',...
'#   NORM_ERROR_THRESHOLD: ',...
'#As the keyword argument *norm_error_threshold* of ',...
'*doit_i_fieldUpdateSeq1D*. Must be set if NORMALIZE is an existing field.'
];
%-----------------------------------------------------------------------------
C.OPT_PROP_PART_AGENDA = {};
I.OPT_PROP_PART_AGENDA = [ ...
'List of WSMs to include in agenda *opt_prop_gas_agenda*. ', ...
'WSMs are listed as an array of strings, with possible arguments. '
];
%-----------------------------------------------------------------------------
C.PARTICLE_MASSES = {};
I.PARTICLE_MASSES = [ ...
'As the WSM with the same name.'
];
%-----------------------------------------------------------------------------
C.PND_FIELD = {};
I.PND_FIELD = [ ...
'Raw fields of particle number densities. These are added by the WSM ',...
'ParticleTypeAdd. Each raw field can be given as a file name or numeric ',...
'data. The number of elements in *PND_FIELD* and *SCAT_DATA* must be ',...
'identical. That is, both fields must be set, or both be {}.'
];
%-----------------------------------------------------------------------------
C.SCAT_DATA = {};
I.SCAT_DATA = [ ...
'Raw ingle scattering data. These are added by the WSM ',...
'ParticleTypeAdd. Each raw field can be given as a file name or numeric ',...
'data. The number of elements in *PND_FIELD* and *SCAT_DATA* must be ',...
'identical. That is, both fields must be set, or both be {}.'
];
%-----------------------------------------------------------------------------
C.SPT_CALC_AGENDA = {};
I.SPT_CALC_AGENDA = [ ...
'List of WSMs to include in agenda *spt_calc_agenda*. ', ...
'WSMs are listed as an array of strings, with possible arguments. This ',...
'agenda is not used by the MC method.'
];
%-----------------------------------------------------------------------------
