function [gmtStructureElements,gmtStructStructElements] = gmt_inputs
%% gmt_inputs
%  Purpose: A list of all the inputs and their types to gmt_plot
%
% OUT
%     cells: {@fhandle to chech the input,'stringname of field'}
%
% NOTE (to editor):
%    Make sure that new variables are added to these lists!
% $Id: gmt_inputs.m 10474 2017-05-31 06:46:56Z seliasson $
% Created by Salomon Eliasson

gmtStructureElements    = {...
    @isscalar                       ,'add_offset'           ;...
    @ischar                         ,'cptfile'              ;...
    @(x)isstruct(x)||ischar(x)      ,'ctable'               ;...
    @ischar                         ,'color_background'     ;...
    @ischar                         ,'color_foreground'     ;...
    @isstruct                       ,'colorrange'           ;...
    @ischar                         ,'color_nan'            ;...
    @(x)isstruct(x)||ischar(x)      ,'contourline'          ;...
    @isvector                       ,'datarange'            ;...
    @(x)(islogical(x) || (isscalar(x) && x<2)),'display'    ;...
    @(x)isstruct(x)||(islogical(x)||(isscalar(x)&&x<2)),'extra_legend';...
    @ischar                         ,'filename'             ;...
    @isscalar                       ,'fill_value'           ;...
    @ischar                         ,'figuretype'           ;...
    @(x)(ischar(x)||isscalar(x))    ,'font_annot_primary'   ;...
    @(x)(ischar(x)||isscalar(x))    ,'fontsize_annot_primary';...
    @(x)(ischar(x)||isscalar(x))    ,'font_annot_secondary' ;...
    @(x)(ischar(x)||isscalar(x))    ,'fontsize_annot_secondary';...
    @(x)(ischar(x)||isscalar(x))    ,'font_title'           ;...
    @(x)(ischar(x)||isscalar(x))    ,'fontsize_title'       ;...
    @(x)isfunction_handle(x)        ,'func'                 ;...
    @iscellstr                      ,'gmtset'               ;...
    @ischar                         ,'grdimage'             ;...
    @(x)islogical(x)||(isscalar(x)&&x<2),'keep_files'       ;...
    @(x)isstruct(x)||islogical(x)||(isscalar(x)&&x<2),'legend';...
    @isstruct                       ,'locations'            ;...
    @ischar                         ,'map_title_offset'     ;...
    @ischar                         ,'makecpt'              ;...
    @(x)islogical(x)||(isscalar(x) && x<2),'makeScriptAndStop';...
    @(x)isfunction_handle(x)        ,'mask'                 ;...
    @(x)islogical(x)||(isscalar(x)&&x<2),'nanlegend'        ;...
    @(x)isstruct(x)||ischar(x)      ,'nearneighbor'         ;...
    @(x)islogical(x)||(isscalar(x) && x<2),'nodata'         ;...
    @isscalar                       ,'nlevels'              ;...
    @ischar                         ,'outdir'               ;...
    @ischar                         ,'plotPlacement'        ;...
    @(x)isstruct(x)||ischar(x)      ,'proj'                 ;...
    @ischar                         ,'proj_length_unit'     ;...
    @(x)isstruct(x)                 ,'psbasemap'            ;...
    @(x)(isstruct(x)||ischar(x) ||...
    (islogical(x) || (isscalar(x) && x<2))),'pscoast'       ;...
    @isstruct                       ,'pspoly'               ;...
    @ischar                         ,'pscale'               ;...
    @ischar                         ,'pscale_extra'         ;...
    @(x)isstruct(x)||ischar(x)      ,'pstext'               ;...
    @ischar                         ,'region'               ;...
    @(x)islogical(x)||(isscalar(x)&&x<=2),'savelegend'      ;...
    @isscalar                       ,'scale_factor'         ;...
    @isscalar                       ,'stepsize'             ;...
    @isvector                       ,'tickval'              ;...
    @ischar                         ,'title'                ;...
    @(x)islogical(x)||(isscalar(x)&&x<=2),'treatAsUngridded';...
    @ischar                         ,'unit'                 ;...
    @ischar                         ,'xunit'                ;...
    };

gmtStructStructElements = struct(...
    'colorrange',{{...
    @iscell				,'colors'               ;...
    @ischar				,'color_model'          }},...
    'contourline',{{...
    @isscalar			,'spacing'              ;...
    @isvector			,'range'                ;...
    @isscalar			,'linethick'            ;...
    @ischar				,'more'                 ;...
    @ischar             ,'str'                  }},...
    'ctable',{{...
    @ischar             ,'name'                 ;...
    @isscalar           ,'reference'            ;...
    @isscalar           ,'nwhite'               ;...
    @isscalar           ,'reverse'              }},...
    'extra_legend',{{...
    @ischar             ,'name'                       ;...
    @ischar             ,'type'                       ;...
    @ischar             ,'position'                   ;...
    @(x)(ischar(x)||isscalar(x)),'fontsize'           ;...
    @ischar                     ,'extra_instructions' ;...    
    @ischar                     ,'justify'            ;...    
    @(x)(ischar(x)||isscalar(x)),'length'             ;...
    @isscalar                   ,'lineThick'          ;...
    @(x)(ischar(x)||isscalar(x)),'width'              ;...
    @(x)(ischar(x)||isscalar(x)),'xoffset'            ;...
    @(x)(ischar(x)||isscalar(x)),'yoffset'                      
    }},...
    'legend',{{...
    @isscalar                   ,'box_spacing'              ;...
    @(x)islogical(x)||(isscalar(x)&&x<2),'equalboxwidth'    ;...
    @ischar                     ,'extra_instructions'       ;...    
    @(x)(ischar(x)||isscalar(x)),'fontsize'                 ;...
    @ischar                     ,'justify'                  ;...    
    @(x)(ischar(x)||isscalar(x)),'length'                   ;...
    @isscalar                   ,'lineThick'                ;...
    @ischar                     ,'map_annot_offset_primary' ;...
    @(x)(ischar(x)||isscalar(x)),'map_tick_length_primary'  ;...
    @(x)(ischar(x)||isscalar(x)),'map_tick_length_secondary';...
    @ischar                     ,'orientation'              ;...
    @isscalar                   ,'sidebar'                  ;...
    @iscellstr                  ,'tick_annotations'         ;...
    @ischar                     ,'tick_annotation_format'   ;...
    @(x)islogical(x)||(isscalar(x) && x<2),'tick_centering' ;...
    @isscalar                   ,'tick_spacing'             ;...
    @(x)(ischar(x)||isscalar(x)),'width'                    ;...
    @(x)(ischar(x)||isscalar(x)),'xoffset'                  ;...
    @(x)(ischar(x)||isscalar(x)),'yoffset'                  }},...
    'locations',{{...
    @isscalar  			,'lat'                  ;...
    @isscalar			,'lon'                  ;...
    @ischar				,'symbol'               ;...
    @ischar				,'symbolcolor'          ;...
    @ischar			    ,'symbolsize'           ;...
    % This is the same as pstext
    @ischar			    ,'text'                 ;...
    @ischar	            ,'color'                ;...
    @(x)isscalar(x)||ischar(x),'font'           ;...
    @(x)isscalar(x)||ischar(x),'justify'        ;...
    @isscalar			,'angle'                ;...
    @ischar			    ,'fontsize'             }},...
    'nearneighbor',{{...
    @isscalar			,'memGB'                ;...
    @ischar				,'search'               ;...
    @isscalar			,'resolution'           }},...
    'proj',{{...
    @isscalar           ,'center'               ;...
    @(x)(ischar(x)||isscalar(x)),'map_width'    ;...
    @ischar             ,'projection'           }},...
    'psbasemap',{{...
    @ischar             ,'axes'                 ;...
    @ischar             ,'ticks'                }},...
    'pscoast',{{...
    @isscalar			,'features'             ;...
    @ischar				,'resolution'           ;...
    @ischar				,'rivers'               ;...
    @ischar			    ,'width'                ;...
    @ischar				,'color'                }},...
    'pspoly',{{...
    @iscell             ,'coord'                ;...
    @iscell             ,'color'                ;...
    @iscell             ,'thick'                }},...
    'pstext',{{...
    @ischar			    ,'text'                 ;...
    @isscalar			,'lat'                  ;...
    @isscalar			,'lon'                  ;...
    @ischar	            ,'color'                ;...
    @(x)isscalar(x)||ischar(x),'font'           ;...
    @isscalar			,'justify'              ;...
    @isscalar			,'angle'                ;...
    @ischar			    ,'fontsize'                }});
