% N_ICE_WARREN08   Complex refractive index for ice
%
%    This parameterisation is a compilation and merge of data across the EM
%    spectrum. The valid wavelength range is 44 nm to 2 m. The data are
%    valid for 266 K, no temperature variation is included.
%
%    See further:  Warren, S. G., and R. E. Brandt (2008), Optical 
%    constants of ice from the ultraviolet to the microwave: A revised 
%    compilation. J. Geophys. Res., 113, D14220, doi:10.1029/2007JD009744.
%
% FORMAT   n = n_ice_warren08( lambda )
%        
% OUT   n        Complex refractive index
% IN    lambda   Vector of wavelengths [m]

% 2013-11-29   Created by Patrick Eriksson.


function n = n_ice_warren08( lambda )
  
% la [um], real, imag
dat = [
4.430E-002    0.8228  1.640E-001
4.510E-002    0.8250  1.730E-001
4.590E-002    0.8255  1.830E-001
4.680E-002    0.8258  1.950E-001
4.770E-002    0.8263  2.080E-001
4.860E-002    0.8281  2.230E-001
4.960E-002    0.8347  2.400E-001
5.060E-002    0.8428  2.500E-001
5.170E-002    0.8483  2.590E-001
5.280E-002    0.8505  2.680E-001
5.390E-002    0.8497  2.790E-001
5.510E-002    0.8489  2.970E-001
5.640E-002    0.8519  3.190E-001
5.770E-002    0.8566  3.400E-001
5.900E-002    0.8647  3.660E-001
6.050E-002    0.8797  3.920E-001
6.200E-002    0.8970  4.160E-001
6.360E-002    0.9173  4.400E-001
6.530E-002    0.9400  4.640E-001
6.700E-002    0.9679  4.920E-001
6.890E-002    1.0093  5.170E-001
7.080E-002    1.0536  5.280E-001
7.290E-002    1.0986  5.330E-001
7.380E-002    1.1183  5.340E-001
7.510E-002    1.1449  5.310E-001
7.750E-002    1.1885  5.240E-001
8.000E-002    1.2273  5.100E-001
8.270E-002    1.2629  5.000E-001
8.550E-002    1.3117  4.990E-001
8.860E-002    1.3807  4.680E-001
9.180E-002    1.4091  3.800E-001
9.300E-002    1.4028  3.600E-001
9.540E-002    1.3948  3.390E-001
9.920E-002    1.3964  3.180E-001
1.033E-001    1.4047  2.910E-001
1.078E-001    1.3981  2.510E-001
1.100E-001    1.3886  2.440E-001
1.127E-001    1.3806  2.390E-001
1.140E-001    1.3772  2.390E-001
1.181E-001    1.3783  2.440E-001
1.210E-001    1.3929  2.470E-001
1.240E-001    1.4061  2.240E-001
1.272E-001    1.3999  1.950E-001
1.295E-001    1.3777  1.740E-001
1.305E-001    1.3607  1.720E-001
1.319E-001    1.3389  1.800E-001
1.333E-001    1.3210  1.940E-001
1.348E-001    1.3030  2.130E-001
1.362E-001    1.2871  2.430E-001
1.370E-001    1.2849  2.710E-001
1.378E-001    1.2851  2.890E-001
1.387E-001    1.2970  3.340E-001
1.393E-001    1.3151  3.440E-001
1.409E-001    1.3575  3.820E-001
1.425E-001    1.4130  4.010E-001
1.435E-001    1.4525  4.065E-001
1.442E-001    1.4845  4.050E-001
1.450E-001    1.5157  3.890E-001
1.459E-001    1.5484  3.770E-001
1.468E-001    1.5729  3.450E-001
1.476E-001    1.5915  3.320E-001
1.480E-001    1.6021  3.150E-001
1.485E-001    1.6077  2.980E-001
1.494E-001    1.6156  2.740E-001
1.512E-001    1.6220  2.280E-001
1.531E-001    1.6311  1.980E-001
1.540E-001    1.6345  1.720E-001
1.550E-001    1.6363  1.560E-001
1.569E-001    1.6353  1.100E-001
1.580E-001    1.6309  8.300E-002
1.589E-001    1.6214  5.800E-002
1.610E-001    1.5818  2.200E-002
1.630E-001    1.5482  8.473E-003
1.650E-001    1.5225  3.263E-003
1.670E-001    1.5027  1.256E-003
1.690E-001    1.4870  4.837E-004
1.710E-001    1.4743  1.862E-004
1.730E-001    1.4635  7.165E-005
1.750E-001    1.4543  2.757E-005
1.770E-001    1.4462  1.061E-005
1.790E-001    1.4390  4.081E-006
1.810E-001    1.4326  1.570E-006
1.830E-001    1.4268  5.403E-007
1.850E-001    1.4215  1.829E-007
1.870E-001    1.4167  6.218E-008
1.890E-001    1.4122  2.113E-008
1.910E-001    1.4081  7.181E-009
1.930E-001    1.4043  2.440E-009
1.950E-001    1.4007  8.289E-010
1.970E-001    1.3974  2.816E-010
1.990E-001    1.3943  9.565E-011
2.010E-001    1.3914  3.249E-011
2.019E-001    1.3901  2.0E-011
2.100E-001    1.3801  2.0E-011
2.500E-001    1.3509  2.0E-011
3.000E-001    1.3339  2.0E-011
3.500E-001    1.3249  2.0E-011
3.900E-001    1.3203  2.0E-011
4.000E-001    1.3194  2.365E-011
4.100E-001    1.3185  2.669E-011
4.200E-001    1.3177  3.135E-011
4.300E-001    1.3170  4.140E-011
4.400E-001    1.3163  6.268E-011
4.500E-001    1.3157  9.239E-011
4.600E-001    1.3151  1.325E-010
4.700E-001    1.3145  1.956E-010
4.800E-001    1.3140  2.861E-010
4.900E-001    1.3135  4.172E-010
5.000E-001    1.3130  5.889E-010
5.100E-001    1.3126  8.036E-010
5.200E-001    1.3121  1.076E-009
5.300E-001    1.3117  1.409E-009
5.400E-001    1.3114  1.813E-009
5.500E-001    1.3110  2.289E-009
5.600E-001    1.3106  2.839E-009
5.700E-001    1.3103  3.461E-009
5.800E-001    1.3100  4.159E-009
5.900E-001    1.3097  4.930E-009
6.000E-001    1.3094  5.730E-009
6.100E-001    1.3091  6.890E-009
6.200E-001    1.3088  8.580E-009
6.300E-001    1.3085  1.040E-008
6.400E-001    1.3083  1.220E-008
6.500E-001    1.3080  1.430E-008
6.600E-001    1.3078  1.660E-008
6.700E-001    1.3076  1.890E-008
6.800E-001    1.3073  2.090E-008
6.900E-001    1.3071  2.400E-008
7.000E-001    1.3069  2.900E-008
7.100E-001    1.3067  3.440E-008
7.200E-001    1.3065  4.030E-008
7.300E-001    1.3062  4.300E-008
7.400E-001    1.3060  4.920E-008
7.500E-001    1.3059  5.870E-008
7.600E-001    1.3057  7.080E-008
7.700E-001    1.3055  8.580E-008
7.800E-001    1.3053  1.020E-007
7.900E-001    1.3051  1.180E-007
8.000E-001    1.3049  1.340E-007
8.100E-001    1.3047  1.400E-007
8.200E-001    1.3046  1.430E-007
8.300E-001    1.3044  1.450E-007
8.400E-001    1.3042  1.510E-007
8.500E-001    1.3040  1.830E-007
8.600E-001    1.3039  2.150E-007
8.700E-001    1.3037  2.650E-007
8.800E-001    1.3035  3.350E-007
8.900E-001    1.3033  3.920E-007
9.000E-001    1.3032  4.200E-007
9.100E-001    1.3030  4.440E-007
9.200E-001    1.3028  4.740E-007
9.300E-001    1.3027  5.110E-007
9.400E-001    1.3025  5.530E-007
9.500E-001    1.3023  6.020E-007
9.600E-001    1.3022  7.550E-007
9.700E-001    1.3020  9.260E-007
9.800E-001    1.3019  1.120E-006
9.900E-001    1.3017  1.330E-006
1.000E+000    1.3015  1.620E-006
1.010E+000    1.3014  2.000E-006
1.020E+000    1.3012  2.250E-006
1.030E+000    1.3010  2.330E-006
1.040E+000    1.3009  2.330E-006
1.050E+000    1.3007  2.170E-006
1.060E+000    1.3005  1.960E-006
1.070E+000    1.3003  1.810E-006
1.080E+000    1.3002  1.740E-006
1.090E+000    1.3000  1.730E-006
1.100E+000    1.2998  1.700E-006
1.110E+000    1.2997  1.760E-006
1.120E+000    1.2995  1.820E-006
1.130E+000    1.2993  2.040E-006
1.140E+000    1.2991  2.250E-006
1.150E+000    1.2990  2.290E-006
1.160E+000    1.2988  3.040E-006
1.170E+000    1.2986  3.840E-006
1.180E+000    1.2984  4.770E-006
1.190E+000    1.2982  5.760E-006
1.200E+000    1.2980  6.710E-006
1.210E+000    1.2979  8.660E-006
1.220E+000    1.2977  1.020E-005
1.230E+000    1.2975  1.130E-005
1.240E+000    1.2973  1.220E-005
1.250E+000    1.2971  1.290E-005
1.260E+000    1.2969  1.320E-005
1.270E+000    1.2967  1.350E-005
1.280E+000    1.2965  1.330E-005
1.290E+000    1.2963  1.320E-005
1.300E+000    1.2961  1.320E-005
1.310E+000    1.2959  1.310E-005
1.320E+000    1.2957  1.320E-005
1.330E+000    1.2955  1.320E-005
1.340E+000    1.2953  1.340E-005
1.350E+000    1.2951  1.390E-005
1.360E+000    1.2949  1.420E-005
1.370E+000    1.2946  1.480E-005
1.380E+000    1.2944  1.580E-005
1.390E+000    1.2941  1.740E-005
1.400E+000    1.2939  1.980E-005
1.410E+000    1.2937  3.442E-005
1.420E+000    1.2934  5.959E-005
1.430E+000    1.2931  1.028E-004
1.440E+000    1.2929  1.516E-004
1.449E+000    1.2927  2.030E-004
1.460E+000    1.2924  2.942E-004
1.471E+000    1.2921  3.987E-004
1.481E+000    1.2920  4.941E-004
1.493E+000    1.2918  5.532E-004
1.504E+000    1.2916  5.373E-004
1.515E+000    1.2914  5.143E-004
1.527E+000    1.2912  4.908E-004
1.538E+000    1.2909  4.594E-004
1.563E+000    1.2903  3.858E-004
1.587E+000    1.2897  3.105E-004
1.613E+000    1.2890  2.659E-004
1.650E+000    1.2879  2.361E-004
1.680E+000    1.2870  2.046E-004
1.700E+000    1.2863  1.875E-004
1.730E+000    1.2853  1.650E-004
1.760E+000    1.2843  1.522E-004
1.800E+000    1.2828  1.411E-004
1.830E+000    1.2816  1.302E-004
1.840E+000    1.2811  1.310E-004
1.850E+000    1.2807  1.339E-004
1.855E+000    1.2805  1.377E-004
1.860E+000    1.2802  1.432E-004
1.870E+000    1.2797  1.632E-004
1.890E+000    1.2788  2.566E-004
1.905E+000    1.2780  4.081E-004
1.923E+000    1.2771  7.060E-004
1.942E+000    1.2762  1.108E-003
1.961E+000    1.2756  1.442E-003
1.980E+000    1.2750  1.614E-003
2.000E+000    1.2744  1.640E-003
2.020E+000    1.2736  1.566E-003
2.041E+000    1.2728  1.458E-003
2.062E+000    1.2718  1.267E-003
2.083E+000    1.2707  1.023E-003
2.105E+000    1.2694  7.586E-004
2.130E+000    1.2677  5.255E-004
2.150E+000    1.2663  4.025E-004
2.170E+000    1.2648  3.235E-004
2.190E+000    1.2633  2.707E-004
2.220E+000    1.2609  2.228E-004
2.240E+000    1.2591  2.037E-004
2.245E+000    1.2587  2.026E-004
2.250E+000    1.2582  2.035E-004
2.260E+000    1.2573  2.078E-004
2.270E+000    1.2564  2.171E-004
2.290E+000    1.2545  2.538E-004
2.310E+000    1.2525  3.138E-004
2.330E+000    1.2504  3.858E-004
2.350E+000    1.2482  4.591E-004
2.370E+000    1.2459  5.187E-004
2.390E+000    1.2435  5.605E-004
2.410E+000    1.2409  5.956E-004
2.430E+000    1.2382  6.259E-004
2.460E+000    1.2337  6.820E-004
2.500E+000    1.2270  7.530E-004
2.520E+000    1.2232  7.685E-004
2.550E+000    1.2169  7.647E-004
2.565E+000    1.2135  7.473E-004
2.580E+000    1.2097  7.392E-004
2.590E+000    1.2071  7.437E-004
2.600E+000    1.2043  7.543E-004
2.620E+000    1.1983  8.059E-004
2.675E+000    1.1776  1.367E-003
2.725E+000    1.1507  3.508E-003
2.778E+000    1.1083  1.346E-002
2.817E+000    1.0657  3.245E-002
2.833E+000    1.0453  4.572E-002
2.849E+000    1.0236  6.287E-002
2.865E+000    1.0001  8.548E-002
2.882E+000    0.9747  1.198E-001
2.899E+000    0.9563  1.690E-001
2.915E+000    0.9538  2.210E-001
2.933E+000    0.9678  2.760E-001
2.950E+000    0.9873  3.120E-001
2.967E+000    1.0026  3.470E-001
2.985E+000    1.0180  3.880E-001
3.003E+000    1.0390  4.380E-001
3.021E+000    1.0722  4.930E-001
3.040E+000    1.1259  5.540E-001
3.058E+000    1.2089  6.120E-001
3.077E+000    1.3215  6.250E-001
3.096E+000    1.4225  5.930E-001
3.115E+000    1.4933  5.390E-001
3.135E+000    1.5478  4.910E-001
3.155E+000    1.5970  4.380E-001
3.175E+000    1.6336  3.720E-001
3.195E+000    1.6477  3.000E-001
3.215E+000    1.6405  2.380E-001
3.236E+000    1.6248  1.930E-001
3.257E+000    1.6108  1.580E-001
3.279E+000    1.5905  1.210E-001
3.300E+000    1.5714  1.030E-001
3.322E+000    1.5559  8.360E-002
3.345E+000    1.5396  6.680E-002
3.367E+000    1.5241  5.312E-002
3.390E+000    1.5086  4.286E-002
3.413E+000    1.4949  3.523E-002
3.436E+000    1.4827  2.887E-002
3.460E+000    1.4710  2.347E-002
3.484E+000    1.4604  1.921E-002
3.509E+000    1.4502  1.586E-002
3.534E+000    1.4411  1.326E-002
3.559E+000    1.4328  1.130E-002
3.624E+000    1.4146  8.146E-003
3.732E+000    1.3924  6.672E-003
3.775E+000    1.3850  6.966E-003
3.847E+000    1.3750  8.248E-003
3.969E+000    1.3623  1.112E-002
4.099E+000    1.3526  1.471E-002
4.239E+000    1.3447  1.867E-002
4.348E+000    1.3406  2.411E-002
4.387E+000    1.3401  2.656E-002
4.444E+000    1.3412  2.990E-002
4.505E+000    1.3444  3.179E-002
4.547E+000    1.3473  3.090E-002
4.560E+000    1.3482  3.007E-002
4.580E+000    1.3491  2.883E-002
4.719E+000    1.3470  1.940E-002
4.904E+000    1.3379  1.347E-002
5.000E+000    1.3325  1.240E-002
5.100E+000    1.3268  1.220E-002
5.200E+000    1.3212  1.302E-002
5.263E+000    1.3176  1.380E-002
5.400E+000    1.3100  1.683E-002
5.556E+000    1.3013  2.232E-002
5.714E+000    1.2933  3.256E-002
5.747E+000    1.2917  3.539E-002
5.780E+000    1.2906  3.883E-002
5.814E+000    1.2902  4.270E-002
5.848E+000    1.2904  4.643E-002
5.882E+000    1.2915  5.045E-002
6.061E+000    1.3015  6.439E-002
6.135E+000    1.3083  6.560E-002
6.250E+000    1.3152  6.360E-002
6.289E+000    1.3167  6.265E-002
6.329E+000    1.3178  6.170E-002
6.369E+000    1.3187  6.101E-002
6.410E+000    1.3194  6.031E-002
6.452E+000    1.3201  5.964E-002
6.494E+000    1.3207  5.899E-002
6.579E+000    1.3214  5.780E-002
6.667E+000    1.3219  5.700E-002
6.757E+000    1.3229  5.680E-002
6.897E+000    1.3242  5.428E-002
7.042E+000    1.3244  5.161E-002
7.143E+000    1.3236  4.940E-002
7.246E+000    1.3229  4.840E-002
7.353E+000    1.3218  4.600E-002
7.463E+000    1.3200  4.440E-002
7.576E+000    1.3183  4.290E-002
7.692E+000    1.3158  4.041E-002
7.812E+000    1.3123  3.911E-002
7.937E+000    1.3086  3.819E-002
8.065E+000    1.3047  3.760E-002
8.197E+000    1.3007  3.724E-002
8.333E+000    1.2964  3.700E-002
8.475E+000    1.2917  3.677E-002
8.696E+000    1.2835  3.654E-002
8.929E+000    1.2735  3.664E-002
9.091E+000    1.2655  3.706E-002
9.259E+000    1.2561  3.789E-002
9.524E+000    1.2387  4.026E-002
9.804E+000    1.2151  4.450E-002
1.000E+001    1.1926  5.008E-002
1.020E+001    1.1659  6.461E-002
1.031E+001    1.1501  7.500E-002
1.042E+001    1.1323  8.800E-002
1.053E+001    1.1136  1.080E-001
1.064E+001    1.0971  1.340E-001
1.075E+001    1.0867  1.680E-001
1.087E+001    1.0833  2.040E-001
1.100E+001    1.0886  2.480E-001
1.111E+001    1.1023  2.800E-001
1.136E+001    1.1439  3.410E-001
1.163E+001    1.1983  3.790E-001
1.190E+001    1.2546  4.090E-001
1.220E+001    1.3194  4.220E-001
1.250E+001    1.3822  4.220E-001
1.282E+001    1.4412  4.030E-001
1.299E+001    1.4683  3.890E-001
1.316E+001    1.4928  3.740E-001
1.333E+001    1.5132  3.540E-001
1.351E+001    1.5300  3.350E-001
1.370E+001    1.5458  3.150E-001
1.389E+001    1.5596  2.940E-001
1.408E+001    1.5701  2.710E-001
1.429E+001    1.5775  2.460E-001
1.471E+001    1.5762  1.980E-001
1.515E+001    1.5637  1.640E-001
1.538E+001    1.5559  1.520E-001
1.563E+001    1.5481  1.420E-001
1.613E+001    1.5353  1.280E-001
1.639E+001    1.5302  1.250E-001
1.667E+001    1.5294  1.230E-001
1.695E+001    1.5306  1.160E-001
1.724E+001    1.5303  1.070E-001
1.818E+001    1.5141  7.900E-002
1.832E+001    1.5104  7.752E-002
1.861E+001    1.5043  7.455E-002
1.887E+001    1.4982  7.200E-002
1.923E+001    1.4939  7.600E-002
1.961E+001    1.4963  7.500E-002
2.000E+001    1.4986  6.700E-002
2.041E+001    1.4956  5.500E-002
2.083E+001    1.4877  4.500E-002
2.222E+001    1.4575  2.900E-002
2.260E+001    1.4486  2.750E-002
2.305E+001    1.4390  2.700E-002
2.360E+001    1.4282  2.730E-002
2.460E+001    1.4102  2.890E-002
2.500E+001    1.4030  3.000E-002
2.600E+001    1.3854  3.400E-002
2.857E+001    1.3404  5.122E-002
3.100E+001    1.2969  8.615E-002
3.333E+001    1.2641  1.348E-001
3.448E+001    1.2530  1.615E-001
3.564E+001    1.2445  1.895E-001
3.700E+001    1.2371  2.227E-001
3.824E+001    1.2317  2.528E-001
3.960E+001    1.2243  2.853E-001
4.114E+001    1.2054  3.240E-001
4.276E+001    1.1742  3.945E-001
4.358E+001    1.1549  4.521E-001
4.458E+001    1.1496  5.535E-001
4.550E+001    1.1853  6.782E-001
4.615E+001    1.2543  7.684E-001
4.671E+001    1.3474  8.254E-001
4.736E+001    1.4725  8.458E-001
4.800E+001    1.5874  8.158E-001
4.878E+001    1.6841  7.414E-001
5.003E+001    1.7505  6.191E-001
5.128E+001    1.7649  5.353E-001
5.275E+001    1.7668  4.780E-001
5.350E+001    1.7687  4.599E-001
5.424E+001    1.7792  4.468E-001
5.500E+001    1.7955  4.214E-001
5.574E+001    1.8052  3.860E-001
5.640E+001    1.8041  3.508E-001
5.700E+001    1.7940  3.196E-001
5.746E+001    1.7805  2.981E-001
5.840E+001    1.7410  2.659E-001
5.929E+001    1.6930  2.569E-001
6.000E+001    1.6610  2.785E-001
6.100E+001    1.6419  3.076E-001
6.125E+001    1.6396  3.146E-001
6.250E+001    1.6372  3.471E-001
6.378E+001    1.6471  3.748E-001
6.467E+001    1.6596  3.902E-001
6.558E+001    1.6754  4.024E-001
6.655E+001    1.6945  4.115E-001
6.760E+001    1.7167  4.167E-001
6.900E+001    1.7466  4.167E-001
7.053E+001    1.7780  4.089E-001
7.300E+001    1.8185  3.830E-001
7.500E+001    1.8419  3.543E-001
7.629E+001    1.8504  3.340E-001
8.000E+001    1.8617  2.944E-001
8.297E+001    1.8669  2.679E-001
8.500E+001    1.8688  2.519E-001
8.680E+001    1.8699  2.390E-001
9.080E+001    1.8698  2.140E-001
9.517E+001    1.8681  1.913E-001
1.000E+002    1.8654  1.706E-001
1.200E+002    1.8499  1.151E-001
1.600E+002    1.8268  6.684E-002
2.100E+002    1.8114  4.282E-002
3.000E+002    1.7989  2.549E-002
5.000E+002    1.7908  1.405E-002
1.300E+003    1.7868  5.173E-003
5.000E+003    1.7861  1.337E-003
1.900E+004    1.7861  3.574E-004
3.900E+004    1.7861  1.839E-004
6.100E+004    1.7861  1.294E-004
8.600E+004    1.7861  1.058E-004
1.100E+005    1.7861  9.675E-005
1.400E+005    1.7861  9.360E-005
1.800E+005    1.7861  9.613E-005
2.400E+005    1.7861  1.066E-004
3.400E+005    1.7861  1.312E-004
5.400E+005    1.7861  1.895E-004
1.000E+006    1.7861  3.348E-004
2.000E+006    1.7861  6.596E-004];


% Data and interpolation approach taken from 
% http://www.atmos.washington.edu/ice_optical_constants/ 

b = interp1( log(dat(:,1)), [dat(:,2),log(dat(:,3))], log(lambda*1e6) );

n = b(:,1) + i*exp(b(:,2));
